/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.envisat;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.io.CsvReader;
import org.esa.snap.dataio.envisat.BandInfo;
import org.esa.snap.dataio.envisat.BandLineReader;
import org.esa.snap.dataio.envisat.DDDBException;
import org.esa.snap.dataio.envisat.FieldInfo;
import org.esa.snap.dataio.envisat.FieldRef;
import org.esa.snap.dataio.envisat.ProductFile;
import org.esa.snap.dataio.envisat.Record;
import org.esa.snap.dataio.envisat.RecordInfo;
import org.esa.snap.dataio.envisat.RecordReader;

public class DDDB {
    public static final String SMODEL_1OF1_NAME = "1OF1";
    public static final String SMODEL_1OF2_NAME = "1OF2";
    public static final String SMODEL_2OF2_NAME = "2OF2";
    public static final String SMODEL_2TOF_NAME = "2TOF";
    public static final String SMODEL_3TOI_NAME = "3TOI";
    public static final String SCALE_LINEAR_NAME = "Linear_Scale";
    public static final String SCALE_LOG_NAME = "Log_Scale";
    public static final String EXPRESSION_PREFIX = "=";
    private static final Map<String, URL> resourceMap = new HashMap<String, URL>(100);
    private static URL emptyURL;
    public static final String DB_DIR_PATH = "/org/esa/snap/resources/dddb";
    public static final char[] FIELD_SEPARATORS;
    public static final char[] DIMSIZE_SEPARATORS;
    public static final String NULL_VALUE_STRING = "*";
    private final int _firstBinaryDsIndex = 3;
    private final Map _productInfoCache = new Hashtable(16);

    public static DDDB getInstance() {
        return Holder.instance;
    }

    public String[] getDatasetNames(String productType) throws DDDBException {
        ProductInfo productInfo = this.getProductInfo(productType);
        Debug.assertNotNull((Object)productInfo);
        int i0 = 3;
        int numBinaryDatasets = productInfo.datasetInfos.size() - i0;
        if (numBinaryDatasets < 0) {
            throw new DDDBException("illegal DDDB file content for product type '" + productType + "'");
        }
        String[] datasetNames = new String[numBinaryDatasets];
        for (int i = i0; i < productInfo.datasetInfos.size(); ++i) {
            datasetNames[i - i0] = ((DatasetInfo)productInfo.datasetInfos.elementAt((int)i)).datasetName;
        }
        return datasetNames;
    }

    public String getProductDescription(String productType) throws DDDBException {
        ProductInfo productInfo = this.getProductInfo(productType);
        Debug.assertNotNull((Object)productInfo);
        return productInfo.description;
    }

    public String getDSDName(String productType, String datasetName) throws DDDBException {
        DatasetInfo datasetInfo = this.getDatasetInfo(productType, datasetName);
        Debug.assertNotNull((Object)datasetInfo);
        return datasetInfo.dsdName;
    }

    public RecordInfo readRecordInfo(String productType, String datasetName, Map parameters) throws DDDBException {
        Guardian.assertNotNullOrEmpty((String)"productType", (String)productType);
        Guardian.assertNotNullOrEmpty((String)"datasetName", (String)datasetName);
        String recordInfoFilePath = this.getRecordInfoFilePath(productType, datasetName);
        return this.readRecordInfoPath(recordInfoFilePath, datasetName, parameters);
    }

    private RecordInfo readRecordInfoPath(String recordInfoFilePath, String datasetName, Map parameters) throws DDDBException {
        String[] tokens;
        URL url = DDDB.getDatabaseResource(recordInfoFilePath);
        CsvReader csvReader = DDDB.openCsvReader(url);
        RecordInfo recordInfo = null;
        int lineIndex = 0;
        boolean subExpressionDetected = false;
        while ((tokens = this.readCsvRecord(csvReader, url)) != null) {
            if (!DDDB.isValidDataLine(tokens)) continue;
            if (lineIndex == 0) {
                recordInfo = new RecordInfo(datasetName);
            } else {
                String fieldName = null;
                String dataTypeStr = null;
                int dataType = 0;
                int fieldSize = 0;
                int numDataElems = 1;
                String unit = "";
                String description = "";
                block10: for (int columnIndex = 0; columnIndex < tokens.length; ++columnIndex) {
                    String token = tokens[columnIndex];
                    switch (columnIndex) {
                        case 0: {
                            fieldName = token;
                            continue block10;
                        }
                        case 1: {
                            dataTypeStr = token;
                            if (dataTypeStr.startsWith("@+")) {
                                subExpressionDetected = true;
                                continue block10;
                            }
                            subExpressionDetected = false;
                            dataType = DDDB.getFieldType(dataTypeStr);
                            if (dataType != 0) continue block10;
                            this.raiseSyntaxError(csvReader, url, "undefined DDDB data type '" + token + "'");
                            continue block10;
                        }
                        case 2: {
                            unit = token;
                            continue block10;
                        }
                        case 3: {
                            fieldSize = DDDB.parseIntegerField(token, parameters);
                            continue block10;
                        }
                        case 4: {
                            numDataElems *= DDDB.parseIntegerField(token, parameters);
                            continue block10;
                        }
                        case 5: {
                            numDataElems *= DDDB.parseIntegerField(token, parameters);
                            continue block10;
                        }
                        case 6: {
                            description = token;
                        }
                    }
                }
                if (fieldName != null) {
                    if (subExpressionDetected) {
                        String prefixStr;
                        String subDatasetPath = recordInfoFilePath.substring(0, recordInfoFilePath.lastIndexOf(47));
                        subDatasetPath = subDatasetPath + '/' + dataTypeStr.substring(2, dataTypeStr.length());
                        RecordInfo subRecord = this.readRecordInfoPath(subDatasetPath, dataTypeStr, parameters);
                        String prefix = prefixStr = dataTypeStr.substring(2, dataTypeStr.length() - 3);
                        for (int n = 1; n <= numDataElems; ++n) {
                            if (numDataElems > 1) {
                                prefix = prefixStr + '.' + n;
                            }
                            recordInfo.add(subRecord, prefix);
                        }
                        recordInfo.updateSizeInBytes();
                    } else {
                        if (dataTypeStr.equalsIgnoreCase("Spare") && fieldSize > 0 && numDataElems == 1) {
                            numDataElems = fieldSize;
                            fieldSize = 1;
                            Debug.trace((String)("DDDB: spares detected and adjusted: numDataElems = " + numDataElems));
                        }
                        if (dataType != 41) {
                            if (fieldSize != FieldInfo.getDataTypeElemSize(dataType)) {
                                DDDB.closeCsvReader(csvReader, url);
                                throw new DDDBException("DDDB integrity check failed: " + recordInfoFilePath + ": field " + fieldName + ": field size mismatch: " + fieldSize + " != " + FieldInfo.getDataTypeElemSize(dataType));
                            }
                        } else {
                            Debug.trace((String)("DDDB files ASCII - name: " + fieldName + " fieldSize: " + fieldSize));
                            numDataElems = fieldSize;
                        }
                        Debug.assertTrue((recordInfo != null ? 1 : 0) != 0);
                        recordInfo.add(fieldName, dataType, numDataElems, unit, description);
                    }
                }
            }
            ++lineIndex;
        }
        DDDB.closeCsvReader(csvReader, url);
        if (recordInfo == null || recordInfo.getNumFieldInfos() == 0) {
            throw new DDDBException("database resource is empty: file " + recordInfoFilePath);
        }
        return recordInfo;
    }

    public BandLineReader[] getBandLineReaders(ProductFile productFile) throws DDDBException {
        String[] tokens;
        Guardian.assertNotNull((String)"productFile", (Object)productFile);
        String gadsName = productFile.getGADSName();
        Record gadsRecord = productFile.getGADS();
        String filePath = "bands/" + productFile.getDddbProductType() + ".dd";
        URL url = DDDB.getDatabaseResource(filePath);
        CsvReader csvReader = DDDB.openCsvReader(url);
        Vector<BandLineReader> readerList = new Vector<BandLineReader>();
        int lineIndex = 0;
        while ((tokens = this.readCsvRecord(csvReader, url)) != null) {
            if (!DDDB.isValidDataLine(tokens)) continue;
            if (lineIndex != 0) {
                if (tokens.length < 11) {
                    this.raiseSyntaxError(csvReader, url, "columns missing in record line");
                }
                String bandName = DDDB.getTokenValue(tokens[0]);
                String pixelDataRefStr = DDDB.getTokenValue(tokens[1]);
                String sampleModelName = DDDB.getTokenValue(tokens[2]);
                String bandDataTypeStr = DDDB.getTokenValue(tokens[3]);
                String spectrBandIndexStr = DDDB.getTokenValue(tokens[4]);
                String scalingMethodName = DDDB.getTokenValue(tokens[5]);
                String scalingOffsetStr = DDDB.getTokenValue(tokens[6]);
                String scalingFactorStr = DDDB.getTokenValue(tokens[7]);
                String bitmaskExpression = DDDB.getTokenValue(tokens[8]);
                String flagsFileRefStr = DDDB.getTokenValue(tokens[9]);
                String unit = DDDB.getTokenValue(tokens[10]);
                String description = DDDB.getTokenValue(tokens[11]);
                if (bandName == null || pixelDataRefStr == null || bandDataTypeStr == null) {
                    throw new DDDBException("malformed band info record in file '" + url + "'");
                }
                int bandDataType = DDDB.getFieldType(bandDataTypeStr);
                if (bandDataType == 0) {
                    throw new DDDBException("invalid band datatype: " + bandDataTypeStr);
                }
                int spectrBandIndex = -1;
                if (spectrBandIndexStr != null) {
                    try {
                        spectrBandIndex = Integer.parseInt(spectrBandIndexStr);
                        if (--spectrBandIndex < 0) {
                            throw new DDDBException("invalid spectral band index for band '" + bandName + "'");
                        }
                    }
                    catch (NumberFormatException e) {
                        throw new DDDBException("invalid spectral band index for band '" + bandName + "'");
                    }
                }
                RecordReader pixelDataReader = null;
                int pixelDataFieldIndex = -1;
                String expression = null;
                String dataSetName = null;
                if (pixelDataRefStr.startsWith(EXPRESSION_PREFIX)) {
                    expression = pixelDataRefStr.substring(1).trim();
                } else {
                    FieldRef fieldRef = FieldRef.parse(pixelDataRefStr);
                    dataSetName = fieldRef.getDatasetName();
                    try {
                        pixelDataReader = productFile.getRecordReader(dataSetName);
                        pixelDataFieldIndex = fieldRef.getFieldIndex();
                    }
                    catch (IOException e) {
                        Debug.trace((String)("DDDB: " + e.getMessage()));
                        continue;
                    }
                }
                int sampleModel = 20;
                if (sampleModelName != null && (sampleModel = DDDB.getSampleModel(sampleModelName)) == -1) {
                    throw new DDDBException("invalid sample model name: " + sampleModelName);
                }
                double scalingOffset = 0.0;
                double scalingFactor = 1.0;
                int scalingMethod = 10;
                if (scalingMethodName != null) {
                    if (scalingOffsetStr == null || scalingFactorStr == null) {
                        throw new DDDBException("malformed band scaling info in file '" + url + "'");
                    }
                    scalingMethod = DDDB.getScalingMethod(scalingMethodName);
                    if (scalingMethod == -1) {
                        throw new DDDBException("invalid scaling method name: " + scalingMethodName);
                    }
                    scalingOffset = DDDB.resolveGadsValueDouble(scalingOffsetStr, gadsName, gadsRecord);
                    scalingFactor = DDDB.resolveGadsValueDouble(scalingFactorStr, gadsName, gadsRecord);
                }
                FlagCoding flagsCoding = null;
                if (flagsFileRefStr != null) {
                    if (flagsFileRefStr.startsWith("@/")) {
                        flagsFileRefStr = flagsFileRefStr.substring(2);
                    }
                    flagsCoding = this.readFlagsCoding(bandName, flagsFileRefStr);
                }
                BandInfo bandInfo = productFile.createBandInfo(bandName, bandDataType, spectrBandIndex, sampleModel, scalingMethod, scalingOffset, scalingFactor, bitmaskExpression, flagsCoding, unit, description, dataSetName);
                BandLineReader bandLineReader = pixelDataReader != null ? new BandLineReader(bandInfo, pixelDataReader, pixelDataFieldIndex) : new BandLineReader.Virtual(bandInfo, productFile.updateExpression(expression));
                readerList.add(bandLineReader);
            }
            ++lineIndex;
        }
        DDDB.closeCsvReader(csvReader, url);
        BandLineReader[] readers = new BandLineReader[readerList.size()];
        for (int i = 0; i < readers.length; ++i) {
            readers[i] = (BandLineReader)readerList.get(i);
        }
        return readers;
    }

    private static int getSampleModel(String sampleModelName) throws DDDBException {
        Guardian.assertNotNull((String)"sampleModelName", (Object)sampleModelName);
        int sampleModel = -1;
        if (sampleModelName.equalsIgnoreCase(SMODEL_1OF1_NAME)) {
            sampleModel = 20;
        } else if (sampleModelName.equalsIgnoreCase(SMODEL_1OF2_NAME)) {
            sampleModel = 21;
        } else if (sampleModelName.equalsIgnoreCase(SMODEL_2OF2_NAME)) {
            sampleModel = 22;
        } else if (sampleModelName.equalsIgnoreCase(SMODEL_2TOF_NAME)) {
            sampleModel = 23;
        } else if (sampleModelName.equalsIgnoreCase(SMODEL_3TOI_NAME)) {
            sampleModel = 24;
        }
        return sampleModel;
    }

    private static int getScalingMethod(String scalingMethodName) {
        Guardian.assertNotNull((String)"scalingMethodName", (Object)scalingMethodName);
        int scalingMethod = -1;
        if (scalingMethodName.equalsIgnoreCase(SCALE_LINEAR_NAME)) {
            scalingMethod = 11;
        } else if (scalingMethodName.equalsIgnoreCase(SCALE_LOG_NAME)) {
            scalingMethod = 12;
        }
        return scalingMethod;
    }

    private static String getTokenValue(String token) {
        if (token == null || token.length() == 0 || token.equals(NULL_VALUE_STRING)) {
            return null;
        }
        return token;
    }

    private static double resolveGadsValueDouble(String gadsRef, String gadsName, Record gadsRecord) throws DDDBException {
        Debug.assertNotNullOrEmpty((String)gadsRef);
        try {
            if (gadsName != null && gadsRef.startsWith(gadsName + ".")) {
                Debug.assertNotNull((Object)gadsRecord);
                FieldRef fieldRef = FieldRef.parse(gadsRef);
                return gadsRecord.getFieldAt(fieldRef.getFieldIndex()).getElemDouble(fieldRef.getElemIndex());
            }
            return Double.parseDouble(gadsRef);
        }
        catch (Exception e) {
            throw new DDDBException("failed to resolve GADS reference '" + gadsRef + "': " + e.getMessage());
        }
    }

    public static int getFieldType(String dataTypeName) {
        Guardian.assertNotNull((String)"dataTypeName", (Object)dataTypeName);
        if (dataTypeName.equalsIgnoreCase("SChar")) {
            return 10;
        }
        if (dataTypeName.equalsIgnoreCase("UChar")) {
            return 20;
        }
        if (dataTypeName.equalsIgnoreCase("SShort")) {
            return 11;
        }
        if (dataTypeName.equalsIgnoreCase("UShort")) {
            return 21;
        }
        if (dataTypeName.equalsIgnoreCase("SLong")) {
            return 12;
        }
        if (dataTypeName.equalsIgnoreCase("ULong")) {
            return 22;
        }
        if (dataTypeName.equalsIgnoreCase("Float")) {
            return 30;
        }
        if (dataTypeName.equalsIgnoreCase("Double")) {
            return 31;
        }
        if (dataTypeName.equalsIgnoreCase("String")) {
            return 41;
        }
        if (dataTypeName.equalsIgnoreCase("@/types/UTC.dd")) {
            return 51;
        }
        if (dataTypeName.equalsIgnoreCase("Spare")) {
            return 10;
        }
        Debug.trace((String)("DDDB: undefined datatype: " + dataTypeName));
        return 0;
    }

    public static String getFieldTypeName(int dataType) {
        switch (dataType) {
            case 10: {
                return "SChar";
            }
            case 20: {
                return "UChar";
            }
            case 11: {
                return "SShort";
            }
            case 21: {
                return "UShort";
            }
            case 12: {
                return "SLong";
            }
            case 22: {
                return "ULong";
            }
            case 30: {
                return "Float";
            }
            case 31: {
                return "Double";
            }
            case 51: {
                return "@/types/UTC.dd";
            }
            case 41: {
                return "String";
            }
            case 0: {
                return "?";
            }
        }
        throw new IllegalArgumentException("invalid data type ID: " + dataType);
    }

    private String getRecordInfoFilePath(String productType, String datasetName) throws DDDBException {
        DatasetInfo datasetInfo = this.getDatasetInfo(productType, datasetName);
        Debug.assertNotNull((Object)datasetInfo);
        return datasetInfo.recordInfoFilePath;
    }

    private ProductInfo getProductInfo(String productType) throws DDDBException {
        Guardian.assertNotNull((String)"productType", (Object)productType);
        ProductInfo productInfo = (ProductInfo)this._productInfoCache.get(productType);
        if (productInfo != null) {
            return productInfo;
        }
        productInfo = this.readProductInfo(productType);
        Debug.assertTrue((productInfo != null ? 1 : 0) != 0);
        this._productInfoCache.put(productType, productInfo);
        return productInfo;
    }

    private DatasetInfo getDatasetInfo(String productType, String datasetName) throws DDDBException {
        Guardian.assertNotNull((String)"productType", (Object)productType);
        Guardian.assertNotNull((String)"datasetName", (Object)datasetName);
        ProductInfo productInfo = this.getProductInfo(productType);
        Debug.assertNotNull((Object)productInfo);
        for (int i = 0; i < productInfo.datasetInfos.size(); ++i) {
            DatasetInfo datasetInfo = (DatasetInfo)productInfo.datasetInfos.get(i);
            if (!datasetInfo.datasetName.equalsIgnoreCase(datasetName)) continue;
            return datasetInfo;
        }
        throw new DDDBException("DDDB dataset information not found: product type '" + productType + "', dataset name '" + datasetName + "'");
    }

    private ProductInfo readProductInfo(String productType) throws DDDBException {
        String[] tokens;
        Debug.assertNotNull((Object)productType);
        String productInfoFilePath = "products/" + productType + ".dd";
        URL url = DDDB.getDatabaseResource(productInfoFilePath);
        CsvReader csvReader = DDDB.openCsvReader(url);
        int lineIndex = 0;
        ProductInfo productInfo = null;
        while ((tokens = this.readCsvRecord(csvReader, url)) != null) {
            if (DDDB.isValidDataLine(tokens)) {
                if (lineIndex == 0) {
                    String productName = null;
                    String description = null;
                    block11: for (int columnIndex = 0; columnIndex < tokens.length; ++columnIndex) {
                        String token = tokens[columnIndex];
                        switch (columnIndex) {
                            case 0: {
                                productName = token;
                                continue block11;
                            }
                            case 1: {
                                description = token;
                            }
                        }
                    }
                    if (productName != null) {
                        productInfo = new ProductInfo();
                        productInfo.productName = productName;
                        productInfo.description = description;
                    }
                } else {
                    String datasetName = null;
                    String recordInfoFilePath = null;
                    String dsdName = null;
                    String description = "";
                    block12: for (int columnIndex = 0; columnIndex < tokens.length; ++columnIndex) {
                        String token = tokens[columnIndex];
                        switch (columnIndex) {
                            case 0: {
                                datasetName = token;
                                continue block12;
                            }
                            case 1: {
                                recordInfoFilePath = token;
                                if (!recordInfoFilePath.startsWith("@/")) continue block12;
                                recordInfoFilePath = recordInfoFilePath.substring(2);
                                continue block12;
                            }
                            case 2: {
                                dsdName = token;
                                continue block12;
                            }
                            case 3: {
                                description = token;
                            }
                        }
                    }
                    if (productInfo != null && datasetName != null && recordInfoFilePath != null && dsdName != null) {
                        DatasetInfo datasetInfo = new DatasetInfo();
                        datasetInfo.datasetName = datasetName;
                        datasetInfo.recordInfoFilePath = recordInfoFilePath;
                        datasetInfo.dsdName = dsdName;
                        datasetInfo.description = description;
                        productInfo.datasetInfos.add(datasetInfo);
                    }
                }
            }
            ++lineIndex;
        }
        DDDB.closeCsvReader(csvReader, url);
        if (productInfo == null || productInfo.datasetInfos.size() == 0) {
            throw new DDDBException("DDDB resource is empty or invalid: file " + url);
        }
        return productInfo;
    }

    public FlagCoding readFlagsCoding(String bandName, String filePath) throws DDDBException {
        String[] tokens;
        Guardian.assertNotNullOrEmpty((String)"filePath", (String)filePath);
        URL url = DDDB.getDatabaseResource(filePath);
        CsvReader csvReader = DDDB.openCsvReader(url);
        FlagCoding flagsCoding = null;
        int lineIndex = 0;
        while ((tokens = this.readCsvRecord(csvReader, url)) != null) {
            if (!DDDB.isValidDataLine(tokens)) continue;
            if (lineIndex == 0) {
                flagsCoding = new FlagCoding(bandName);
            } else {
                String flagName = null;
                int flagMask = 0;
                String description = "";
                block6: for (int columnIndex = 0; columnIndex < tokens.length; ++columnIndex) {
                    String token = tokens[columnIndex];
                    switch (columnIndex) {
                        case 0: {
                            flagName = token;
                            continue block6;
                        }
                        case 1: {
                            String bitIndexStr = token;
                            flagMask = this.createFlagmask(bitIndexStr);
                            continue block6;
                        }
                        case 2: {
                            description = token;
                        }
                    }
                }
                if (flagName != null) {
                    flagsCoding.addFlag(flagName, flagMask, description);
                }
            }
            ++lineIndex;
        }
        DDDB.closeCsvReader(csvReader, url);
        if (flagsCoding == null || flagsCoding.getNumAttributes() == 0) {
            throw new DDDBException("database resource is empty: file " + filePath);
        }
        return flagsCoding;
    }

    private int createFlagmask(String bitIndexStr) {
        int flagMask = 0;
        if (bitIndexStr.indexOf(38) == -1) {
            int bitIndex = DDDB.parseIntegerField(bitIndexStr, null);
            flagMask = 1 << bitIndex;
        } else {
            StringTokenizer st = new StringTokenizer(bitIndexStr);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.indexOf(38) != -1) continue;
                try {
                    int bitIndex = DDDB.parseIntegerField(token, null);
                    flagMask |= 1 << bitIndex;
                }
                catch (NumberFormatException e) {
                    Debug.trace((Throwable)e);
                }
            }
        }
        return flagMask;
    }

    public static boolean isInstalled() {
        try {
            DDDB.getDatabaseResource("products/MER_RR__1P.dd");
            return true;
        }
        catch (DDDBException e) {
            return false;
        }
    }

    static URL getDatabaseResource(String resourcePath) throws DDDBException {
        String databasePath = "/org/esa/snap/resources/dddb/" + resourcePath;
        Debug.trace((String)("DDDB: searching for resource file '" + databasePath + "'"));
        URL url = resourceMap.get(databasePath);
        if (url == null) {
            url = DDDB.class.getResource(databasePath);
            resourceMap.put(databasePath, url);
        }
        if (url == null || url == emptyURL) {
            throw new DDDBException("DDDB resource not found: missing file: " + databasePath);
        }
        return url;
    }

    static boolean databaseResourceExists(String resourcePath) {
        String databasePath = "/org/esa/snap/resources/dddb/" + resourcePath;
        URL url = resourceMap.get(databasePath);
        if (url == null) {
            url = DDDB.class.getResource(databasePath);
            if (url != null) {
                resourceMap.put(databasePath, url);
            } else {
                resourceMap.put(databasePath, emptyURL);
            }
        }
        return url != null && url != emptyURL;
    }

    private static boolean isValidDataLine(String[] tokens) {
        Debug.assertNotNull((Object)tokens);
        return tokens.length > 0 && !tokens[0].startsWith("#");
    }

    private static int parseIntegerField(String numFieldElemsStr, Map parameters) throws DDDBException {
        Debug.assertNotNull((Object)numFieldElemsStr);
        if (numFieldElemsStr.length() == 0 || numFieldElemsStr.equals(NULL_VALUE_STRING)) {
            return 1;
        }
        StringTokenizer st = new StringTokenizer(numFieldElemsStr, new String(DIMSIZE_SEPARATORS));
        int numFieldElems = 1;
        while (st.hasMoreTokens()) {
            int factor;
            String token = st.nextToken().trim();
            try {
                factor = Integer.parseInt(token);
            }
            catch (NumberFormatException e) {
                if (parameters != null) {
                    Object value = parameters.get(token);
                    if (value == null) {
                        throw new DDDBException("missing DDDB field size parameter '" + token + "'");
                    }
                    if (!(value instanceof Number)) {
                        throw new DDDBException("illegal DDDB field size parameter '" + token + "': not a number");
                    }
                    factor = ((Number)value).intValue();
                }
                throw new DDDBException("invalid DDDB field size value '" + token + "'");
            }
            numFieldElems *= factor;
        }
        return numFieldElems;
    }

    private static CsvReader openCsvReader(URL url) throws DDDBException {
        Debug.assertNotNull((Object)url);
        try {
            return new CsvReader((Reader)new InputStreamReader(url.openStream()), FIELD_SEPARATORS);
        }
        catch (IOException e) {
            StringBuffer sb = new StringBuffer();
            sb.append("failed to open DDDB resource: ");
            sb.append(e.getMessage());
            sb.append(": file ");
            sb.append(url);
            throw new DDDBException(sb.toString());
        }
    }

    private static void closeCsvReader(CsvReader csvReader, URL url) {
        Debug.assertNotNull((Object)csvReader);
        Debug.assertNotNull((Object)url);
        try {
            csvReader.close();
        }
        catch (IOException e) {
            Debug.trace((String)("DDDB: I/O warning: failed to close DDDB file: " + url + ": " + e.getMessage()));
        }
    }

    private String[] readCsvRecord(CsvReader csvReader, URL url) throws DDDBException {
        Debug.assertNotNull((Object)csvReader);
        Debug.assertNotNull((Object)url);
        try {
            return csvReader.readRecord();
        }
        catch (IOException e) {
            DDDB.closeCsvReader(csvReader, url);
            StringBuffer sb = new StringBuffer();
            sb.append("failed to read from DDDB resource: ");
            sb.append(e.getMessage());
            sb.append(": file ");
            sb.append(url);
            throw new DDDBException(sb.toString());
        }
    }

    private void raiseSyntaxError(CsvReader csvReader, URL url, String message) throws DDDBException {
        StringBuffer sb = new StringBuffer();
        sb.append(message);
        sb.append(": file ");
        sb.append(url);
        sb.append(", ");
        sb.append("line ");
        sb.append(csvReader.getLineNumber());
        throw new DDDBException(sb.toString());
    }

    private DDDB() {
    }

    static {
        try {
            emptyURL = new URL("file:/empty");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        FIELD_SEPARATORS = new char[]{'|'};
        DIMSIZE_SEPARATORS = new char[]{',', '*'};
    }

    private static class Holder {
        private static final DDDB instance = new DDDB();

        private Holder() {
        }
    }

    private static class DatasetInfo {
        String datasetName;
        String recordInfoFilePath;
        String dsdName;
        String description;

        private DatasetInfo() {
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("DDDB.DatasetInfo[");
            sb.append("'");
            sb.append(this.datasetName);
            sb.append("','");
            sb.append(this.recordInfoFilePath);
            sb.append("','");
            sb.append(this.dsdName);
            sb.append("','");
            sb.append(this.description);
            sb.append("']");
            return sb.toString();
        }
    }

    private static class ProductInfo {
        String productName;
        String description;
        Vector datasetInfos = new Vector();

        private ProductInfo() {
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("DDDB.ProductInfo[");
            sb.append("'");
            sb.append(this.productName);
            sb.append("','");
            sb.append(this.description);
            sb.append("',\n");
            for (int i = 0; i < this.datasetInfos.size(); ++i) {
                sb.append("  ");
                sb.append(this.datasetInfos.get(i).toString());
                sb.append("\n");
            }
            sb.append("]");
            return sb.toString();
        }
    }
}

