/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.envisat;

import java.io.IOException;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.Debug;
import org.esa.snap.dataio.envisat.BandInfo;
import org.esa.snap.dataio.envisat.BandLineDecoder;
import org.esa.snap.dataio.envisat.Field;
import org.esa.snap.dataio.envisat.ProductFile;
import org.esa.snap.dataio.envisat.Record;
import org.esa.snap.dataio.envisat.RecordReader;

public class BandLineReader {
    private final BandInfo _bandInfo;
    private RecordReader _pixelDataReader;
    private Record _pixelDataRecord;
    private Field _pixelDataField;
    private BandLineDecoder _bandLineDecoder;
    private int _maxRecordIndex;
    private long fieldOffset;
    private int dataFieldSampleSize;

    private BandLineReader(BandInfo bandInfo) {
        this._bandInfo = bandInfo;
    }

    BandLineReader(BandInfo bandInfo, RecordReader pixelDataReader, int pixelDataFieldIndex) {
        this._bandInfo = bandInfo;
        this._pixelDataReader = pixelDataReader;
        this._pixelDataRecord = this._pixelDataReader.createCompatibleRecord();
        this._pixelDataField = this._pixelDataRecord.getFieldAt(pixelDataFieldIndex);
        this._bandLineDecoder = null;
        this._maxRecordIndex = pixelDataReader.getDSD().getNumRecords() - 1;
        this.dataFieldSampleSize = this.getDataFieldSampleSize(this.getBandInfo());
        this.fieldOffset = this.getDataFieldOffset();
    }

    public String getBandName() {
        return this.getBandInfo().getName();
    }

    public BandInfo getBandInfo() {
        return this._bandInfo;
    }

    public RecordReader getPixelDataReader() {
        return this._pixelDataReader;
    }

    public Record getPixelDataRecord() {
        return this._pixelDataRecord;
    }

    public Field getPixelDataField() {
        return this._pixelDataField;
    }

    public synchronized BandLineDecoder ensureBandLineDecoder() {
        if (this._bandLineDecoder == null) {
            this._bandLineDecoder = BandLineReader.createBandLineDecoder(this.getPixelDataField(), this.getBandInfo());
            if (this._bandLineDecoder == null) {
                StringBuffer sb = new StringBuffer();
                sb.append("createBandLineDecoder(sourceField=");
                sb.append(this.getPixelDataField());
                sb.append(", bandInfo=");
                sb.append(this.getBandInfo());
                sb.append(")");
                Debug.trace((String)"WARNING: no appropriate band line decoder implemented: ");
                Debug.trace((String)sb.toString());
                throw new IllegalStateException("no appropriate band line decoder implemented");
            }
        }
        return this._bandLineDecoder;
    }

    public ProductFile getProductFile() {
        return this.getPixelDataReader().getProductFile();
    }

    public int getRasterWidth() {
        return this.getPixelDataField().getNumElems();
    }

    public int getRasterHeight() {
        return this.getPixelDataReader().getNumRecords();
    }

    public boolean isTiePointBased() {
        return this.getPixelDataReader().getDSD().getDatasetType() != 'M';
    }

    public synchronized void readRasterLine(int sourceMinX, int sourceMaxX, int sourceStepX, int sourceY, ProductData destRaster, int destRasterPos) throws IOException {
        ProductFile productFile = this.getProductFile();
        int mappedMdsrIndex = productFile.getMappedMDSRIndex(sourceY);
        if (mappedMdsrIndex >= 0 && mappedMdsrIndex <= this._maxRecordIndex) {
            int sMaxX;
            int sMinX;
            int destPos;
            int destRasterIncr;
            if (!productFile.storesPixelsInChronologicalOrder()) {
                destRasterIncr = 1;
                destPos = destRasterPos;
                sMinX = sourceMinX;
                sMaxX = sourceMaxX;
            } else {
                destRasterIncr = -1;
                destPos = destRasterPos + (sourceMaxX - sourceMinX) / sourceStepX;
                sMinX = this._bandInfo.getWidth() - 1 - sourceMaxX;
                sMaxX = this._bandInfo.getWidth() - 1 - sourceMinX;
            }
            this.readDataFieldSegment(sourceY, sMinX, sMaxX);
            this.ensureBandLineDecoder().computeLine(this.getPixelDataField().getElems(), sMinX, sMaxX, sourceStepX, destRaster.getElems(), destPos, destRasterIncr);
        } else {
            int inkrement = destRasterPos;
            double missingValue = productFile.getMissingMDSRPixelValue();
            for (int index = sourceMinX; index <= sourceMaxX; index += sourceStepX) {
                destRaster.setElemDoubleAt(inkrement, missingValue);
                ++inkrement;
            }
        }
    }

    public synchronized void readLineRecord(int sourceY) throws IOException {
        this.getPixelDataReader().readRecord(sourceY, this.getPixelDataRecord());
    }

    private void readDataFieldSegment(int sourceY, int minX, int maxX) throws IOException {
        this.getPixelDataReader().readFieldSegment(sourceY, this.fieldOffset, this.dataFieldSampleSize, minX, maxX, this.getPixelDataField());
    }

    private long getDataFieldOffset() {
        Field field;
        long offset = 0L;
        Record pixelDataRecord = this.getPixelDataRecord();
        for (int i = 0; i < pixelDataRecord.getNumFields() && (field = pixelDataRecord.getFieldAt(i)) != this.getPixelDataField(); ++i) {
            ProductData data = field.getData();
            offset += (long)(data.getElemSize() * data.getNumElems());
        }
        return offset;
    }

    private int getDataFieldSampleSize(BandInfo bandInfo) {
        int sampleModel = bandInfo.getSampleModel();
        if (sampleModel == 20) {
            return 1;
        }
        if (sampleModel == 21 || sampleModel == 22 || sampleModel == 23) {
            return 2;
        }
        if (sampleModel == 24) {
            return 3;
        }
        throw new IllegalStateException("unknown sample model ID: " + sampleModel);
    }

    private static BandLineDecoder createBandLineDecoder(Field sourceField, BandInfo bandInfo) {
        BandLineDecoder lineDecoder = null;
        int sampleModel = bandInfo.getSampleModel();
        int srcDataType = sourceField.getDataType();
        if (sampleModel == 20) {
            if (srcDataType == 10 || srcDataType == 20) {
                lineDecoder = new ByteToByteBandDecoder();
            } else if (srcDataType == 11 || srcDataType == 21) {
                lineDecoder = new ShortToShortBandDecoder();
            } else if (srcDataType == 12 || srcDataType == 22) {
                lineDecoder = new IntToIntBandDecoder();
            } else assert (false);
        } else if (sampleModel == 21) {
            if (srcDataType == 10 || srcDataType == 20) {
                lineDecoder = new Byte1Of2ToByteBandDecoder();
            } else if (srcDataType == 11 || srcDataType == 21) {
                lineDecoder = new Short1Of2ToShortBandDecoder();
            } else assert (false);
        } else if (sampleModel == 22) {
            if (srcDataType == 10 || srcDataType == 20) {
                lineDecoder = new Byte2Of2ToByteBandDecoder();
            } else if (srcDataType == 11 || srcDataType == 21) {
                lineDecoder = new Short2Of2ToShortBandDecoder();
            } else assert (false);
        } else if (sampleModel == 23) {
            assert (srcDataType == 10 || srcDataType == 20);
            lineDecoder = new UByte12ToShortBandDecoder();
        } else if (sampleModel == 24) {
            assert (srcDataType == 10 || srcDataType == 20);
            lineDecoder = new UByte123ToIntBandDecoder();
        } else {
            throw new IllegalStateException("unknown sample model ID: " + sampleModel);
        }
        return lineDecoder;
    }

    static class UByte123ToIntBandDecoder
    implements BandLineDecoder {
        UByte123ToIntBandDecoder() {
        }

        @Override
        public void computeLine(Object sourceArray, int sourceMinX, int sourceMaxX, int sourceStepX, Object rasterArray, int rasterPos, int rasterIncr) {
            byte[] bytes = (byte[])sourceArray;
            int[] ints = (int[])rasterArray;
            for (int sourceX = sourceMinX; sourceX <= sourceMaxX; sourceX += sourceStepX) {
                int i = 3 * sourceX;
                ints[rasterPos] = (bytes[i + 0] & 0xFF) << 16 | (bytes[i + 1] & 0xFF) << 8 | bytes[i + 2] & 0xFF;
                rasterPos += rasterIncr;
            }
        }
    }

    static class UByte12ToShortBandDecoder
    implements BandLineDecoder {
        UByte12ToShortBandDecoder() {
        }

        @Override
        public void computeLine(Object sourceArray, int sourceMinX, int sourceMaxX, int sourceStepX, Object rasterArray, int rasterPos, int rasterIncr) {
            byte[] bytes = (byte[])sourceArray;
            short[] shorts = (short[])rasterArray;
            for (int sourceX = sourceMinX; sourceX <= sourceMaxX; sourceX += sourceStepX) {
                int i = 2 * sourceX;
                shorts[rasterPos] = (short)(bytes[i + 0] & 0xFF | (bytes[i + 1] & 0xFF) << 8);
                rasterPos += rasterIncr;
            }
        }
    }

    static class Short2Of2ToShortBandDecoder
    implements BandLineDecoder {
        Short2Of2ToShortBandDecoder() {
        }

        @Override
        public void computeLine(Object sourceArray, int sourceMinX, int sourceMaxX, int sourceStepX, Object rasterArray, int rasterPos, int rasterIncr) {
            short[] shorts1 = (short[])sourceArray;
            short[] shorts2 = (short[])rasterArray;
            for (int sourceX = sourceMinX; sourceX <= sourceMaxX; sourceX += sourceStepX) {
                shorts2[rasterPos] = shorts1[2 * sourceX + 1];
                rasterPos += rasterIncr;
            }
        }
    }

    static class Short1Of2ToShortBandDecoder
    implements BandLineDecoder {
        Short1Of2ToShortBandDecoder() {
        }

        @Override
        public void computeLine(Object sourceArray, int sourceMinX, int sourceMaxX, int sourceStepX, Object rasterArray, int rasterPos, int rasterIncr) {
            short[] shorts1 = (short[])sourceArray;
            short[] shorts2 = (short[])rasterArray;
            for (int sourceX = sourceMinX; sourceX <= sourceMaxX; sourceX += sourceStepX) {
                shorts2[rasterPos] = shorts1[2 * sourceX];
                rasterPos += rasterIncr;
            }
        }
    }

    static class Byte2Of2ToByteBandDecoder
    implements BandLineDecoder {
        Byte2Of2ToByteBandDecoder() {
        }

        @Override
        public void computeLine(Object sourceArray, int sourceMinX, int sourceMaxX, int sourceStepX, Object rasterArray, int rasterPos, int rasterIncr) {
            byte[] bytes1 = (byte[])sourceArray;
            byte[] bytes2 = (byte[])rasterArray;
            for (int sourceX = sourceMinX; sourceX <= sourceMaxX; sourceX += sourceStepX) {
                bytes2[rasterPos] = bytes1[2 * sourceX + 1];
                rasterPos += rasterIncr;
            }
        }
    }

    static class Byte1Of2ToByteBandDecoder
    implements BandLineDecoder {
        Byte1Of2ToByteBandDecoder() {
        }

        @Override
        public void computeLine(Object sourceArray, int sourceMinX, int sourceMaxX, int sourceStepX, Object rasterArray, int rasterPos, int rasterIncr) {
            byte[] bytes1 = (byte[])sourceArray;
            byte[] bytes2 = (byte[])rasterArray;
            for (int sourceX = sourceMinX; sourceX <= sourceMaxX; sourceX += sourceStepX) {
                bytes2[rasterPos] = bytes1[2 * sourceX];
                rasterPos += rasterIncr;
            }
        }
    }

    static class IntToIntBandDecoder
    implements BandLineDecoder {
        IntToIntBandDecoder() {
        }

        @Override
        public void computeLine(Object sourceArray, int sourceMinX, int sourceMaxX, int sourceStepX, Object rasterArray, int rasterPos, int rasterIncr) {
            int[] ints1 = (int[])sourceArray;
            int[] ints2 = (int[])rasterArray;
            for (int sourceX = sourceMinX; sourceX <= sourceMaxX; sourceX += sourceStepX) {
                ints2[rasterPos] = ints1[sourceX];
                rasterPos += rasterIncr;
            }
        }
    }

    static class ShortToShortBandDecoder
    implements BandLineDecoder {
        ShortToShortBandDecoder() {
        }

        @Override
        public void computeLine(Object sourceArray, int sourceMinX, int sourceMaxX, int sourceStepX, Object rasterArray, int rasterPos, int rasterIncr) {
            short[] shorts1 = (short[])sourceArray;
            short[] shorts2 = (short[])rasterArray;
            for (int sourceX = sourceMinX; sourceX <= sourceMaxX; sourceX += sourceStepX) {
                shorts2[rasterPos] = shorts1[sourceX];
                rasterPos += rasterIncr;
            }
        }
    }

    static class ByteToByteBandDecoder
    implements BandLineDecoder {
        ByteToByteBandDecoder() {
        }

        @Override
        public void computeLine(Object sourceArray, int sourceMinX, int sourceMaxX, int sourceStepX, Object rasterArray, int rasterPos, int rasterIncr) {
            byte[] bytes1 = (byte[])sourceArray;
            byte[] bytes2 = (byte[])rasterArray;
            for (int sourceX = sourceMinX; sourceX <= sourceMaxX; sourceX += sourceStepX) {
                bytes2[rasterPos] = bytes1[sourceX];
                rasterPos += rasterIncr;
            }
        }
    }

    public static class Virtual
    extends BandLineReader {
        private String _expression;

        public Virtual(BandInfo bandInfo, String expression) {
            super(bandInfo);
            this._expression = expression;
        }

        public String getExpression() {
            return this._expression;
        }

        @Override
        public boolean isTiePointBased() {
            return false;
        }

        @Override
        public BandLineDecoder ensureBandLineDecoder() {
            throw new IllegalStateException();
        }

        @Override
        public void readLineRecord(int sourceY) throws IOException {
            throw new IllegalStateException();
        }

        @Override
        public ProductFile getProductFile() {
            throw new IllegalStateException();
        }

        @Override
        public void readRasterLine(int sourceMinX, int sourceMaxX, int sourceStepX, int sourceY, ProductData destRaster, int destRasterPos) throws IOException {
            throw new IllegalStateException();
        }

        @Override
        public int getRasterWidth() {
            throw new IllegalStateException();
        }

        @Override
        public int getRasterHeight() {
            throw new IllegalStateException();
        }

        @Override
        public Record getPixelDataRecord() {
            throw new IllegalStateException();
        }

        @Override
        public RecordReader getPixelDataReader() {
            throw new IllegalStateException();
        }

        @Override
        public Field getPixelDataField() {
            throw new IllegalStateException();
        }
    }
}

