/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.envisat;

import com.bc.ceres.core.runtime.RuntimeContext;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.imageio.stream.ImageInputStream;
import org.esa.snap.core.dataio.IllegalFileFormatException;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.dataio.envisat.AsarAbstractMetadata;
import org.esa.snap.dataio.envisat.BandInfo;
import org.esa.snap.dataio.envisat.BandLineReader;
import org.esa.snap.dataio.envisat.DDDB;
import org.esa.snap.dataio.envisat.DSD;
import org.esa.snap.dataio.envisat.Field;
import org.esa.snap.dataio.envisat.FieldInfo;
import org.esa.snap.dataio.envisat.FieldRef;
import org.esa.snap.dataio.envisat.Header;
import org.esa.snap.dataio.envisat.HeaderEntryNotFoundException;
import org.esa.snap.dataio.envisat.HeaderParseException;
import org.esa.snap.dataio.envisat.ProductFile;
import org.esa.snap.dataio.envisat.Record;
import org.esa.snap.dataio.envisat.RecordReader;

public final class AsarProductFile
extends ProductFile {
    private int sceneRasterWidth;
    private int sceneRasterHeight;
    private ProductData.UTC sceneRasterStartTime;
    private ProductData.UTC sceneRasterStopTime;
    private float locTiePointGridOffsetX;
    private float locTiePointGridOffsetY;
    private float locTiePointSubSamplingX;
    private float locTiePointSubSamplingY;
    private boolean chronologicalOrder;
    private IODD _ioddVersion = IODD.VERSION_UNKNOWN;
    private static final String IODD3K_SUFFIX = "_IODD_3K";
    private static final String IODD4A_SUFFIX = "_IODD_4A";
    private static final String IODD4B_SUFFIX = "_IODD_4B";
    private static final String IODD4C_SUFFIX = "_IODD_4C";
    private String fullProductType = null;
    private String versionSuffix = null;
    private static String[] elemsToKeep = new String[]{"Abstracted_Metadata", "MAIN_PROCESSING_PARAMS_ADS", "DSD", "SPH"};

    protected AsarProductFile(File file, ImageInputStream dataInputStream) throws IOException {
        super(file, dataInputStream);
    }

    @Override
    public ProductData.UTC getSceneRasterStartTime() {
        return this.sceneRasterStartTime;
    }

    @Override
    public ProductData.UTC getSceneRasterStopTime() {
        return this.sceneRasterStopTime;
    }

    @Override
    public int getSceneRasterWidth() {
        return this.sceneRasterWidth;
    }

    @Override
    public int getSceneRasterHeight() {
        return this.sceneRasterHeight;
    }

    @Override
    public float getTiePointGridOffsetX(int gridWidth) {
        return this.locTiePointGridOffsetX;
    }

    @Override
    public float getTiePointGridOffsetY(int gridWidth) {
        return this.locTiePointGridOffsetY;
    }

    @Override
    public float getTiePointSubSamplingX(int gridWidth) {
        return this.locTiePointSubSamplingX;
    }

    @Override
    public float getTiePointSubSamplingY(int gridWidth) {
        return this.locTiePointSubSamplingY;
    }

    @Override
    public boolean storesPixelsInChronologicalOrder() {
        return this.chronologicalOrder;
    }

    @Override
    public String getGADSName() {
        return null;
    }

    @Override
    protected void postProcessMPH(Map parameters) throws IOException {
        this._ioddVersion = IODD.VERSION_UNKNOWN;
    }

    @Override
    protected void postProcessSPH(Map parameters) throws IOException {
        String firstMDSName;
        DSD[] mdsDsds = this.getValidDSDs('M');
        if (mdsDsds.length == 0) {
            throw new IllegalFileFormatException("no valid measurements datasets found in this ASAR product");
        }
        this.setIODDVersion();
        DSD dsdGeoLocationAds = this.getDSD("GEOLOCATION_GRID_ADS");
        if (dsdGeoLocationAds == null) {
            throw new IllegalFileFormatException("invalid product: missing DSD for dataset 'GEOLOCATION_GRID_ADS'");
        }
        this.sceneRasterHeight = mdsDsds[0].getNumRecords();
        String productType = this.getProductType();
        boolean waveProduct = false;
        if (productType.equals("ASA_WVS_1P") || productType.equals("ASA_WVW_2P") || productType.equals("ASA_WVI_1P")) {
            waveProduct = true;
            int numDirBins = this.getSPH().getParamInt("NUM_DIR_BINS");
            int numWlBins = this.getSPH().getParamInt("NUM_WL_BINS");
            if (productType.equals("ASA_WVS_1P") || productType.equals("ASA_WVI_1P")) {
                numWlBins /= 2;
            }
            this.sceneRasterWidth = numDirBins * numWlBins;
            parameters.put("spectraWidth", this.sceneRasterWidth);
            if (productType.equals("ASA_WVI_1P")) {
                for (DSD dsd : mdsDsds) {
                    if (dsd.getNumRecords() > this.sceneRasterHeight) {
                        this.sceneRasterHeight = dsd.getNumRecords();
                    }
                    if (dsd.getRecordSize() <= this.sceneRasterWidth) continue;
                    this.sceneRasterWidth = dsd.getRecordSize();
                }
            }
        } else {
            this.sceneRasterWidth = this.getSPH().getParamInt("LINE_LENGTH");
        }
        if (this.sceneRasterWidth < 0 && !waveProduct) {
            int maxWidth = 0;
            RecordReader recordReader = this.getRecordReader("MAIN_PROCESSING_PARAMS_ADS");
            for (int i = 0; i < mdsDsds.length; ++i) {
                Record rec = recordReader.readRecord(i);
                Field numSamplesPerLineField = rec.getField("num_samples_per_line");
                if (numSamplesPerLineField == null) continue;
                int rasterWidth = numSamplesPerLineField.getData().getElemInt();
                parameters.put("mdsWidth" + (i + 1), rasterWidth);
                if (rasterWidth <= maxWidth) continue;
                maxWidth = rasterWidth;
            }
            this.sceneRasterWidth = maxWidth;
        }
        int locTiePointGridWidth = 11;
        int locTiePointGridHeight = dsdGeoLocationAds.getNumRecords();
        this.locTiePointGridOffsetX = 0.5f;
        this.locTiePointGridOffsetY = 0.5f;
        if (!waveProduct) {
            this.locTiePointSubSamplingX = this.getPixelsPerTiePoint();
            this.locTiePointSubSamplingY = this.getLinesPerTiePoint();
        } else {
            this.locTiePointSubSamplingX = (float)this.sceneRasterWidth / 10.0f;
            this.locTiePointSubSamplingY = (float)this.sceneRasterHeight / ((float)dsdGeoLocationAds.getNumRecords() - 1.0f);
        }
        parameters.put("sceneRasterWidth", this.sceneRasterWidth);
        parameters.put("sceneRasterHeight", this.sceneRasterHeight);
        parameters.put("locTiePointGridWidth", 11);
        parameters.put("locTiePointGridHeight", locTiePointGridHeight);
        parameters.put("locTiePointGridOffsetX", Float.valueOf(this.locTiePointGridOffsetX));
        parameters.put("locTiePointGridOffsetY", Float.valueOf(this.locTiePointGridOffsetY));
        parameters.put("locTiePointSubSamplingX", Float.valueOf(this.locTiePointSubSamplingX));
        parameters.put("locTiePointSubSamplingY", Float.valueOf(this.locTiePointSubSamplingY));
        String prod_descriptor = this.getSPH().getParamString("SPH_DESCRIPTOR");
        if (prod_descriptor != null) {
            this.chronologicalOrder = false;
            if (productType.startsWith("SAR")) {
                this.chronologicalOrder = false;
            }
        }
        if (!this.isValidDatasetName(firstMDSName = mdsDsds[0].getDatasetName())) {
            firstMDSName = firstMDSName.replace(' ', '_');
        }
        if (!waveProduct) {
            try {
                this.sceneRasterStartTime = this.getSPH().getParamUTC("FIRST_LINE_TIME");
                this.sceneRasterStopTime = this.getSPH().getParamUTC("LAST_LINE_TIME");
            }
            catch (HeaderParseException e) {
                this.sceneRasterStartTime = this.getRecordTime(firstMDSName, "zero_doppler_time", 0);
                this.sceneRasterStopTime = this.getRecordTime(firstMDSName, "zero_doppler_time", this.sceneRasterHeight - 1);
            }
        }
    }

    private int getPixelsPerTiePoint() throws IOException {
        RecordReader geoRecordReader = this.getRecordReader("GEOLOCATION_GRID_ADS");
        if (geoRecordReader == null) {
            return 0;
        }
        Record rec = geoRecordReader.readRecord(0);
        Field sampNumberField = rec.getField("ASAR_Geo_Grid_ADSR.sd/first_line_tie_points.samp_numbers");
        if (sampNumberField == null) {
            return 0;
        }
        return sampNumberField.getData().getElemIntAt(1) - 1;
    }

    private int getLinesPerTiePoint() throws IOException {
        RecordReader geoRecordReader = this.getRecordReader("GEOLOCATION_GRID_ADS");
        if (geoRecordReader == null) {
            return 0;
        }
        Record rec = geoRecordReader.readRecord(0);
        Field numLinesField = rec.getField("num_lines");
        if (numLinesField == null) {
            return 0;
        }
        return numLinesField.getData().getElemInt();
    }

    @Override
    void setInvalidPixelExpression(Band band) {
        band.setNoDataValueUsed(true);
        band.setNoDataValue(0.0);
    }

    IODD getIODDVersion() {
        if (this._ioddVersion == IODD.VERSION_UNKNOWN) {
            this.setIODDVersion();
        }
        return this._ioddVersion;
    }

    private void setIODDVersion() {
        Header mph = this.getMPH();
        try {
            String refDoc = mph.getParamString("REF_DOC").toUpperCase().trim();
            if (refDoc.endsWith("4C") || refDoc.endsWith("4/C")) {
                this._ioddVersion = IODD.ASAR_4C;
            } else if (refDoc.endsWith("4B") || refDoc.endsWith("4/B")) {
                this._ioddVersion = IODD.ASAR_4B;
            } else if (refDoc.endsWith("4A") || refDoc.endsWith("4/A")) {
                this._ioddVersion = IODD.ASAR_4A;
            } else if (refDoc.endsWith("3K") || refDoc.endsWith("3/K")) {
                this._ioddVersion = IODD.ASAR_3K;
            } else {
                int issue;
                char issueCh = refDoc.charAt(refDoc.length() - 2);
                if (Character.isDigit(issueCh) && (issue = Character.getNumericValue(issueCh)) >= 4) {
                    this._ioddVersion = IODD.ASAR_4B;
                }
            }
            if (this._ioddVersion == IODD.VERSION_UNKNOWN) {
                String softwareVersion = mph.getParamString("SOFTWARE_VER").toUpperCase().trim();
                if (softwareVersion.startsWith("ASAR/3.")) {
                    float versionNum;
                    String versionStr = softwareVersion.substring(5);
                    if (StringUtils.isNumeric((String)versionStr, Float.class) && (double)(versionNum = Float.parseFloat(versionStr)) > 3.08) {
                        this._ioddVersion = IODD.ASAR_3K;
                    }
                } else {
                    int versionNum;
                    char versionCh;
                    this._ioddVersion = softwareVersion.startsWith("ASAR/4.05") || softwareVersion.contains("4.05") ? IODD.ASAR_4B : (softwareVersion.startsWith("ASAR/4.00") || softwareVersion.startsWith("ASAR/4.01") || softwareVersion.startsWith("ASAR/4.02") || softwareVersion.startsWith("ASAR/4.03") || softwareVersion.startsWith("ASAR/4.04") || softwareVersion.contains("4.00") || softwareVersion.contains("4.01") || softwareVersion.contains("4.02") || softwareVersion.contains("4.03") || softwareVersion.contains("4.04") ? IODD.ASAR_4A : (softwareVersion.startsWith("ASAR/4.05") || softwareVersion.startsWith("ASAR/4.06") || softwareVersion.startsWith("ASAR/4.07") || softwareVersion.contains("4.05") || softwareVersion.contains("4.06") || softwareVersion.contains("4.07") ? IODD.ASAR_4B : (softwareVersion.length() > 6 ? (Character.isDigit(versionCh = softwareVersion.charAt(6)) ? ((versionNum = Character.getNumericValue(versionCh)) >= 4 ? IODD.ASAR_4B : IODD.VERSION_UNKNOWN) : IODD.VERSION_UNKNOWN) : IODD.VERSION_UNKNOWN)));
                }
            }
        }
        catch (Exception e) {
            this._ioddVersion = IODD.VERSION_UNKNOWN;
        }
    }

    @Override
    protected String getDddbProductType() {
        if (this.fullProductType == null) {
            this.fullProductType = AsarProductFile.getDddbProductTypeReplacement(this.getProductType(), this.getIODDVersion());
        }
        return this.fullProductType != null ? this.fullProductType : super.getDddbProductType();
    }

    static String getDddbProductTypeReplacement(String productType, IODD ioddVersion) {
        return productType + AsarProductFile.createVersionSuffix(productType, ioddVersion);
    }

    static String createVersionSuffix(String productType, IODD ioddVersion) {
        String suffix = "";
        if (ioddVersion == IODD.ASAR_3K) {
            if (AsarProductFile.productDDExists(productType + IODD3K_SUFFIX)) {
                suffix = IODD3K_SUFFIX;
            }
        } else if (ioddVersion == IODD.ASAR_4A) {
            if (AsarProductFile.productDDExists(productType + IODD4A_SUFFIX)) {
                suffix = IODD4A_SUFFIX;
            } else if (AsarProductFile.productDDExists(productType + IODD3K_SUFFIX)) {
                suffix = IODD3K_SUFFIX;
            }
        } else if (ioddVersion == IODD.ASAR_4B) {
            if (AsarProductFile.productDDExists(productType + IODD4B_SUFFIX)) {
                suffix = IODD4B_SUFFIX;
            } else if (AsarProductFile.productDDExists(productType + IODD4A_SUFFIX)) {
                suffix = IODD4A_SUFFIX;
            } else if (AsarProductFile.productDDExists(productType + IODD3K_SUFFIX)) {
                suffix = IODD3K_SUFFIX;
            }
        } else if (ioddVersion == IODD.ASAR_4C) {
            if (AsarProductFile.productDDExists(productType + IODD4C_SUFFIX)) {
                suffix = IODD4C_SUFFIX;
            } else if (AsarProductFile.productDDExists(productType + IODD4B_SUFFIX)) {
                suffix = IODD4B_SUFFIX;
            } else if (AsarProductFile.productDDExists(productType + IODD4A_SUFFIX)) {
                suffix = IODD4A_SUFFIX;
            } else if (AsarProductFile.productDDExists(productType + IODD3K_SUFFIX)) {
                suffix = IODD3K_SUFFIX;
            }
        } else if (ioddVersion == IODD.VERSION_UNKNOWN) {
            suffix = "";
        }
        return suffix;
    }

    String getVersionSuffix(String productType, IODD ioddVersion) {
        if (this.versionSuffix == null) {
            this.versionSuffix = AsarProductFile.createVersionSuffix(productType, ioddVersion);
        }
        return this.versionSuffix;
    }

    private static boolean productDDExists(String productType) {
        return DDDB.databaseResourceExists("products/" + productType + ".dd");
    }

    @Override
    public float[] getSpectralBandWavelengths() {
        return null;
    }

    @Override
    public float[] getSpectralBandBandwidths() {
        return null;
    }

    @Override
    public float[] getSpectralBandSolarFluxes() {
        return null;
    }

    @Override
    public Mask[] createDefaultMasks(String dsName) {
        return new Mask[0];
    }

    @Override
    protected int getDSRTimeInfoFieldIndex(RecordReader recordReader) {
        return recordReader.getRecordInfo().getFieldInfoIndex("zero_doppler_time");
    }

    @Override
    protected BandLineReader[] createBandLineReaders() {
        if (this.getProductType().equals("ASA_WVI_1P")) {
            return this.createWVIImagettes();
        }
        return DDDB.getInstance().getBandLineReaders(this);
    }

    private BandLineReader[] createWVIImagettes() {
        BandLineReader[] dddbReaderList = DDDB.getInstance().getBandLineReaders(this);
        ArrayList<BandLineReader> readerList = new ArrayList<BandLineReader>();
        readerList.addAll(Arrays.asList(dddbReaderList));
        try {
            int numImagettes = this.getSPH().getParamInt("IMAGETTES_MADE");
            int bandDataType = DDDB.getFieldType("Float");
            for (int i = 0; i < numImagettes; ++i) {
                String numStr = i < 10 ? "00" + i : (i < 100 ? "0" + i : "" + i);
                String pixelDataRefStr = "SLC_IMAGETTE_MDS_" + numStr + ".4";
                FieldRef fieldRef = FieldRef.parse(pixelDataRefStr);
                String dataSetName = fieldRef.getDatasetName();
                int pixelDataFieldIndex = fieldRef.getFieldIndex();
                String iBandName = "i_" + (i + 1);
                BandInfo bandInfoI = this.createBandInfo(iBandName, bandDataType, -1, 21, 11, 0.0, 1.0, null, null, "real", "", dataSetName);
                RecordReader pixelDataReaderI = this.getRecordReader(dataSetName);
                BandLineReader bandLineReaderI = new BandLineReader(bandInfoI, pixelDataReaderI, pixelDataFieldIndex);
                readerList.add(bandLineReaderI);
                String qBandName = "q_" + (i + 1);
                BandInfo bandInfoQ = this.createBandInfo(qBandName, bandDataType, -1, 22, 11, 0.0, 1.0, null, null, "imaginary", "", dataSetName);
                RecordReader pixelDataReaderQ = this.getRecordReader(dataSetName);
                BandLineReader bandLineReaderQ = new BandLineReader(bandInfoQ, pixelDataReaderQ, pixelDataFieldIndex);
                readerList.add(bandLineReaderQ);
                BandInfo bandInfoIntensity = this.createBandInfo("Intensity_" + (i + 1), bandDataType, -1, 20, 11, 0.0, 1.0, null, null, "intensity", "", dataSetName);
                String expression = iBandName + '*' + iBandName + '+' + qBandName + '*' + qBandName;
                BandLineReader.Virtual bandLineReaderIntensity = new BandLineReader.Virtual(bandInfoIntensity, this.updateExpression(expression));
                readerList.add(bandLineReaderIntensity);
                BandInfo bandInfoPhase = this.createBandInfo("Phase_" + (i + 1), bandDataType, -1, 20, 11, 0.0, 1.0, null, null, "phase", "", dataSetName);
                String expressionPhase = "atan2(" + qBandName + "," + iBandName + ")";
                BandLineReader.Virtual bandLineReaderPhase = new BandLineReader.Virtual(bandInfoPhase, this.updateExpression(expressionPhase));
                readerList.add(bandLineReaderPhase);
            }
        }
        catch (Exception e) {
            Debug.trace((String)e.getMessage());
        }
        return readerList.toArray(new BandLineReader[readerList.size()]);
    }

    @Override
    public BandInfo createBandInfo(String bandName, int dataType, int spectralBandIndex, int sampleModel, int scalingMethod, double scalingOffset, double scalingFactor, String validExpression, FlagCoding flagCoding, String physicalUnit, String description, String dataSetName) {
        int rasterHeight = this.sceneRasterHeight;
        int rasterWidth = this.sceneRasterWidth;
        String productType = this.getProductType();
        if (productType.equals("ASA_WSS_1P")) {
            try {
                DSD[] mdsDsds = this.getValidDSDs('M');
                for (int i = 0; i < mdsDsds.length; ++i) {
                    Field numSamplesPerLineField;
                    if (!mdsDsds[i].getDatasetName().equals(dataSetName)) continue;
                    RecordReader recordReader = this.getRecordReader("MAIN_PROCESSING_PARAMS_ADS");
                    Record rec = recordReader.readRecord(i);
                    Field numOutputLinesField = rec.getField("num_output_lines");
                    if (numOutputLinesField != null) {
                        rasterHeight = numOutputLinesField.getData().getElemInt();
                    }
                    if ((numSamplesPerLineField = rec.getField("num_samples_per_line")) == null) break;
                    rasterWidth = numSamplesPerLineField.getData().getElemInt();
                }
            }
            catch (IOException mdsDsds) {}
        } else if (productType.equals("ASA_WVI_1P") || productType.equals("ASA_WVS_1P") || productType.equals("ASA_WVW_2P")) {
            DSD dsd = this.getDSD(dataSetName);
            rasterHeight = dsd.getNumRecords();
            boolean error = false;
            try {
                int numDirBins = this.getSPH().getParamInt("NUM_DIR_BINS");
                int numWlBins = this.getSPH().getParamInt("NUM_WL_BINS");
                if (productType.equals("ASA_WVS_1P") || productType.equals("ASA_WVI_1P")) {
                    numWlBins /= 2;
                }
                rasterWidth = numDirBins * numWlBins;
            }
            catch (Exception e) {
                Debug.trace((Throwable)e);
                error = true;
            }
            if (error || productType.equals("ASA_WVI_1P") && dataSetName.contains("IMAGE")) {
                int headerSize = 17;
                rasterWidth = (dsd.getRecordSize() - 17) / 4;
            }
        } else if (bandName.endsWith("_1")) {
            bandName = this.renameWithPolarization(bandName, "_1", "MDS1_TX_RX_POLAR");
        } else if (bandName.endsWith("_2")) {
            bandName = this.renameWithPolarization(bandName, "_2", "MDS2_TX_RX_POLAR");
        }
        return new BandInfo(bandName, dataType, spectralBandIndex, sampleModel, scalingMethod, scalingOffset, scalingFactor, validExpression, flagCoding, physicalUnit, description, rasterWidth, rasterHeight);
    }

    @Override
    public String updateExpression(String expression) {
        try {
            if (expression != null && !this.getProductType().equals("ASA_WSS_1P")) {
                String polarization2;
                String polarization1 = this.getSPH().getParamString("MDS1_TX_RX_POLAR");
                if (polarization1 != null && !polarization1.isEmpty()) {
                    polarization1 = polarization1.replace("/", "");
                    expression = expression.replaceAll("_1", "_" + polarization1);
                }
                if ((polarization2 = this.getSPH().getParamString("MDS2_TX_RX_POLAR")) != null && !polarization2.isEmpty()) {
                    polarization2 = polarization2.replace("/", "");
                    expression = expression.replaceAll("_2", "_" + polarization2);
                }
            }
        }
        catch (HeaderEntryNotFoundException headerEntryNotFoundException) {
            // empty catch block
        }
        return expression;
    }

    private String renameWithPolarization(String bandName, String ending, String tag) {
        try {
            String polarization = this.getSPH().getParamString(tag);
            if (polarization != null && !polarization.isEmpty()) {
                polarization = polarization.replace("/", "");
                bandName = bandName.substring(0, bandName.length() - ending.length()) + '_' + polarization;
            }
        }
        catch (HeaderEntryNotFoundException headerEntryNotFoundException) {
            // empty catch block
        }
        return bandName;
    }

    private void processWSSImageRecordMetadata(Product product) {
        for (Band band : product.getBands()) {
            MetadataElement bandElem;
            if (band.getUnit().equals("imaginary")) continue;
            MetadataElement imgRecElem = product.getMetadataRoot().getElement("Image Record");
            if (imgRecElem == null) {
                imgRecElem = new MetadataElement("Image Record");
                product.getMetadataRoot().addElement(imgRecElem);
            }
            if ((bandElem = imgRecElem.getElement(band.getName())) == null) {
                bandElem = new MetadataElement(band.getName());
                imgRecElem.addElement(bandElem);
            }
            MetadataElement bandElemement = bandElem;
            FieldInfo fInfo = new FieldInfo("t", 51, 1, "", "");
            Field field = fInfo.createField();
            try {
                BandLineReader bandLineReader = this.getBandLineReader(band);
                RecordReader recReader = bandLineReader.getPixelDataReader();
                ImageInputStream istream = this.getDataInputStream();
                long datasetOffset = recReader.getDSD().getDatasetOffset();
                long recordSize = recReader.getDSD().getRecordSize();
                int height = band.getRasterHeight();
                double[] timeData = new double[height];
                long pos = datasetOffset;
                for (int y = 0; y < height; ++y) {
                    istream.seek(pos);
                    field.readFrom(istream);
                    ProductData data = field.getData();
                    timeData[y] = data.getElemIntAt(0) == 0 ? 0.0 : ((ProductData.UTC)data).getMJD();
                    pos += recordSize;
                }
                MetadataAttribute attribute = new MetadataAttribute("t", 31, height);
                attribute.setDataElems((Object)timeData);
                bandElemement.addAttribute(attribute);
            }
            catch (IOException e) {
                System.out.println("processWSSImageRecordMetadata " + e.toString());
            }
        }
    }

    private void processWaveMetadata(Product product) throws IOException {
        String[] datasetNames;
        MetadataElement origRoot = product.getMetadataRoot();
        for (String datasetName : datasetNames = this.getValidDatasetNames()) {
            if (!datasetName.equalsIgnoreCase("CROSS_SPECTRA_MDS") && !datasetName.equalsIgnoreCase("OCEAN_WAVE_SPECTRA_MDS")) continue;
            RecordReader recordReader = this.getRecordReader(datasetName);
            MetadataElement metadataTableGroup = new MetadataElement(datasetName);
            StringBuilder sb = new StringBuilder(25);
            for (int i = 0; i < recordReader.getNumRecords(); ++i) {
                Field field;
                Record record = recordReader.readRecord(i);
                sb.setLength(0);
                sb.append(datasetName);
                sb.append('.');
                sb.append(i + 1);
                MetadataElement elem = new MetadataElement(sb.toString());
                for (int j = 0; j < record.getNumFields() && !(field = record.getFieldAt(j)).getName().equals("ocean_spectra") && !field.getName().equals("real_spectra"); ++j) {
                    String description = field.getInfo().getDescription();
                    if (description != null && description.equalsIgnoreCase("Spare")) continue;
                    MetadataAttribute attribute = new MetadataAttribute(field.getName(), field.getData(), true);
                    if (field.getInfo().getPhysicalUnit() != null) {
                        attribute.setUnit(field.getInfo().getPhysicalUnit());
                    }
                    if (description != null) {
                        attribute.setDescription(field.getInfo().getDescription());
                    }
                    elem.addAttribute(attribute);
                }
                metadataTableGroup.addElement(elem);
            }
            origRoot.addElement(metadataTableGroup);
        }
    }

    @Override
    protected void addCustomMetadata(Product product) throws IOException {
        String productType = this.getProductType();
        if (productType.equalsIgnoreCase("ASA_WSS_1P")) {
            this.processWSSImageRecordMetadata(product);
        } else if (productType.equals("ASA_WVI_1P") || productType.equals("ASA_WVS_1P") || productType.equals("ASA_WVW_2P")) {
            this.processWaveMetadata(product);
        }
        for (Band b : product.getBands()) {
            if (b.getUnit() == null || !b.getUnit().contains("intensity")) continue;
            product.setQuicklookBandName(b.getName());
            break;
        }
        MetadataElement root = product.getMetadataRoot();
        AsarAbstractMetadata absMetadata = new AsarAbstractMetadata(this.getProductType(), this.getVersionSuffix(this.getProductType(), this.getIODDVersion()), this.getFile());
        absMetadata.addAbstractedMetadataHeader(product, root);
        AsarProductFile.discardUnusedMetadata(product);
    }

    private static void discardUnusedMetadata(Product product) {
        String dicardUnusedMetadata;
        if (RuntimeContext.getModuleContext() != null && "true".equalsIgnoreCase(dicardUnusedMetadata = RuntimeContext.getModuleContext().getRuntimeConfig().getContextProperty("discard.unused.metadata"))) {
            AsarProductFile.removeUnusedMetadata(product.getMetadataRoot());
        }
    }

    private static void removeUnusedMetadata(MetadataElement root) {
        MetadataElement[] elems;
        for (MetadataElement elem : elems = root.getElements()) {
            String name = elem.getName();
            boolean keep = false;
            for (String toKeep : elemsToKeep) {
                if (!name.equals(toKeep)) continue;
                keep = true;
                break;
            }
            if (keep) continue;
            root.removeElement(elem);
            elem.dispose();
        }
    }

    static enum IODD {
        VERSION_UNKNOWN,
        ASAR_3K,
        ASAR_4A,
        ASAR_4B,
        ASAR_4C;

    }
}

