/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.product;

import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.core.Assert;
import com.bc.ceres.glayer.CollectionLayer;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerContext;
import com.bc.ceres.glayer.LayerFilter;
import com.bc.ceres.glayer.support.LayerUtils;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.ProductNodeListener;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.core.layer.ProductLayerContext;
import org.esa.snap.ui.product.VectorDataCollectionLayerType;
import org.esa.snap.ui.product.VectorDataLayer;
import org.esa.snap.ui.product.VectorDataLayerFilterFactory;
import org.esa.snap.ui.product.VectorDataLayerType;

public class VectorDataCollectionLayer
extends CollectionLayer {
    public static final String ID = VectorDataCollectionLayer.class.getName();
    private final ProductNodeListener pnl;
    private final transient WeakReference<ProductNodeGroup<VectorDataNode>> reference;
    private final ProductLayerContext plc;

    public VectorDataCollectionLayer(VectorDataCollectionLayerType layerType, ProductNodeGroup<VectorDataNode> vectorDataGroup, PropertySet configuration, ProductLayerContext plc) {
        super((CollectionLayer.Type)layerType, configuration, "Vector data");
        Assert.notNull(vectorDataGroup, (String)"vectorDataGroup");
        this.reference = new WeakReference<ProductNodeGroup<VectorDataNode>>(vectorDataGroup);
        this.pnl = new PNL();
        this.plc = plc;
        this.setId(ID);
        vectorDataGroup.getProduct().addProductNodeListener(this.pnl);
    }

    public void disposeLayer() {
        Product product;
        ProductNodeGroup productNodeGroup = (ProductNodeGroup)this.reference.get();
        if (productNodeGroup != null && (product = productNodeGroup.getProduct()) != null) {
            product.removeProductNodeListener(this.pnl);
        }
        this.reference.clear();
    }

    private Layer createLayer(VectorDataNode vectorDataNode) {
        VectorDataLayer layer = VectorDataLayerType.createLayer((LayerContext)this.plc, vectorDataNode);
        layer.setVisible(false);
        return layer;
    }

    private Layer getLayer(VectorDataNode vectorDataNode) {
        LayerFilter layerFilter = VectorDataLayerFilterFactory.createNodeFilter(vectorDataNode);
        return LayerUtils.getChildLayer((Layer)LayerUtils.getRootLayer((Layer)this), (LayerUtils.SearchMode)LayerUtils.SEARCH_DEEP, (LayerFilter)layerFilter);
    }

    synchronized void updateChildren() {
        ProductNodeGroup vectorDataGroup = (ProductNodeGroup)this.reference.get();
        if (vectorDataGroup == null) {
            return;
        }
        LayerFilter layerFilter = layer -> {
            PropertySet conf = layer.getConfiguration();
            return conf.isPropertyDefined("vectorData") && conf.getValue("vectorData") != null;
        };
        List vectorLayers = LayerUtils.getChildLayers((Layer)LayerUtils.getRootLayer((Layer)this), (LayerUtils.SearchMode)LayerUtils.SEARCH_DEEP, (LayerFilter)layerFilter);
        HashMap<VectorDataNode, Layer> currentLayers = new HashMap<VectorDataNode, Layer>();
        for (Layer child : vectorLayers) {
            String name = (String)child.getConfiguration().getValue("vectorData");
            VectorDataNode vectorDataNode = (VectorDataNode)vectorDataGroup.get(name);
            currentLayers.put(vectorDataNode, child);
        }
        HashSet unusedLayers = new HashSet(vectorLayers);
        VectorDataNode[] vectorDataNodes = (VectorDataNode[])vectorDataGroup.toArray((ProductNode[])new VectorDataNode[vectorDataGroup.getNodeCount()]);
        for (VectorDataNode vectorDataNode : vectorDataNodes) {
            Layer layer2 = (Layer)currentLayers.get(vectorDataNode);
            if (layer2 != null) {
                unusedLayers.remove(layer2);
                continue;
            }
            layer2 = this.createLayer(vectorDataNode);
            this.getChildren().add(layer2);
        }
        for (Layer layer3 : unusedLayers) {
            layer3.dispose();
            Layer layerParent = layer3.getParent();
            if (layerParent == null) continue;
            layerParent.getChildren().remove(layer3);
        }
    }

    private class PNL
    implements ProductNodeListener {
        private PNL() {
        }

        public synchronized void nodeChanged(ProductNodeEvent event) {
            VectorDataNode vectorDataNode;
            Layer layer;
            ProductNode sourceNode = event.getSourceNode();
            if (sourceNode instanceof VectorDataNode && (layer = VectorDataCollectionLayer.this.getLayer(vectorDataNode = (VectorDataNode)sourceNode)) != null) {
                layer.regenerate();
            }
        }

        public void nodeDataChanged(ProductNodeEvent event) {
            this.nodeChanged(event);
        }

        public void nodeAdded(ProductNodeEvent event) {
            VectorDataCollectionLayer.this.updateChildren();
        }

        public void nodeRemoved(ProductNodeEvent event) {
            VectorDataCollectionLayer.this.updateChildren();
        }
    }
}

