/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.product;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.dataio.ProductSubsetDef;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.ui.GridBagUtils;
import org.esa.snap.ui.SnapFileChooser;
import org.esa.snap.ui.UIUtils;
import org.esa.snap.ui.product.ProductSubsetDialog;

public class ProductFileChooser
extends SnapFileChooser {
    private Product _product;
    private ProductReaderPlugIn _readerPlugIn;
    private ProductSubsetDef _productSubsetDef;
    private JButton _subsetButton;
    private JLabel _sizeLabel;

    public ProductFileChooser(String title, ProductReaderPlugIn readerPlugIn) {
        Guardian.assertNotNullOrEmpty((String)"title", (String)title);
        Guardian.assertNotNull((String)"readerPlugIn", (Object)readerPlugIn);
        this._readerPlugIn = readerPlugIn;
        this.setCurrentFilename("noname");
        this.setDialogTitle(title);
        this.setFileSelectionMode(0);
        this.addChoosableFileFilter((FileFilter)new SnapFileFilter());
        this.createUI();
    }

    public ProductFileChooser(String title, Product product) {
        Guardian.assertNotNullOrEmpty((String)"title", (String)title);
        Guardian.assertNotNull((String)"product", (Object)product);
        this.setProduct(product);
        this.setDialogTitle(title);
        this.setFileSelectionMode(0);
        this.createUI();
    }

    public Product getProduct() {
        return this._product;
    }

    public void setProduct(Product product) {
        if (this._readerPlugIn == null) {
            Guardian.assertNotNull((String)"product", (Object)product);
        }
        this._product = product;
        if (this._product != null) {
            this.setCurrentFilename(this._product.getName());
        }
    }

    public ProductSubsetDef getProductSubsetDef() {
        return this._productSubsetDef;
    }

    public void clearProductSubsetDef() {
        this._productSubsetDef = null;
        this.updateUIState();
    }

    public boolean isImportDialog() {
        return this._readerPlugIn != null;
    }

    public boolean isExportDialog() {
        return !this.isImportDialog();
    }

    protected void openProductSubsetDialog() {
        File file;
        if (this.isImportDialog() && (file = this.getSelectedFile()) != null) {
            this._product = this.readProductNodes(file);
            this._productSubsetDef = null;
        }
        if (this._product == null) {
            return;
        }
        ProductSubsetDialog dialog = new ProductSubsetDialog(this.getWindow(), this._product, this._productSubsetDef);
        if (dialog.show() == 1) {
            this._productSubsetDef = dialog.getProductSubsetDef().isEntireProductSelected() ? null : dialog.getProductSubsetDef();
            if (this.getCurrentFilename() != null && !this.getCurrentFilename().startsWith("subset_")) {
                this.setCurrentFilename("subset_" + this.getCurrentFilename());
            }
        }
        this.updateUIState();
    }

    protected void openHistoryDialog() {
    }

    protected void createUI() {
        this._subsetButton = new JButton("Subset...");
        this._subsetButton.setMnemonic('S');
        this._subsetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductFileChooser.this.openProductSubsetDialog();
            }
        });
        this._subsetButton.setEnabled(this._product != null);
        JButton historyButton = new JButton("History...");
        historyButton.setMnemonic('H');
        historyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductFileChooser.this.openHistoryDialog();
            }
        });
        historyButton.setEnabled(false);
        this._sizeLabel = new JLabel(" ");
        this._sizeLabel.setHorizontalAlignment(4);
        JPanel accessoryPane = GridBagUtils.createPanel();
        GridBagConstraints gbc = GridBagUtils.createConstraints("fill=HORIZONTAL,weightx=1,anchor=NORTHWEST,insets.left=7,insets.right=7,insets.bottom=4");
        GridBagUtils.addToPanel(accessoryPane, this._subsetButton, gbc, "gridy=0");
        GridBagUtils.addToPanel(accessoryPane, this._sizeLabel, gbc, "gridy=1");
        GridBagUtils.addVerticalFiller(accessoryPane, gbc);
        this.setAccessory(accessoryPane);
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (!ProductFileChooser.this.isVisible()) {
                    return;
                }
                Debug.trace((PropertyChangeEvent)event);
            }
        });
        this.setPreferredSize(new Dimension(640, 400));
        this.updateUIState();
    }

    protected void updateUIState() {
        File selectedFile;
        if (this._subsetButton == null) {
            return;
        }
        if (this.isImportDialog()) {
            this._product = null;
            this._productSubsetDef = null;
        }
        if ((selectedFile = this.getSelectedFile()) != null && !selectedFile.isFile()) {
            selectedFile = null;
        }
        long fileSize = 0L;
        if (this.isImportDialog()) {
            this.setDialogType(0);
            this._subsetButton.setEnabled(selectedFile != null);
            if (this._productSubsetDef != null) {
                this.setApproveButtonText("Import Subset");
                this.setApproveButtonMnemonic('I');
                this.setApproveButtonToolTipText("Imports the specified subset of the product.");
            } else {
                this.setApproveButtonText("Import Product");
                this.setApproveButtonMnemonic('I');
                this.setApproveButtonToolTipText("Imports the entire product.");
            }
            if (selectedFile != null) {
                fileSize = selectedFile.length();
            }
        } else {
            this.setDialogType(1);
            this._subsetButton.setEnabled(this._product != null);
            if (this._productSubsetDef != null) {
                this.setApproveButtonText("Export Subset");
                this.setApproveButtonMnemonic('E');
                this.setApproveButtonToolTipText("Exports the specified subset of the product.");
            } else {
                this.setApproveButtonText("Export Product");
                this.setApproveButtonMnemonic('E');
                this.setApproveButtonToolTipText("Exports the entire product.");
            }
            if (this._product != null) {
                fileSize = this._product.getRawStorageSize(this._productSubsetDef);
            }
        }
        if (fileSize > 0L) {
            if ((fileSize = Math.round((double)fileSize / 1048576.0)) >= 1L) {
                this._sizeLabel.setText("File size: ~" + fileSize + " M");
            } else {
                this._sizeLabel.setText("File size: <1 M");
            }
        } else {
            this._sizeLabel.setText("");
        }
    }

    private Product readProductNodes(File file) {
        ProductReader reader = this._readerPlugIn.createReaderInstance();
        Product product = null;
        Cursor cursor = UIUtils.setRootFrameWaitCursor(this);
        try {
            product = reader.readProductNodes((Object)file, null);
            UIUtils.setRootFrameCursor(this, cursor);
        }
        catch (IOException e) {
            UIUtils.setRootFrameCursor(this, cursor);
            JOptionPane.showMessageDialog(this.getWindow(), "Product I/O Error:\n'" + e.getMessage() + "'", "Product I/O Error", 0);
        }
        return product;
    }
}

