/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.color;

import com.jidesoft.popup.JidePopup;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import org.esa.snap.ui.color.ColorChooserPanel;
import org.esa.snap.ui.color.ColorChooserPanelFactory;
import org.esa.snap.ui.color.ColorLabel;

public class ColorComboBox
extends JComponent {
    public static final String SELECTED_COLOR_PROPERTY = "selectedColor";
    public static final Color TRANSPARENCY = new Color(0, 0, 0, 0);
    private JidePopup popupWindow;
    private ColorLabel colorLabel;
    private Color selectedColor;
    private ColorChooserPanelFactory colorChooserPanelFactory;

    public ColorComboBox() {
        this(Color.WHITE);
    }

    public ColorComboBox(Color color) {
        this.selectedColor = color;
        this.colorLabel = new ColorLabel(this.selectedColor);
        this.colorLabel.setPreferredSize(new Dimension(16, 16));
        this.colorLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ColorComboBox.this.requestFocusInWindow();
                ColorComboBox.this.showPopupWindow();
            }
        });
        this.setPreferredSize(new Dimension(60, 20));
        this.setLayout(new BorderLayout());
        this.add((Component)this.colorLabel, "Center");
        this.setFocusable(true);
    }

    public ColorChooserPanelFactory getColorChooserPanelFactory() {
        return this.colorChooserPanelFactory;
    }

    public void setColorChooserPanelFactory(ColorChooserPanelFactory colorChooserPanelFactory) {
        this.colorChooserPanelFactory = colorChooserPanelFactory;
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    public void setSelectedColor(Color selectedColor) {
        Color oldValue = this.selectedColor;
        this.selectedColor = selectedColor;
        this.colorLabel.setColor(selectedColor);
        this.firePropertyChange(SELECTED_COLOR_PROPERTY, oldValue, this.selectedColor);
    }

    private ColorChooserPanel createColorChooserPanel() {
        if (this.colorChooserPanelFactory != null) {
            return this.colorChooserPanelFactory.create(this.getSelectedColor());
        }
        return new ColorChooserPanel(this.getSelectedColor());
    }

    private void showPopupWindow() {
        if (this.popupWindow != null && this.popupWindow.isShowing()) {
            this.closePopupWindow();
            return;
        }
        Point location = this.getLocationOnScreen();
        location.y += this.getHeight();
        ColorChooserPanel colorChooserPanel = this.createColorChooserPanel();
        colorChooserPanel.addPropertyChangeListener(SELECTED_COLOR_PROPERTY, evt -> {
            this.setSelectedColor(colorChooserPanel.getSelectedColor());
            this.closePopupWindow();
        });
        this.popupWindow = new JidePopup();
        this.popupWindow.setOwner((Component)this);
        this.popupWindow.getContentPane().add(colorChooserPanel);
        this.popupWindow.setDefaultFocusComponent((Component)colorChooserPanel);
        this.popupWindow.setMovable(false);
        this.popupWindow.setAttachable(false);
        this.popupWindow.showPopup(location.x, location.y);
    }

    protected void closePopupWindow() {
        if (this.popupWindow != null) {
            this.popupWindow.hidePopupImmediately();
            this.popupWindow = null;
        }
    }
}

