/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.esa.snap.ui.UIUtils;

public class SequentialDialog {
    public static final int ID_BACK = 1;
    public static final int ID_NEXT = 2;
    public static final int ID_FINISH = 4;
    public static final int ID_CANCEL = 8;
    public static final int ID_HELP = 16;
    private JFrame frame;
    private JDialog dialog;
    private int buttonID = 8;
    private Vector names = new Vector();
    private int cardIndex = -1;
    private String titleBase;
    private JButton backButton = new JButton();
    private JButton nextButton = new JButton();
    private JButton finishButton = new JButton();
    private JButton cancelButton = new JButton();
    private JButton helpButton = new JButton();
    private CardLayout cardLayout = new CardLayout(6, 6);
    private JPanel cardPanel = new JPanel(this.cardLayout);

    public SequentialDialog(JFrame frame, String titleBase) {
        this(frame, titleBase, null, false);
    }

    public SequentialDialog(JFrame frame, String titleBase, Icon image, boolean hasHelp) {
        this.frame = frame;
        this.cardIndex = -1;
        this.dialog = new JDialog(frame, titleBase, true);
        this.titleBase = titleBase;
        JPanel buttonRow = new JPanel();
        buttonRow.setLayout(new BoxLayout(buttonRow, 0));
        buttonRow.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        JPanel panel1 = new JPanel(new BorderLayout());
        panel1.add("North", new HorizontalLine(4, 4));
        panel1.add("South", buttonRow);
        if (image != null) {
            this.dialog.getContentPane().add("West", new JLabel(image));
        }
        this.dialog.getContentPane().add("Center", this.cardPanel);
        this.dialog.getContentPane().add("South", panel1);
        this.backButton.setText("< Back");
        this.backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SequentialDialog.this.buttonID = 1;
                SequentialDialog.this.onBack();
            }
        });
        this.nextButton.setText("Next >");
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SequentialDialog.this.buttonID = 2;
                SequentialDialog.this.onNext();
            }
        });
        this.finishButton.setText("Finish");
        this.finishButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SequentialDialog.this.buttonID = 4;
                SequentialDialog.this.onFinish();
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SequentialDialog.this.buttonID = 8;
                SequentialDialog.this.onCancel();
            }
        });
        this.helpButton.setText("Help");
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SequentialDialog.this.buttonID = 16;
                SequentialDialog.this.onHelp();
            }
        });
        Dimension hgap = new Dimension(6, 0);
        buttonRow.add(Box.createHorizontalGlue());
        buttonRow.add(this.backButton);
        buttonRow.add(Box.createRigidArea(hgap));
        buttonRow.add(this.nextButton);
        buttonRow.add(Box.createRigidArea(hgap));
        buttonRow.add(this.finishButton);
        buttonRow.add(Box.createRigidArea(hgap));
        buttonRow.add(this.cancelButton);
        if (hasHelp) {
            buttonRow.add(Box.createRigidArea(hgap));
            buttonRow.add(this.helpButton);
        }
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SequentialDialog.this.buttonID = 8;
                SequentialDialog.this.onCancel();
            }
        });
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    public int getButtonID() {
        return this.buttonID;
    }

    public int getCardCount() {
        return this.cardPanel.getComponentCount();
    }

    public Component getCard(int index) {
        return this.cardPanel.getComponent(index);
    }

    public Component getCurrentCard() {
        return this.cardIndex < 0 ? null : this.getCard(this.cardIndex);
    }

    public String getCardName(int index) {
        return (String)this.names.elementAt(index);
    }

    public void addCard(String name, Component card) {
        this.cardPanel.add(card, name);
        this.names.addElement(name);
    }

    public int show() {
        if (this.getCardCount() > 0) {
            this.showCard(0);
        }
        this.dialog.pack();
        this.center();
        this.dialog.setVisible(true);
        return this.getButtonID();
    }

    public void hide() {
        this.dialog.setVisible(false);
    }

    public void center() {
        UIUtils.centerComponent(this.dialog, this.frame);
    }

    protected void onBack() {
        this.showCard(this.getPreviousCardIndex());
    }

    protected void onNext() {
        if (this.verifyUserInput()) {
            this.showCard(this.getNextCardIndex());
        }
    }

    protected void onFinish() {
        if (this.verifyUserInput()) {
            this.hide();
        }
    }

    protected void onCancel() {
        this.hide();
    }

    protected void onHelp() {
    }

    protected int getCurrentCardIndex() {
        return this.cardIndex;
    }

    protected int getPreviousCardIndex() {
        int cardIndexMin = 0;
        return this.cardIndex > cardIndexMin ? this.cardIndex - 1 : cardIndexMin;
    }

    protected int getNextCardIndex() {
        int cardIndexMax = this.getCardCount() - 1;
        return this.cardIndex < cardIndexMax ? this.cardIndex + 1 : cardIndexMax;
    }

    protected void showCard(int index) {
        this.cardIndex = index;
        this.cardLayout.show(this.cardPanel, this.getCardName(index));
        this.dialog.setTitle(this.titleBase + " - Step " + (this.cardIndex + 1) + " of " + this.getCardCount());
        this.updateButtonStates();
    }

    protected void updateButtonStates() {
        this.backButton.setEnabled(this.isBackPossible());
        this.nextButton.setEnabled(this.isNextPossible());
        this.finishButton.setEnabled(this.isFinishPossible());
    }

    protected boolean isBackPossible() {
        return this.getCurrentCardIndex() > 0;
    }

    protected boolean isNextPossible() {
        return this.getCurrentCardIndex() < this.getCardCount() - 1;
    }

    protected boolean isFinishPossible() {
        return this.getCurrentCardIndex() == this.getCardCount() - 1;
    }

    protected boolean verifyUserInput() {
        return true;
    }

    static class HorizontalLine
    extends Canvas {
        Dimension prefSize;

        HorizontalLine(int w, int h) {
            this.prefSize = new Dimension(w, h);
        }

        @Override
        public Dimension getMinimumSize() {
            return this.prefSize;
        }

        @Override
        public Dimension getPreferredSize() {
            return this.prefSize;
        }

        @Override
        public void paint(Graphics g) {
            Dimension size = this.getSize();
            int x1 = 0;
            int x2 = size.width - 1;
            int y1 = size.height / 2;
            int y2 = y1 + 1;
            g.setColor(this.getBackground().brighter());
            g.drawLine(x1, y1, x2, y1);
            g.setColor(this.getBackground().darker());
            g.drawLine(x1, y2, x2, y2);
        }
    }
}

