/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.ui.UIDefaults;

public class GridBagUtils {
    public static JPanel createPanel() {
        return new JPanel(new GridBagLayout());
    }

    public static JPanel createDefaultEmptyBorderPanel() {
        JPanel panel = GridBagUtils.createPanel();
        panel.setBorder(UIDefaults.getDialogBorder());
        return panel;
    }

    public static GridBagConstraints createConstraints(String code) {
        GridBagConstraints gbc = new GridBagConstraints();
        GridBagUtils.setAttributes(gbc, code);
        return gbc;
    }

    public static GridBagConstraints createDefaultConstraints() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 3, 0, 3);
        return gbc;
    }

    public static void addToPanel(JPanel panel, Component comp, GridBagConstraints gbc) {
        LayoutManager layoutManager = panel.getLayout();
        if (!(layoutManager instanceof GridBagLayout)) {
            throw new IllegalArgumentException("'panel' does not have a GridBagLayout manager");
        }
        GridBagLayout gbl = (GridBagLayout)layoutManager;
        gbl.setConstraints(comp, gbc);
        panel.add(comp);
    }

    public static void addToPanel(JPanel panel, Component comp, GridBagConstraints gbc, String code) {
        GridBagUtils.addToPanel(panel, comp, GridBagUtils.setAttributes(gbc, code));
    }

    public static void addHorizontalFiller(JPanel panel, GridBagConstraints gbc) {
        int fillOld = gbc.fill;
        int anchorOld = gbc.anchor;
        double weightxOld = gbc.weightx;
        if (gbc.gridx >= 0) {
            ++gbc.gridx;
        }
        gbc.fill = 2;
        gbc.anchor = 10;
        gbc.weightx = 1.0;
        GridBagUtils.addToPanel(panel, new JLabel(" "), gbc);
        gbc.weightx = weightxOld;
        gbc.anchor = anchorOld;
        gbc.fill = fillOld;
    }

    public static void addVerticalFiller(JPanel panel, GridBagConstraints gbc) {
        int fillOld = gbc.fill;
        int anchorOld = gbc.anchor;
        double weightyOld = gbc.weighty;
        if (gbc.gridy >= 0) {
            ++gbc.gridy;
        }
        gbc.fill = 3;
        gbc.anchor = 10;
        gbc.weighty = 200.0;
        GridBagUtils.addToPanel(panel, new JLabel(" "), gbc);
        gbc.weighty = weightyOld;
        gbc.anchor = anchorOld;
        gbc.fill = fillOld;
    }

    public static GridBagConstraints setAttributes(GridBagConstraints gbc, String code) {
        Guardian.assertNotNull((String)"gbc", (Object)gbc);
        if (code == null || code.trim().length() == 0) {
            return gbc;
        }
        StringTokenizer st = new StringTokenizer(code, ",", false);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int pos = token.indexOf(61);
            if (pos < 0) {
                throw new IllegalArgumentException("illegal token '" + token + "'");
            }
            String key = token.substring(0, pos).trim();
            String value = token.substring(pos + 1).trim();
            try {
                if (key.equals("gridx")) {
                    if (value.equals("RELATIVE")) {
                        gbc.gridx = -1;
                        continue;
                    }
                    gbc.gridx = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("gridy")) {
                    if (value.equals("RELATIVE")) {
                        gbc.gridy = -1;
                        continue;
                    }
                    gbc.gridy = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("gridwidth")) {
                    if (value.equals("RELATIVE")) {
                        gbc.gridwidth = -1;
                        continue;
                    }
                    if (value.equals("REMAINDER")) {
                        gbc.gridwidth = 0;
                        continue;
                    }
                    gbc.gridwidth = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("gridheight")) {
                    if (value.equals("RELATIVE")) {
                        gbc.gridheight = -1;
                        continue;
                    }
                    if (value.equals("REMAINDER")) {
                        gbc.gridheight = 0;
                        continue;
                    }
                    gbc.gridheight = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("weightx")) {
                    gbc.weightx = Double.parseDouble(value);
                    continue;
                }
                if (key.equals("weighty")) {
                    gbc.weighty = Double.parseDouble(value);
                    continue;
                }
                if (key.equals("anchor")) {
                    if (value.equals("CENTER")) {
                        gbc.anchor = 10;
                        continue;
                    }
                    if (value.equals("NORTH")) {
                        gbc.anchor = 11;
                        continue;
                    }
                    if (value.equals("NORTHEAST")) {
                        gbc.anchor = 12;
                        continue;
                    }
                    if (value.equals("EAST")) {
                        gbc.anchor = 13;
                        continue;
                    }
                    if (value.equals("SOUTHEAST")) {
                        gbc.anchor = 14;
                        continue;
                    }
                    if (value.equals("SOUTH")) {
                        gbc.anchor = 15;
                        continue;
                    }
                    if (value.equals("SOUTHWEST")) {
                        gbc.anchor = 16;
                        continue;
                    }
                    if (value.equals("WEST")) {
                        gbc.anchor = 17;
                        continue;
                    }
                    if (value.equals("NORTHWEST")) {
                        gbc.anchor = 18;
                        continue;
                    }
                    gbc.anchor = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("fill")) {
                    if (value.equals("NONE")) {
                        gbc.fill = 0;
                        continue;
                    }
                    if (value.equals("HORIZONTAL")) {
                        gbc.fill = 2;
                        continue;
                    }
                    if (value.equals("VERTICAL")) {
                        gbc.fill = 3;
                        continue;
                    }
                    if (value.equals("BOTH")) {
                        gbc.fill = 1;
                        continue;
                    }
                    gbc.fill = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("insets.bottom")) {
                    gbc.insets.bottom = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("insets.left")) {
                    gbc.insets.left = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("insets.right")) {
                    gbc.insets.right = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("insets.top")) {
                    gbc.insets.top = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("insets")) {
                    gbc.insets.right = gbc.insets.bottom = Integer.parseInt(value);
                    gbc.insets.left = gbc.insets.bottom;
                    gbc.insets.top = gbc.insets.bottom;
                    continue;
                }
                if (key.equals("ipadx")) {
                    gbc.ipadx = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("ipady")) {
                    gbc.ipady = Integer.parseInt(value);
                    continue;
                }
                throw new IllegalArgumentException("unknown key '" + key + "'");
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("illegal value '" + value + "' for key '" + key + "'");
            }
        }
        return gbc;
    }
}

