/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.pgx;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.dataio.pgx.PgxProductReader;

public class PgxProductReaderPlugIn
implements ProductReaderPlugIn {
    public String[] getFormatNames() {
        return new String[]{"PGX"};
    }

    public String[] getDefaultFileExtensions() {
        return new String[]{".pgx"};
    }

    public String getDescription(Locale name) {
        return "PGX images";
    }

    public DecodeQualification getDecodeQualification(Object input) {
        if (input instanceof String || input instanceof File ? this.canReadHeader(new File(input.toString())) : input instanceof ImageInputStream && this.canReadHeader((ImageInputStream)input)) {
            return DecodeQualification.INTENDED;
        }
        return DecodeQualification.UNABLE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean canReadHeader(File file) {
        if (!file.isFile()) return false;
        if (file.length() == 0L) {
            return false;
        }
        try (FileImageInputStream stream = new FileImageInputStream(file);){
            boolean bl = this.canReadHeader(stream);
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean canReadHeader(ImageInputStream stream) {
        try {
            return PgxProductReader.readHeader(stream) != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    public Class[] getInputTypes() {
        return new Class[]{String.class, File.class, ImageInputStream.class};
    }

    public ProductReader createReaderInstance() {
        return new PgxProductReader(this);
    }

    public SnapFileFilter getProductFileFilter() {
        return new SnapFileFilter(this.getFormatNames()[0], this.getDefaultFileExtensions(), this.getDescription(null));
    }
}

