/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.geotiff;

import it.geosolutions.imageio.plugins.tiff.TIFFField;
import it.geosolutions.imageio.plugins.tiff.TIFFTag;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFIFD;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageMetadata;
import java.util.Map;
import java.util.SortedMap;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.geotiff.EPSGCodes;
import org.esa.snap.dataio.geotiff.TiffFileInfo;
import org.esa.snap.dataio.geotiff.internal.GeoKeyEntry;

class TiffTagToMetadataConverter {
    private static final int[] PROCESSED_GEO_TIFF_TAGS = new int[]{33550, 33922, 34264};

    private TiffTagToMetadataConverter() {
    }

    public static void addTiffTagsToMetadata(TIFFImageMetadata imageMetadata, TiffFileInfo tiffInfo, MetadataElement metadataElem) {
        TIFFField[] tiffFields;
        MetadataElement tiffMetadata = new MetadataElement("TIFF Metadata");
        if (tiffInfo.isGeotiff()) {
            MetadataElement geoTiffMetadata = new MetadataElement("GeoTIFF Metadata");
            TiffTagToMetadataConverter.addGeoTiffTagsToMetadata(tiffInfo, geoTiffMetadata);
            tiffMetadata.addElement(geoTiffMetadata);
        }
        TIFFIFD tiffifd = imageMetadata.getRootIFD();
        for (TIFFField tiffField : tiffFields = tiffifd.getTIFFFields()) {
            int tagNumber = tiffField.getTag().getNumber();
            if (tagNumber == 65000 || TiffTagToMetadataConverter.isGeoTiffTag(tagNumber)) continue;
            MetadataAttribute attribute = TiffTagToMetadataConverter.generateMetadataAttribute(tiffField);
            tiffMetadata.addAttribute(attribute);
        }
        metadataElem.addElement(tiffMetadata);
    }

    private static boolean isGeoTiffTag(int tagNumber) {
        return tagNumber == 34735 || tagNumber == 34737 || tagNumber == 34736 || tagNumber == 33550 || tagNumber == 33922 || tagNumber == 34264;
    }

    private static void addGeoTiffTagsToMetadata(TiffFileInfo tiffInfo, MetadataElement geoTiffMetadata) {
        MetadataAttribute attribute;
        TIFFField field = tiffInfo.getField(34735);
        MetadataElement geoKeyDirMetadata = new MetadataElement(field.getTag().getName());
        geoTiffMetadata.addElement(geoKeyDirMetadata);
        SortedMap<Integer, GeoKeyEntry> geoKeyMap = tiffInfo.getGeoKeyEntries();
        for (Map.Entry<Integer, GeoKeyEntry> entry : geoKeyMap.entrySet()) {
            ProductData data;
            GeoKeyEntry geoKeyEntry = entry.getValue();
            String name = geoKeyEntry.getName();
            if (name == null || (data = TiffTagToMetadataConverter.getGeoKeyValue(geoKeyEntry)) == null) continue;
            attribute = new MetadataAttribute(name, data, true);
            geoKeyDirMetadata.addAttribute(attribute);
        }
        for (Object tagNunmber : (Object)PROCESSED_GEO_TIFF_TAGS) {
            TIFFField tiffField = tiffInfo.getField((int)tagNunmber);
            if (tiffField == null) continue;
            attribute = TiffTagToMetadataConverter.generateMetadataAttribute(tiffField);
            geoTiffMetadata.addAttribute(attribute);
        }
    }

    private static MetadataAttribute generateMetadataAttribute(TIFFField tiffField) {
        TIFFTag geoTiffTag = tiffField.getTag();
        String name = geoTiffTag.getName();
        int dataCount = tiffField.getCount();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < dataCount; ++i) {
            if (geoTiffTag.hasValueNames()) {
                sb.append(geoTiffTag.getValueName(tiffField.getAsInt(i)));
            } else {
                sb.append(tiffField.getValueAsString(i));
            }
            if (i + 1 >= dataCount) continue;
            sb.append(", ");
        }
        ProductData value = ProductData.createInstance((String)sb.toString());
        return new MetadataAttribute(name, value, true);
    }

    private static ProductData getGeoKeyValue(GeoKeyEntry geoKeyEntry) {
        ProductData value = geoKeyEntry.getDblValue() != null ? ProductData.createInstance((double[])geoKeyEntry.getDblValue()) : (geoKeyEntry.getStrValue() != null ? ProductData.createInstance((String)geoKeyEntry.getStrValue()) : (geoKeyEntry.getKeyId() == 1024 ? TiffTagToMetadataConverter.getModelTypeValueName(geoKeyEntry.getIntValue()) : (geoKeyEntry.getKeyId() == 1025 ? TiffTagToMetadataConverter.getRasterTypeValueName(geoKeyEntry.getIntValue()) : TiffTagToMetadataConverter.getEPSGValueName(geoKeyEntry))));
        return value;
    }

    private static ProductData getEPSGValueName(GeoKeyEntry geoKeyEntry) {
        String epsgCodeName = EPSGCodes.getInstance().getName(geoKeyEntry.getIntValue().intValue());
        ProductData value = epsgCodeName == null ? ProductData.createInstance((int)geoKeyEntry.getIntValue()) : ProductData.createInstance((String)epsgCodeName);
        return value;
    }

    private static ProductData getRasterTypeValueName(Integer intValue) {
        ProductData value = intValue == 1 ? ProductData.createInstance((String)"RasterPixelIsArea") : (intValue == 2 ? ProductData.createInstance((String)"RasterPixelIsPoint") : ProductData.createInstance((String)"unknown"));
        return value;
    }

    private static ProductData getModelTypeValueName(Integer intValue) {
        ProductData value = intValue == 1 ? ProductData.createInstance((String)"ModelTypeProjected") : (intValue == 2 ? ProductData.createInstance((String)"ModelTypeGeographic") : (intValue == 3 ? ProductData.createInstance((String)"ModelTypeGeocentric") : ProductData.createInstance((String)"unknown")));
        return value;
    }
}

