/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.geotiff;

import java.io.File;
import java.util.Locale;
import org.esa.snap.core.dataio.EncodeQualification;
import org.esa.snap.core.dataio.ProductWriter;
import org.esa.snap.core.dataio.ProductWriterPlugIn;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.MapGeoCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.dataio.geotiff.GeoTiffProductWriter;

public class GeoTiffProductWriterPlugIn
implements ProductWriterPlugIn {
    public static final String GEOTIFF_FORMAT_NAME = "GeoTIFF";
    public static final String[] GEOTIFF_FILE_EXTENSION = new String[]{".tif", ".tiff"};
    private static final String DESCRIPTION = "GeoTIFF product";

    public EncodeQualification getEncodeQualification(Product product) {
        GeoCoding geoCoding = product.getSceneGeoCoding();
        if (geoCoding == null) {
            return new EncodeQualification(EncodeQualification.Preservation.PARTIAL, "The product is not geo-coded. A usual TIFF file will be written instead.");
        }
        if (!(geoCoding instanceof MapGeoCoding) && !(geoCoding instanceof CrsGeoCoding)) {
            return new EncodeQualification(EncodeQualification.Preservation.PARTIAL, "The product is geo-coded but seems not rectified. Geo-coding information may not be properly preserved.");
        }
        if (product.isMultiSize()) {
            return new EncodeQualification(EncodeQualification.Preservation.UNABLE, "Cannot write multisize products. Consider resampling the product first.");
        }
        return new EncodeQualification(EncodeQualification.Preservation.FULL);
    }

    public String[] getFormatNames() {
        return new String[]{GEOTIFF_FORMAT_NAME};
    }

    public String[] getDefaultFileExtensions() {
        return (String[])GEOTIFF_FILE_EXTENSION.clone();
    }

    public Class[] getOutputTypes() {
        return new Class[]{String.class, File.class};
    }

    public String getDescription(Locale name) {
        return DESCRIPTION;
    }

    public ProductWriter createWriterInstance() {
        return new GeoTiffProductWriter(this);
    }

    public SnapFileFilter getProductFileFilter() {
        return new SnapFileFilter(this.getFormatNames()[0], this.getDefaultFileExtensions(), this.getDescription(null));
    }
}

