/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.operator.ui;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyAccessor;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.accessors.DefaultPropertyAccessor;
import com.bc.ceres.swing.binding.BindingContext;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import org.esa.snap.binning.AggregatorConfig;
import org.esa.snap.binning.operator.BinningOp;
import org.esa.snap.binning.operator.VariableConfig;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.core.gpf.annotations.ParameterDescriptorFactory;
import org.esa.snap.core.util.StringUtils;

class BinningFormModel {
    static final String PROPERTY_KEY_WEST_BOUND = "westBound";
    static final String PROPERTY_KEY_NORTH_BOUND = "northBound";
    static final String PROPERTY_KEY_EAST_BOUND = "eastBound";
    static final String PROPERTY_KEY_SOUTH_BOUND = "southBound";
    static final String PROPERTY_KEY_WKT = "manualWkt";
    static final String PROPERTY_KEY_AGGREGATOR_CONFIGS = "aggregatorConfigs";
    static final String PROPERTY_KEY_VARIABLE_CONFIGS = "variableConfigs";
    static final String PROPERTY_KEY_REGION = "region";
    static final String PROPERTY_KEY_BOUNDS = "bounds";
    static final String PROPERTY_KEY_COMPUTE_REGION = "compute";
    static final String PROPERTY_KEY_GLOBAL = "global";
    static final String PROPERTY_KEY_MASK_EXPR = "maskExpr";
    static final String PROPERTY_KEY_TIME_FILTER_METHOD = "timeFilterMethod";
    static final String PROPERTY_KEY_START_DATE_TIME = "startDateTime";
    static final String PROPERTY_KEY_PERIOD_DURATION = "periodDuration";
    static final String PROPERTY_KEY_MIN_DATA_HOUR = "minDataHour";
    static final String PROPERTY_KEY_NUM_ROWS = "numRows";
    static final String PROPERTY_KEY_SUPERSAMPLING = "superSampling";
    static final String PROPERTY_KEY_MANUAL_WKT = "manualWktKey";
    static final String PROPERTY_KEY_SOURCE_PRODUCTS = "sourceProducts";
    static final String PROPERTY_KEY_SOURCE_PRODUCT_PATHS = "sourceProductPaths";
    static final String PROPERTY_KEY_CONTEXT_SOURCE_PRODUCT = "contextSourceProduct";
    static final String GLOBAL_WKT = "polygon((-180 -90, 180 -90, 180 90, -180 90, -180 -90))";
    static final int DEFAULT_NUM_ROWS = 2160;
    private PropertySet propertySet;
    private BindingContext bindingContext;
    private HashMap<String, Object> parameterMap = new HashMap();

    public BinningFormModel() {
        this.propertySet = ParameterDescriptorFactory.createMapBackedOperatorPropertyContainer((String)"Binning", this.parameterMap);
        this.hideProperties();
        this.propertySet.addProperty(BinningFormModel.createTransientProperty(PROPERTY_KEY_GLOBAL, Boolean.class));
        this.propertySet.addProperty(BinningFormModel.createTransientProperty(PROPERTY_KEY_COMPUTE_REGION, Boolean.class));
        this.propertySet.addProperty(BinningFormModel.createTransientProperty(PROPERTY_KEY_MANUAL_WKT, Boolean.class));
        this.propertySet.addProperty(BinningFormModel.createTransientProperty(PROPERTY_KEY_WKT, String.class));
        this.propertySet.addProperty(BinningFormModel.createTransientProperty(PROPERTY_KEY_BOUNDS, Boolean.class));
        this.propertySet.addProperty(BinningFormModel.createTransientProperty(PROPERTY_KEY_EAST_BOUND, Double.class));
        this.propertySet.addProperty(BinningFormModel.createTransientProperty(PROPERTY_KEY_NORTH_BOUND, Double.class));
        this.propertySet.addProperty(BinningFormModel.createTransientProperty(PROPERTY_KEY_WEST_BOUND, Double.class));
        this.propertySet.addProperty(BinningFormModel.createTransientProperty(PROPERTY_KEY_SOUTH_BOUND, Double.class));
        this.propertySet.addProperty(BinningFormModel.createTransientProperty(PROPERTY_KEY_SOURCE_PRODUCTS, Product[].class));
        this.propertySet.addProperty(BinningFormModel.createTransientProperty(PROPERTY_KEY_CONTEXT_SOURCE_PRODUCT, Product.class));
        this.propertySet.setDefaultValues();
        this.propertySet.getProperty(PROPERTY_KEY_REGION).addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Geometry newGeometry = (Geometry)evt.getNewValue();
                BinningFormModel.this.propertySet.setValue(BinningFormModel.PROPERTY_KEY_MANUAL_WKT, (Object)true);
                BinningFormModel.this.propertySet.setValue(BinningFormModel.PROPERTY_KEY_WKT, (Object)newGeometry.toText());
            }
        });
    }

    void hideProperties() {
        this.propertySet.getProperty("metadataPropertiesFile").getDescriptor().setTransient(true);
        this.propertySet.getProperty("metadataTemplateDir").getDescriptor().setTransient(true);
        this.propertySet.getProperty("outputType").getDescriptor().setTransient(true);
        this.propertySet.getProperty("outputFormat").getDescriptor().setTransient(true);
        this.propertySet.getProperty("outputBinnedData").getDescriptor().setTransient(true);
        this.propertySet.getProperty("outputMappedProduct").getDescriptor().setTransient(true);
    }

    public PropertySet getPropertySet() {
        return this.propertySet;
    }

    public HashMap<String, Object> getParameterMap() {
        return this.parameterMap;
    }

    public Product[] getSourceProducts() {
        Product[] products = (Product[])this.getPropertyValue(PROPERTY_KEY_SOURCE_PRODUCTS);
        if (products == null) {
            return new Product[0];
        }
        return products;
    }

    public String[] getSourceProductPaths() {
        return (String[])this.getPropertyValue(PROPERTY_KEY_SOURCE_PRODUCT_PATHS);
    }

    public Product getContextProduct() {
        return (Product)this.getPropertyValue(PROPERTY_KEY_CONTEXT_SOURCE_PRODUCT);
    }

    public void useAsContextProduct(Product contextProduct) {
        Product currentContextProduct = this.createContextProduct(contextProduct);
        this.propertySet.setValue(PROPERTY_KEY_CONTEXT_SOURCE_PRODUCT, (Object)currentContextProduct);
    }

    /*
     * WARNING - void declaration
     */
    private Product createContextProduct(Product srcProduct) {
        void var6_17;
        VariableConfig[] variableConfigs;
        if (srcProduct == null) {
            return null;
        }
        Product contextProduct = new Product("contextProduct", srcProduct.getProductType(), 10, 10);
        for (String string : srcProduct.getFlagCodingGroup().getNodeNames()) {
            FlagCoding srcFC = (FlagCoding)srcProduct.getFlagCodingGroup().get(string);
            String[] flagNames = srcFC.getFlagNames();
            FlagCoding contextFC = new FlagCoding(string);
            for (String flagName : flagNames) {
                contextFC.addFlag(flagName, srcFC.getFlagMask(flagName), srcFC.getFlag(flagName).getDescription());
            }
            contextProduct.getFlagCodingGroup().add((ProductNode)contextFC);
        }
        for (String string : srcProduct.getBands()) {
            Band contextBand = contextProduct.addBand(string.getName(), string.getDataType());
            if (!string.isFlagBand()) continue;
            contextBand.setSampleCoding((SampleCoding)contextProduct.getFlagCodingGroup().get(string.getFlagCoding().getName()));
        }
        for (String string : srcProduct.getTiePointGrids()) {
            contextProduct.addTiePointGrid(new TiePointGrid(string.getName(), 10, 10, 0.0, 0.0, 1.0, 1.0, new float[100]));
        }
        for (String string : srcProduct.getVectorDataGroup().getNodeNames()) {
            VectorDataNode vectorData = (VectorDataNode)srcProduct.getVectorDataGroup().get(string);
            contextProduct.getVectorDataGroup().add((ProductNode)new VectorDataNode(string, vectorData.getFeatureType()));
        }
        for (String string : srcProduct.getMaskGroup().getNodeNames()) {
            Mask mask = (Mask)srcProduct.getMaskGroup().get(string);
            contextProduct.addMask(string, mask.getImageType());
        }
        VariableConfig[] variableConfigArray = variableConfigs = this.getVariableConfigs();
        int n = variableConfigArray.length;
        boolean bl = false;
        while (var6_17 < n) {
            VariableConfig variableConfig = variableConfigArray[var6_17];
            contextProduct.addBand((Band)new VariableConfigBand(variableConfig.getName()));
            ++var6_17;
        }
        return contextProduct;
    }

    public AggregatorConfig[] getAggregatorConfigs() {
        AggregatorConfig[] aggregatorConfigs = (AggregatorConfig[])this.getPropertyValue(PROPERTY_KEY_AGGREGATOR_CONFIGS);
        if (aggregatorConfigs == null) {
            aggregatorConfigs = new AggregatorConfig[]{};
        }
        return aggregatorConfigs;
    }

    public VariableConfig[] getVariableConfigs() {
        VariableConfig[] variableConfigs = (VariableConfig[])this.getPropertyValue(PROPERTY_KEY_VARIABLE_CONFIGS);
        if (variableConfigs == null) {
            variableConfigs = new VariableConfig[]{};
        }
        return variableConfigs;
    }

    public void setVariableConfigs(VariableConfig[] variableConfigs) throws ValidationException {
        if (variableConfigs == null) {
            variableConfigs = new VariableConfig[]{};
        }
        this.setProperty(PROPERTY_KEY_VARIABLE_CONFIGS, variableConfigs);
        Product contextProduct = this.getContextProduct();
        if (contextProduct != null) {
            this.removeAllVariableConfigBands(contextProduct);
            for (VariableConfig variableConfig : variableConfigs) {
                contextProduct.addBand((Band)new VariableConfigBand(variableConfig.getName()));
            }
        }
    }

    void removeAllVariableConfigBands(Product contextProduct) {
        Band[] bands;
        for (Band band : bands = contextProduct.getBands()) {
            if (!(band instanceof VariableConfigBand)) continue;
            contextProduct.removeBand(band);
        }
    }

    public Geometry getRegion() {
        if (Boolean.TRUE.equals(this.getPropertyValue(PROPERTY_KEY_GLOBAL))) {
            return this.toGeometry(GLOBAL_WKT);
        }
        if (Boolean.TRUE.equals(this.getPropertyValue(PROPERTY_KEY_COMPUTE_REGION))) {
            return null;
        }
        if (Boolean.TRUE.equals(this.getPropertyValue(PROPERTY_KEY_BOUNDS))) {
            double westValue = (Double)this.getPropertyValue(PROPERTY_KEY_WEST_BOUND);
            double eastValue = (Double)this.getPropertyValue(PROPERTY_KEY_EAST_BOUND);
            double northValue = (Double)this.getPropertyValue(PROPERTY_KEY_NORTH_BOUND);
            double southValue = (Double)this.getPropertyValue(PROPERTY_KEY_SOUTH_BOUND);
            Coordinate[] coordinates = new Coordinate[]{new Coordinate(westValue, southValue), new Coordinate(westValue, northValue), new Coordinate(eastValue, northValue), new Coordinate(eastValue, southValue), new Coordinate(westValue, southValue)};
            GeometryFactory geometryFactory = new GeometryFactory();
            return geometryFactory.createPolygon(geometryFactory.createLinearRing(coordinates), null);
        }
        if (Boolean.TRUE.equals(this.getPropertyValue(PROPERTY_KEY_MANUAL_WKT))) {
            return this.toGeometry((String)this.getPropertyValue(PROPERTY_KEY_WKT));
        }
        throw new IllegalStateException("Should never come here");
    }

    Geometry toGeometry(String wkt) {
        try {
            return new WKTReader().read(wkt);
        }
        catch (ParseException e) {
            throw new IllegalStateException("WKT for region is not valid:\n" + wkt);
        }
    }

    public String getMaskExpr() {
        String propertyValue = (String)this.getPropertyValue(PROPERTY_KEY_MASK_EXPR);
        if (StringUtils.isNullOrEmpty((String)propertyValue)) {
            return "true";
        }
        return propertyValue;
    }

    public BinningOp.TimeFilterMethod getTimeFilterMethod() {
        return (BinningOp.TimeFilterMethod)this.propertySet.getProperty(PROPERTY_KEY_TIME_FILTER_METHOD).getValue();
    }

    public String getStartDateTime() {
        BinningOp.TimeFilterMethod temporalFilter = (BinningOp.TimeFilterMethod)this.getPropertyValue(PROPERTY_KEY_TIME_FILTER_METHOD);
        switch (temporalFilter) {
            case NONE: {
                return null;
            }
            case TIME_RANGE: 
            case SPATIOTEMPORAL_DATA_DAY: {
                return (String)this.getPropertyValue(PROPERTY_KEY_START_DATE_TIME);
            }
        }
        throw new IllegalStateException("Illegal temporal filter method: '" + temporalFilter + "'");
    }

    public Double getPeriodDuration() {
        return (Double)this.getPropertyValue(PROPERTY_KEY_PERIOD_DURATION);
    }

    public Double getMinDataHour() {
        return (Double)this.getPropertyValue(PROPERTY_KEY_MIN_DATA_HOUR);
    }

    public int getSuperSampling() {
        if (this.getPropertyValue(PROPERTY_KEY_SUPERSAMPLING) == null) {
            return 1;
        }
        return (Integer)this.getPropertyValue(PROPERTY_KEY_SUPERSAMPLING);
    }

    public int getNumRows() {
        if (this.getPropertyValue(PROPERTY_KEY_NUM_ROWS) == null) {
            return 2160;
        }
        return (Integer)this.getPropertyValue(PROPERTY_KEY_NUM_ROWS);
    }

    public void setProperty(String key, Object value) throws ValidationException {
        if (!this.propertySet.isPropertyDefined(key)) {
            throw new IllegalStateException("Unknown property: " + key);
        }
        Property property = this.propertySet.getProperty(key);
        property.setValue(value);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySet.addPropertyChangeListener(propertyChangeListener);
    }

    public BindingContext getBindingContext() {
        if (this.bindingContext == null) {
            this.bindingContext = new BindingContext(this.propertySet);
        }
        return this.bindingContext;
    }

    <T> T getPropertyValue(String key) {
        Property property = this.propertySet.getProperty(key);
        if (property != null) {
            return (T)property.getValue();
        }
        return null;
    }

    private static Property createTransientProperty(String name, Class type) {
        DefaultPropertyAccessor defaultAccessor = new DefaultPropertyAccessor();
        PropertyDescriptor descriptor = new PropertyDescriptor(name, type);
        descriptor.setTransient(true);
        descriptor.setDefaultConverter();
        return new Property(descriptor, (PropertyAccessor)defaultAccessor);
    }

    private static class VariableConfigBand
    extends Band {
        public VariableConfigBand(String varName) {
            super(varName, 30, 10, 10);
        }
    }
}

