/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.worldwind;

import gov.nasa.worldwind.layers.Earth.MSVirtualEarthLayer;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import org.esa.snap.core.datamodel.ProductManager;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.util.SelectionSupport;
import org.esa.snap.runtime.Config;
import org.esa.snap.ui.product.ProductSceneView;
import org.esa.snap.worldwind.Bundle;
import org.esa.snap.worldwind.WWBaseToolView;
import org.esa.snap.worldwind.WWProductManagerListener;
import org.esa.snap.worldwind.WWView;
import org.esa.snap.worldwind.layers.WWLayer;
import org.esa.snap.worldwind.layers.WWLayerDescriptor;
import org.esa.snap.worldwind.layers.WWLayerRegistry;
import org.netbeans.api.annotations.common.NullAllowed;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="WWWorldMapToolView", iconBase="org/esa/snap/icons/WorldMap24.png", persistenceType=0)
public class WWWorldViewToolView
extends WWBaseToolView
implements WWView {
    public static String useFlatEarth = "snap.worldwind.useFlatEarth";
    private ProductSceneView currentView;
    private static final boolean includeStatusBar = true;
    private final boolean flatWorld;

    public WWWorldViewToolView() {
        this.setDisplayName(Bundle.CTL_WorldWindTopComponentName());
        this.flatWorld = Config.instance().preferences().getBoolean(useFlatEarth, false);
        this.initComponents();
        SnapApp.getDefault().getSelectionSupport(ProductSceneView.class).addHandler((oldValue, newValue) -> this.setCurrentView((ProductSceneView)newValue));
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(4, 4));
        this.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.add(this.createControl(), "Center");
    }

    public JComponent createControl() {
        Window windowPane = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (windowPane != null) {
            windowPane.setSize(300, 300);
        }
        JPanel mainPane = new JPanel(new BorderLayout(4, 4));
        mainPane.setSize(new Dimension(300, 300));
        this.initialize(mainPane);
        return mainPane;
    }

    private void initialize(final JPanel mainPane) {
        final WWWorldViewToolView toolView = this;
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                try {
                    WWLayerDescriptor[] wwLayerDescriptors;
                    WWWorldViewToolView.this.createWWPanel(null, true, WWWorldViewToolView.this.flatWorld, true);
                    mainPane.add((Component)WWWorldViewToolView.this.wwjPanel, "Center");
                    LayerList layerList = WWWorldViewToolView.this.getWwd().getModel().getLayers();
                    MSVirtualEarthLayer virtualEarthLayerA = new MSVirtualEarthLayer("gov.nasa.worldwind.layers.Earth.MSVirtualEarthLayer.Aerial");
                    virtualEarthLayerA.setName("MS Bing Aerial");
                    layerList.add(virtualEarthLayerA);
                    for (WWLayerDescriptor layerDescriptor : wwLayerDescriptors = WWLayerRegistry.getInstance().getWWLayerDescriptors()) {
                        if (!layerDescriptor.showInWorldMapToolView()) continue;
                        WWLayer wwLayer = layerDescriptor.createWWLayer();
                        layerList.add(wwLayer);
                        wwLayer.setOpacity(1.0);
                        wwLayer.setPickEnabled(false);
                    }
                    Layer placeNameLayer = layerList.getLayerByName("Place Names");
                    placeNameLayer.setEnabled(true);
                    SnapApp.getDefault().getProductManager().addListener((ProductManager.Listener)new WWProductManagerListener(toolView));
                    SnapApp.getDefault().getSelectionSupport(ProductNode.class).addHandler((SelectionSupport.Handler)new SelectionSupport.Handler<ProductNode>(){

                        public void selectionChange(@NullAllowed ProductNode oldValue, @NullAllowed ProductNode newValue) {
                            if (newValue != null) {
                                WWWorldViewToolView.this.setSelectedProduct(newValue.getProduct());
                            } else {
                                WWWorldViewToolView.this.setSelectedProduct(null);
                            }
                        }
                    });
                    WWWorldViewToolView.this.setProducts(SnapApp.getDefault().getProductManager().getProducts());
                    WWWorldViewToolView.this.setSelectedProduct(SnapApp.getDefault().getSelectedProduct(SnapApp.SelectionSourceHint.VIEW));
                }
                catch (Throwable e) {
                    SnapApp.getDefault().handleError("Unable to initialize WWWorldMapToolView: " + e.getMessage(), e);
                }
                return null;
            }
        };
        worker.execute();
    }

    public void setCurrentView(ProductSceneView newView) {
        if (this.currentView != newView) {
            this.currentView = newView;
        }
    }
}

