/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.worldwind;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.awt.WorldWindowGLCanvas;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.layers.Earth.MSVirtualEarthLayer;
import gov.nasa.worldwind.layers.Earth.OSMMapnikLayer;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.layers.placename.PlaceNameLayer;
import gov.nasa.worldwindx.examples.WMSLayersPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URISyntaxException;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductManager;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.util.SelectionSupport;
import org.esa.snap.worldwind.LayerPanel;
import org.esa.snap.worldwind.ProductPanel;
import org.esa.snap.worldwind.WWBaseToolView;
import org.esa.snap.worldwind.WWProductManagerListener;
import org.esa.snap.worldwind.WWView;
import org.esa.snap.worldwind.layers.DefaultProductLayer;
import org.esa.snap.worldwind.layers.WWLayer;
import org.esa.snap.worldwind.layers.WWLayerDescriptor;
import org.esa.snap.worldwind.layers.WWLayerRegistry;
import org.netbeans.api.annotations.common.NullAllowed;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="WWAnalysisToolView", iconBase="org/esa/snap/worldwind/icons/earth24.png", persistenceType=2)
public class WWAnalysisToolView
extends WWBaseToolView
implements WWView {
    private LayerPanel layerPanel = null;
    private ProductPanel productPanel = null;
    private final Dimension wmsPanelSize = new Dimension(400, 600);
    private final JTabbedPane tabbedPane = new JTabbedPane();
    private int previousTabIndex = 0;
    private static final boolean includeStatusBar = true;
    private static final boolean includeLayerPanel = false;
    private static final boolean includeProductPanel = true;
    private static final boolean includeWMSPanel = false;
    private static final String[] servers = new String[]{"http://neowms.sci.gsfc.nasa.gov/wms/wms", "http://wms.jpl.nasa.gov/wms.cgi", "http://worldwind46.arc.nasa.gov:8087/wms"};

    public WWAnalysisToolView() {
        this.setDisplayName("WorldWind Analysis");
        this.setLayout(new BorderLayout(4, 4));
        this.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.add(this.createControl(), "Center");
    }

    public JComponent createControl() {
        Window windowPane = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (windowPane != null) {
            windowPane.setSize(800, 400);
        }
        JPanel mainPane = new JPanel(new BorderLayout(4, 4));
        mainPane.setSize(new Dimension(300, 300));
        this.initialize(mainPane);
        return mainPane;
    }

    private static void insertTiledLayer(WorldWindow wwd, Layer layer) {
        int position = 0;
        LayerList layers = wwd.getModel().getLayers();
        for (Layer l : layers) {
            if (!(l instanceof PlaceNameLayer)) continue;
            position = layers.indexOf(l);
            break;
        }
        layers.add(position, layer);
    }

    private void initialize(final JPanel mainPane) {
        SystemUtils.LOG.info("INITIALIZE IN WWAnalysisToolView CALLED includeLayerPanel false includeProductPanel true");
        final WWAnalysisToolView toolView = this;
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                try {
                    WWLayerDescriptor[] wwLayerDescriptors;
                    WorldWindowGLCanvas shareWith = WWAnalysisToolView.this.findWorldWindView();
                    WWAnalysisToolView.this.createWWPanel(shareWith, true, false, false);
                    WWAnalysisToolView.this.wwjPanel.addLayerPanelLayer();
                    WWAnalysisToolView.this.wwjPanel.addElevation();
                    MSVirtualEarthLayer virtualEarthLayerA = new MSVirtualEarthLayer("gov.nasa.worldwind.layers.Earth.MSVirtualEarthLayer.Aerial");
                    virtualEarthLayerA.setName("MS Bing Aerial");
                    WWAnalysisToolView.insertTiledLayer(WWAnalysisToolView.this.getWwd(), virtualEarthLayerA);
                    MSVirtualEarthLayer virtualEarthLayerR = new MSVirtualEarthLayer("gov.nasa.worldwind.layers.Earth.MSVirtualEarthLayer.Roads");
                    virtualEarthLayerR.setName("MS Bing Roads");
                    virtualEarthLayerR.setEnabled(false);
                    WWAnalysisToolView.insertTiledLayer(WWAnalysisToolView.this.getWwd(), virtualEarthLayerR);
                    MSVirtualEarthLayer virtualEarthLayerH = new MSVirtualEarthLayer("gov.nasa.worldwind.layers.Earth.MSVirtualEarthLayer.Hybrid");
                    virtualEarthLayerH.setName("MS Bing Hybrid");
                    virtualEarthLayerH.setEnabled(false);
                    WWAnalysisToolView.insertTiledLayer(WWAnalysisToolView.this.getWwd(), virtualEarthLayerH);
                    OSMMapnikLayer streetLayer = new OSMMapnikLayer();
                    streetLayer.setOpacity(0.7);
                    streetLayer.setEnabled(false);
                    streetLayer.setName("Open Street Map");
                    WWAnalysisToolView.insertTiledLayer(WWAnalysisToolView.this.getWwd(), streetLayer);
                    for (WWLayerDescriptor layerDescriptor : wwLayerDescriptors = WWLayerRegistry.getInstance().getWWLayerDescriptors()) {
                        if (!layerDescriptor.showIn3DToolView()) continue;
                        WWLayer wwLayer = layerDescriptor.createWWLayer();
                        WWAnalysisToolView.insertTiledLayer(WWAnalysisToolView.this.getWwd(), wwLayer);
                        wwLayer.setOpacity(0.8);
                        if (!(wwLayer instanceof DefaultProductLayer)) continue;
                        ((DefaultProductLayer)wwLayer).setEnableSurfaceImages(true);
                    }
                    SnapApp snapApp = SnapApp.getDefault();
                    snapApp.getProductManager().addListener((ProductManager.Listener)new WWProductManagerListener(toolView));
                    snapApp.getSelectionSupport(ProductNode.class).addHandler((SelectionSupport.Handler)new SelectionSupport.Handler<ProductNode>(){

                        public void selectionChange(@NullAllowed ProductNode oldValue, @NullAllowed ProductNode newValue) {
                            if (newValue != null) {
                                WWAnalysisToolView.this.setSelectedProduct(newValue.getProduct());
                            } else {
                                WWAnalysisToolView.this.setSelectedProduct(null);
                            }
                        }
                    });
                    WWAnalysisToolView.this.setProducts(snapApp.getProductManager().getProducts());
                    WWAnalysisToolView.this.setSelectedProduct(snapApp.getSelectedProduct(SnapApp.SelectionSourceHint.VIEW));
                    mainPane.add((Component)WWAnalysisToolView.this.wwjPanel, "Center");
                    LayerList layerList = WWAnalysisToolView.this.getWwd().getModel().getLayers();
                    Layer layer = layerList.getLayerByName("Products");
                    WWAnalysisToolView.this.productPanel = new ProductPanel(WWAnalysisToolView.this.wwjPanel.getWwd(), (DefaultProductLayer)layer);
                    mainPane.add((Component)WWAnalysisToolView.this.productPanel, "West");
                    WWAnalysisToolView.this.productPanel.add((Component)WWAnalysisToolView.this.makeControlPanel(), "South");
                    WWAnalysisToolView.this.productPanel.update(WWAnalysisToolView.this.getWwd());
                    WWAnalysisToolView.this.wwjPanel.getWwd().addSelectListener(new SelectListener(){

                        @Override
                        public void selected(SelectEvent event) {
                            LayerList layerList = WWAnalysisToolView.this.getWwd().getModel().getLayers();
                            for (Layer layer : layerList) {
                                if (!(layer instanceof WWLayer)) continue;
                                WWLayer wwLayer = (WWLayer)layer;
                                wwLayer.updateInfoAnnotation(event);
                            }
                        }
                    });
                }
                catch (Throwable e) {
                    SnapApp.getDefault().handleError("Unable to initialize WWAnalysisToolView: " + e.getMessage(), e);
                }
                return null;
            }
        };
        worker.execute();
    }

    private JPanel makeControlPanel() {
        JPanel controlPanel = new JPanel(new GridLayout(2, 1, 5, 5));
        controlPanel.setBorder(new EmptyBorder(15, 15, 15, 15));
        LayerList layerList = this.getWwd().getModel().getLayers();
        for (Layer layer : layerList) {
            if (!(layer instanceof WWLayer)) continue;
            WWLayer wwLayer = (WWLayer)layer;
            JPanel layerControlPanel = wwLayer.getControlPanel(this.getWwd());
            controlPanel.add(layerControlPanel);
        }
        return controlPanel;
    }

    @Override
    public void setSelectedProduct(Product product) {
        super.setSelectedProduct(product);
        if (this.productPanel != null) {
            this.productPanel.update(this.getWwd());
        }
    }

    @Override
    public void setProducts(Product[] products) {
        super.setProducts(products);
        if (this.productPanel != null) {
            this.productPanel.update(this.getWwd());
        }
    }

    @Override
    public void removeProduct(Product product) {
        super.removeProduct(product);
        if (this.productPanel != null) {
            this.productPanel.update(this.getWwd());
        }
    }

    private WMSLayersPanel addTab(int position, String server) {
        try {
            WMSLayersPanel layersPanel = new WMSLayersPanel((WorldWindow)this.wwjPanel.getWwd(), server, this.wmsPanelSize);
            this.tabbedPane.add((Component)layersPanel, "Center");
            String title = layersPanel.getServerDisplayString();
            this.tabbedPane.setTitleAt(position, title != null && title.length() > 0 ? title : server);
            layersPanel.addPropertyChangeListener("LayersPanelUpdated", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    WWAnalysisToolView.this.layerPanel.update(WWAnalysisToolView.this.wwjPanel.getWwd());
                }
            });
            return layersPanel;
        }
        catch (URISyntaxException e) {
            JOptionPane.showMessageDialog(null, "Server URL is invalid", "Invalid Server URL", 0);
            this.tabbedPane.setSelectedIndex(this.previousTabIndex);
            return null;
        }
    }
}

