/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.csv.dataio.writer;

import java.io.IOException;
import java.util.List;
import org.esa.snap.csv.dataio.writer.CsvWriter;
import org.esa.snap.csv.dataio.writer.OutputFormatStrategy;
import org.esa.snap.csv.dataio.writer.WriteStrategy;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

class FeatureCsvWriter
implements CsvWriter {
    private WriteStrategy writer;
    private OutputFormatStrategy targetFormat;
    private SimpleFeatureType featureType;
    private FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection;

    FeatureCsvWriter(WriteStrategy writer, OutputFormatStrategy targetFormat) {
        this.writer = writer;
        this.targetFormat = targetFormat;
    }

    @Override
    public void writeCsv(Object ... input) throws IOException {
        this.validate(input);
        this.extract(input);
        StringBuilder csv = new StringBuilder();
        List attributeDescriptors = this.featureType.getAttributeDescriptors();
        String[] attributes = new String[attributeDescriptors.size()];
        Class[] types = new Class[attributeDescriptors.size()];
        for (int i = 0; i < attributeDescriptors.size(); ++i) {
            AttributeDescriptor attributeDescriptor = (AttributeDescriptor)attributeDescriptors.get(i);
            attributes[i] = attributeDescriptor.getName().toString();
            types[i] = attributeDescriptor.getType().getBinding();
        }
        String header = this.targetFormat.formatHeader(attributes, types);
        csv.append(header);
        SimpleFeature[] simpleFeatureArray = this.toSimpleFeatureArray(this.featureCollection);
        for (int recordNo = 0; recordNo < simpleFeatureArray.length; ++recordNo) {
            SimpleFeature feature = simpleFeatureArray[recordNo];
            String[] values = new String[feature.getAttributeCount()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = feature.getAttribute(i).toString();
            }
            csv.append("\n");
            csv.append(this.targetFormat.formatRecord(recordNo + "", values));
        }
        csv.append("\n");
        this.writer.writeCsv(csv.toString());
    }

    @Override
    public boolean isValidInput(Object ... input) {
        if (input == null) {
            return false;
        }
        if (input.length == 2 && input[0] instanceof SimpleFeatureType && input[1] instanceof FeatureCollection) {
            return true;
        }
        if (input.length >= 2 && input[0] instanceof SimpleFeatureType) {
            for (int i = 1; i < input.length; ++i) {
                if (input[i] instanceof SimpleFeature) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void validate(Object ... input) {
        if (!this.isValidInput(input)) {
            StringBuilder message = new StringBuilder("Illegal input for writing pixels as CSV file: '");
            for (int i = 0; i < input.length; ++i) {
                Object o = input[i];
                message.append(o.toString());
                if (i != input.length - 1) continue;
                message.append(", ");
            }
            message.append("'");
            throw new IllegalArgumentException(message.toString());
        }
    }

    private void extract(Object[] input) {
        if (input.length == 2 && input[0] instanceof SimpleFeatureType && input[1] instanceof FeatureCollection) {
            this.featureType = (SimpleFeatureType)input[0];
            this.featureCollection = (FeatureCollection)input[1];
        } else if (input.length >= 2 && input[0] instanceof SimpleFeatureType) {
            this.featureType = (SimpleFeatureType)input[0];
            this.featureCollection = new ListFeatureCollection(this.featureType);
            for (int i = 1; i < input.length; ++i) {
                this.featureCollection.add((Feature)((SimpleFeature)input[i]));
            }
        }
    }

    private SimpleFeature[] toSimpleFeatureArray(FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection) {
        Object[] objects = featureCollection.toArray(new Object[featureCollection.size()]);
        SimpleFeature[] simpleFeatures = new SimpleFeature[objects.length];
        for (int i = 0; i < simpleFeatures.length; ++i) {
            simpleFeatures[i] = (SimpleFeature)objects[i];
        }
        return simpleFeatures;
    }
}

