/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.csv.dataio.writer;

import java.io.File;
import java.io.Writer;
import java.util.Locale;
import org.esa.snap.core.dataio.EncodeQualification;
import org.esa.snap.core.dataio.ProductWriter;
import org.esa.snap.core.dataio.ProductWriterPlugIn;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.csv.dataio.writer.CsvProductWriter;

public class CsvProductWriterPlugIn
implements ProductWriterPlugIn {
    private Writer writer;
    private final int config;

    public CsvProductWriterPlugIn() {
        this(null, 3);
    }

    public CsvProductWriterPlugIn(Writer writer, int config) {
        this.writer = writer;
        this.config = config;
    }

    public EncodeQualification getEncodeQualification(Product product) {
        if (product.isMultiSize()) {
            return new EncodeQualification(EncodeQualification.Preservation.UNABLE, "Cannot write multisize products. Consider resampling the product first.");
        }
        return new EncodeQualification(EncodeQualification.Preservation.PARTIAL);
    }

    public Class[] getOutputTypes() {
        return new Class[]{String.class, File.class};
    }

    public ProductWriter createWriterInstance() {
        return new CsvProductWriter(this, this.config, this.writer);
    }

    public String[] getFormatNames() {
        return new String[]{"CSV"};
    }

    public String[] getDefaultFileExtensions() {
        return new String[]{".csv"};
    }

    public String getDescription(Locale locale) {
        return "CSV products";
    }

    public SnapFileFilter getProductFileFilter() {
        return new SnapFileFilter(this.getFormatNames()[0], this.getDefaultFileExtensions(), this.getDescription(null));
    }
}

