/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.raster.gpf.masks;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.dataop.dem.ElevationModel;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.dem.dataio.DEMFactory;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.TileGeoreferencing;
import org.esa.snap.engine_utilities.gpf.TileIndex;

@OperatorMetadata(alias="Land-Sea-Mask", category="Raster/Masks", authors="Jun Lu, Luis Veci", version="1.0", copyright="Copyright (C) 2015 by Array Systems Computing Inc.", description="Creates a bitmask defining land vs ocean.")
public class CreateLandMaskOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct = null;
    @Parameter(description="The list of source bands.", alias="sourceBands", rasterDataNodeType=Band.class, label="Source Bands")
    private String[] sourceBandNames = null;
    @Parameter(label="Mask the Land", defaultValue="true")
    private Boolean landMask = true;
    @Parameter(label="Use SRTM 3sec", defaultValue="true")
    private Boolean useSRTM = true;
    @Parameter(label="Vector", defaultValue="")
    private String geometry = "";
    @Parameter(label="Invert Vector", defaultValue="false")
    private Boolean invertGeometry = false;
    @Parameter(label="Bypass", defaultValue="false")
    private Boolean byPass = false;
    private ElevationModel dem = null;
    private static final int landThreshold = -10;
    private static final int seaThreshold = -10;
    private static final String tmpVirtBandName = "_tmpVirtBand";

    public void initialize() throws OperatorException {
        try {
            this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
            ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
            this.addSelectedBands();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void addSelectedBands() throws OperatorException {
        Band[] sourceBands;
        for (Band srcBand : sourceBands = OperatorUtils.getSourceBands((Product)this.sourceProduct, (String[])this.sourceBandNames, (boolean)false)) {
            if (this.geometry != null && !this.geometry.isEmpty() && !this.byPass.booleanValue()) {
                String expression = this.geometry + " ? " + srcBand.getName() + " : " + srcBand.getNoDataValue();
                if (this.invertGeometry.booleanValue()) {
                    expression = "!" + expression;
                }
                VirtualBand virtBand = new VirtualBand(srcBand.getName() + tmpVirtBandName, srcBand.getDataType(), srcBand.getRasterWidth(), srcBand.getRasterHeight(), expression);
                virtBand.setUnit(srcBand.getUnit());
                virtBand.setDescription(srcBand.getDescription());
                this.sourceProduct.addBand((Band)virtBand);
                Band targetBand = ProductUtils.copyBand((String)virtBand.getName(), (Product)this.sourceProduct, (Product)this.targetProduct, (boolean)false);
                targetBand.setName(srcBand.getName());
                targetBand.setSourceImage(virtBand.getSourceImage());
                continue;
            }
            Band targetBand = ProductUtils.copyBand((String)srcBand.getName(), (Product)this.sourceProduct, (Product)this.targetProduct, (boolean)false);
            if (!this.byPass.booleanValue()) continue;
            targetBand.setSourceImage(srcBand.getSourceImage());
        }
    }

    public void dispose() {
        if (this.geometry != null && !this.geometry.isEmpty() && !this.byPass.booleanValue()) {
            Band[] sourceBands;
            for (Band srcBand : sourceBands = this.sourceProduct.getBands()) {
                if (!srcBand.getName().contains(tmpVirtBandName)) continue;
                this.sourceProduct.removeBand(srcBand);
            }
        }
    }

    public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        try {
            if (this.dem == null) {
                this.createDEM();
            }
            TileData[] trgTiles = this.getTargetTiles(targetTiles, targetRectangle, this.sourceProduct);
            int minX = targetRectangle.x;
            int minY = targetRectangle.y;
            int maxX = targetRectangle.x + targetRectangle.width;
            int maxY = targetRectangle.y + targetRectangle.height;
            TileIndex srcTileIndex = new TileIndex(trgTiles[0].srcTile);
            TileIndex trgTileIndex = new TileIndex(trgTiles[0].targetTile);
            TileGeoreferencing tileGeoRef = new TileGeoreferencing(this.targetProduct, minX, minY, maxX - minX, maxY - minY);
            float demNoDataValue = this.dem.getDescriptor().getNoDataValue();
            double[][] localDEM = new double[maxY - minY + 2][maxX - minX + 2];
            DEMFactory.getLocalDEM((ElevationModel)this.dem, (double)demNoDataValue, null, (TileGeoreferencing)tileGeoRef, (int)minX, (int)minY, (int)(maxX - minX), (int)(maxY - minY), null, (boolean)true, (double[][])localDEM);
            for (int y = minY; y < maxY; ++y) {
                srcTileIndex.calculateStride(y);
                trgTileIndex.calculateStride(y);
                int yy = y - minY;
                for (int x = minX; x < maxX; ++x) {
                    boolean valid;
                    int trgIndex = trgTileIndex.getIndex(x);
                    double elev = localDEM[yy][x - minX];
                    if (this.landMask.booleanValue()) {
                        valid = this.useSRTM.booleanValue() ? elev == (double)demNoDataValue : elev < -10.0;
                    } else if (this.useSRTM.booleanValue()) {
                        valid = elev != (double)demNoDataValue;
                    } else {
                        boolean bl = valid = elev > -10.0;
                    }
                    if (valid) {
                        int srcIndex = srcTileIndex.getIndex(x);
                        TileData[] tileDataArray = trgTiles;
                        int n = tileDataArray.length;
                        for (int i = 0; i < n; ++i) {
                            TileData tileData = tileDataArray[i];
                            tileData.tileDataBuffer.setElemDoubleAt(trgIndex, tileData.srcDataBuffer.getElemDoubleAt(srcIndex));
                        }
                        continue;
                    }
                    for (TileData tileData : trgTiles) {
                        tileData.tileDataBuffer.setElemDoubleAt(trgIndex, tileData.noDataValue);
                    }
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private synchronized void createDEM() throws IOException {
        if (this.dem != null) {
            return;
        }
        this.dem = this.useSRTM != false ? DEMFactory.createElevationModel((String)"SRTM 3Sec", (String)"NEAREST_NEIGHBOUR") : DEMFactory.createElevationModel((String)"ACE2_5Min", (String)"NEAREST_NEIGHBOUR");
    }

    private TileData[] getTargetTiles(Map<Band, Tile> targetTiles, Rectangle targetRectangle, Product srcProduct) {
        ArrayList<TileData> trgTileList = new ArrayList<TileData>();
        Set<Band> keySet = targetTiles.keySet();
        for (Band targetBand : keySet) {
            TileData td = new TileData();
            td.targetTile = targetTiles.get(targetBand);
            td.srcTile = this.getSourceTile((RasterDataNode)srcProduct.getBand(targetBand.getName()), targetRectangle);
            td.tileDataBuffer = td.targetTile.getDataBuffer();
            td.srcDataBuffer = td.srcTile.getDataBuffer();
            td.noDataValue = targetBand.getNoDataValue();
            trgTileList.add(td);
        }
        return trgTileList.toArray(new TileData[trgTileList.size()]);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(CreateLandMaskOp.class);
        }
    }

    private static class TileData {
        Tile targetTile = null;
        Tile srcTile = null;
        ProductData tileDataBuffer = null;
        ProductData srcDataBuffer = null;
        double noDataValue = 0.0;

        private TileData() {
        }
    }
}

