/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.raster.gpf;

import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProducts;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;

@OperatorMetadata(alias="ReplaceMetadata", category="Tools", authors="Jun Lu, Luis Veci", version="1.0", copyright="Copyright (C) 2015 by Array Systems Computing Inc.", description="Replace the metadata of the first product with that of the second")
public class ReplaceMetadataOp
extends Operator {
    @SourceProducts
    private Product[] sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(defaultValue="Replace the metadata of the first product with that of the second", label=" ")
    String note;

    public void initialize() throws OperatorException {
        try {
            Band[] bands;
            if (this.sourceProduct.length != 2) {
                throw new OperatorException("ReplaceMetadataOp requires two source products.");
            }
            Product masterProduct = this.sourceProduct[0];
            Product slaveProduct = this.sourceProduct[1];
            this.targetProduct = new Product(masterProduct.getName(), slaveProduct.getProductType(), masterProduct.getSceneRasterWidth(), masterProduct.getSceneRasterHeight());
            for (Band srcBand : bands = masterProduct.getBands()) {
                Band targetBand = ProductUtils.copyBand((String)srcBand.getName(), (Product)masterProduct, (Product)this.targetProduct, (boolean)false);
                targetBand.setSourceImage(srcBand.getSourceImage());
            }
            ProductUtils.copyProductNodes((Product)slaveProduct, (Product)this.targetProduct);
            MetadataElement absRootMst = AbstractMetadata.getAbstractedMetadata((Product)masterProduct);
            int isPolsar = absRootMst.getAttributeInt("polsar_data", 0);
            int isCalibrated = absRootMst.getAttributeInt("abs_calibration_flag", 0);
            ReplaceMetadataOp.resetPolarizations(AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct), isPolsar, isCalibrated);
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    public static void resetPolarizations(MetadataElement absRoot, int isPolsar, int isCal) {
        if (isPolsar > 0) {
            absRoot.setAttributeString("mds1_tx_rx_polar", "-");
            absRoot.setAttributeString("mds2_tx_rx_polar", "-");
            absRoot.setAttributeString("mds3_tx_rx_polar", "-");
            absRoot.setAttributeString("mds4_tx_rx_polar", "-");
            absRoot.setAttributeInt("polsar_data", 1);
        }
        if (isCal > 0) {
            absRoot.setAttributeInt("abs_calibration_flag", 1);
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(ReplaceMetadataOp.class);
        }
    }
}

