/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.raster.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.ConvolutionFilterBand;
import org.esa.snap.core.datamodel.FilterBand;
import org.esa.snap.core.datamodel.GeneralFilterBand;
import org.esa.snap.core.datamodel.Kernel;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;

@OperatorMetadata(alias="Image-Filter", category="Raster", authors="Norman Fomferra, Luis Veci", version="1.0", copyright="Copyright (C) 2015 by Array Systems Computing Inc.", description="Common Image Processing Filters")
public class FilterOperator
extends Operator {
    @SourceProduct
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="The list of source bands.", alias="sourceBands", rasterDataNodeType=Band.class, label="Source Bands")
    private String[] sourceBandNames;
    @Parameter
    private String selectedFilterName = null;
    @Parameter(description="The kernel file", label="Kernel File")
    private File userDefinedKernelFile = null;
    private transient Map<Band, Band> bandMap = new HashMap<Band, Band>(5);
    private final transient Map<String, Filter> filterMap = new HashMap<String, Filter>(5);
    private static final String PRODUCT_SUFFIX = "_Flt";
    public static final Filter[] LINE_DETECTION_FILTERS = new Filter[]{new KernelFilter("Horizontal Edges", new Kernel(3, 3, new double[]{-1.0, -1.0, -1.0, 2.0, 2.0, 2.0, -1.0, -1.0, -1.0})), new KernelFilter("Vertical Edges", new Kernel(3, 3, new double[]{-1.0, 2.0, -1.0, -1.0, 2.0, -1.0, -1.0, 2.0, -1.0})), new KernelFilter("Left Diagonal Edges", new Kernel(3, 3, new double[]{2.0, -1.0, -1.0, -1.0, 2.0, -1.0, -1.0, -1.0, 2.0})), new KernelFilter("Right Diagonal Edges", new Kernel(3, 3, new double[]{-1.0, -1.0, 2.0, -1.0, 2.0, -1.0, 2.0, -1.0, -1.0})), new KernelFilter("Compass Edge Detector", new Kernel(3, 3, new double[]{-1.0, 1.0, 1.0, -1.0, -2.0, 1.0, -1.0, 1.0, 1.0})), new KernelFilter("Diagonal Compass Edge Detector", new Kernel(3, 3, new double[]{1.0, 1.0, 1.0, -1.0, -2.0, 1.0, -1.0, -1.0, 1.0})), new KernelFilter("Roberts Cross North-West", new Kernel(2, 2, new double[]{1.0, 0.0, 0.0, -1.0})), new KernelFilter("Roberts Cross North-East", new Kernel(2, 2, new double[]{0.0, 1.0, -1.0, 0.0}))};
    public static final Filter[] GRADIENT_DETECTION_FILTERS = new Filter[]{new KernelFilter("Sobel North", new Kernel(3, 3, new double[]{-1.0, -2.0, -1.0, 0.0, 0.0, 0.0, 1.0, 2.0, 1.0})), new KernelFilter("Sobel South", new Kernel(3, 3, new double[]{1.0, 2.0, 1.0, 0.0, 0.0, 0.0, -1.0, -2.0, -1.0})), new KernelFilter("Sobel West", new Kernel(3, 3, new double[]{-1.0, 0.0, 1.0, -2.0, 0.0, 2.0, -1.0, 0.0, 1.0})), new KernelFilter("Sobel East", new Kernel(3, 3, new double[]{1.0, 0.0, -1.0, 2.0, 0.0, -2.0, 1.0, 0.0, -1.0})), new KernelFilter("Sobel North East", new Kernel(3, 3, new double[]{0.0, -1.0, -2.0, 1.0, 0.0, -1.0, 2.0, 1.0, 0.0}))};
    public static final Filter[] SMOOTHING_FILTERS = new Filter[]{new KernelFilter("Arithmetic 3x3 Mean", new Kernel(3, 3, 0.1111111111111111, new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0})), new KernelFilter("Arithmetic 4x4 Mean", new Kernel(4, 4, 0.0625, new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0})), new KernelFilter("Arithmetic 5x5 Mean", new Kernel(5, 5, 0.04, new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0})), new KernelFilter("Low-Pass 3x3", new Kernel(3, 3, 0.0625, new double[]{1.0, 2.0, 1.0, 2.0, 4.0, 2.0, 1.0, 2.0, 1.0})), new KernelFilter("Low-Pass 5x5", new Kernel(5, 5, 0.016666666666666666, new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 4.0, 4.0, 4.0, 1.0, 1.0, 4.0, 12.0, 4.0, 1.0, 1.0, 4.0, 4.0, 4.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}))};
    public static final Filter[] SHARPENING_FILTERS = new Filter[]{new KernelFilter("High-Pass 3x3 #1", new Kernel(3, 3, new double[]{-1.0, -1.0, -1.0, -1.0, 9.0, -1.0, -1.0, -1.0, -1.0})), new KernelFilter("High-Pass 3x3 #2", new Kernel(3, 3, new double[]{0.0, -1.0, 0.0, -1.0, 5.0, -1.0, 0.0, -1.0, 0.0})), new KernelFilter("High-Pass 5x5", new Kernel(5, 5, new double[]{0.0, -1.0, -1.0, -1.0, 0.0, -1.0, 2.0, -4.0, 2.0, -1.0, -1.0, -4.0, 13.0, -4.0, -1.0, -1.0, 2.0, -4.0, 2.0, -1.0, 0.0, -1.0, -1.0, -1.0, 0.0}))};
    public static final Filter[] LAPLACIAN_FILTERS = new Filter[]{new KernelFilter("Laplace 3x3", new Kernel(3, 3, new double[]{0.0, -1.0, 0.0, -1.0, 4.0, -1.0, 0.0, -1.0, 0.0})), new KernelFilter("Laplace 5x5", new Kernel(5, 5, new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 24.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}))};
    public static final Filter[] NON_LINEAR_FILTERS = new Filter[]{new GeneralFilter("Minimum 3x3", 3, 3, GeneralFilterBand.OpType.MIN), new GeneralFilter("Minimum 5x5", 5, 5, GeneralFilterBand.OpType.MIN), new GeneralFilter("Maximum 3x3", 3, 3, GeneralFilterBand.OpType.MAX), new GeneralFilter("Maximum 5x5", 5, 5, GeneralFilterBand.OpType.MAX), new GeneralFilter("Mean 3x3", 3, 3, GeneralFilterBand.OpType.MEAN), new GeneralFilter("Mean 5x5", 5, 5, GeneralFilterBand.OpType.MEAN), new GeneralFilter("Median 3x3", 3, 3, GeneralFilterBand.OpType.MEDIAN), new GeneralFilter("Median 5x5", 5, 5, GeneralFilterBand.OpType.MEDIAN)};

    public FilterOperator() {
        this.populateFilterMap(LINE_DETECTION_FILTERS);
        this.populateFilterMap(GRADIENT_DETECTION_FILTERS);
        this.populateFilterMap(SMOOTHING_FILTERS);
        this.populateFilterMap(SHARPENING_FILTERS);
        this.populateFilterMap(LAPLACIAN_FILTERS);
    }

    private void populateFilterMap(Filter[] filters) {
        for (Filter f : filters) {
            this.filterMap.put(f.toString(), f);
        }
    }

    public void initialize() throws OperatorException {
        this.ensureSingleRasterSize(new Product[]{this.sourceProduct});
        try {
            Band[] sourceBands;
            this.targetProduct = new Product(this.sourceProduct.getName() + PRODUCT_SUFFIX, this.sourceProduct.getProductType(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
            Filter selectedFilter = null;
            if (this.userDefinedKernelFile != null) {
                selectedFilter = FilterOperator.getUserDefinedFilter(this.userDefinedKernelFile);
            } else if (this.selectedFilterName != null) {
                selectedFilter = this.filterMap.get(this.selectedFilterName);
            }
            if (selectedFilter == null) {
                return;
            }
            for (Band srcBand : sourceBands = OperatorUtils.getSourceBands((Product)this.sourceProduct, (String[])this.sourceBandNames, (boolean)true)) {
                Band targetBand = new Band(srcBand.getName(), 30, this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
                targetBand.setUnit(srcBand.getUnit());
                this.targetProduct.addBand(targetBand);
                String filterBandName = "tmp_filter_" + srcBand.getName();
                FilterBand filterBand = FilterOperator.createFilterBand(selectedFilter, filterBandName, (RasterDataNode)srcBand);
                this.bandMap.put(targetBand, (Band)filterBand);
                Band existingBand = this.sourceProduct.getBand(filterBandName);
                if (existingBand != null) {
                    this.sourceProduct.removeBand(existingBand);
                }
                this.sourceProduct.addBand((Band)filterBand);
            }
            ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
            this.targetProduct.setPreferredTileSize(this.sourceProduct.getSceneRasterWidth(), 512);
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        Rectangle targetTileRectangle = targetTile.getRectangle();
        Tile sourceRaster = this.getSourceTile((RasterDataNode)this.bandMap.get(targetBand), targetTileRectangle);
        ProductData masterData = sourceRaster.getDataBuffer();
        ProductData targetData = targetTile.getDataBuffer();
        for (int y = targetTileRectangle.y; y < targetTileRectangle.y + targetTileRectangle.height; ++y) {
            for (int x = targetTileRectangle.x; x < targetTileRectangle.x + targetTileRectangle.width; ++x) {
                int index = sourceRaster.getDataBufferIndex(x, y);
                targetData.setElemFloatAt(index, masterData.getElemFloatAt(index));
            }
        }
    }

    private static FilterBand createFilterBand(Filter filter, String bandName, RasterDataNode raster) throws Exception {
        if (!(filter instanceof KernelFilter)) {
            throw new Exception("unhandled filter type");
        }
        KernelFilter kernelFilter = (KernelFilter)filter;
        ConvolutionFilterBand filterBand = new ConvolutionFilterBand(bandName, raster, kernelFilter.kernel, 1);
        String descr = MessageFormat.format("Filter ''{0}''", filter.toString());
        filterBand.setDescription(descr);
        return filterBand;
    }

    private static KernelFilter getUserDefinedFilter(File userDefinedKernelFile) throws IOException {
        FileInputStream fis = new FileInputStream(userDefinedKernelFile);
        float[][] kernelData = FilterOperator.readFile(fis, userDefinedKernelFile.getName());
        int filterWidth = kernelData.length;
        int filterHeight = kernelData[0].length;
        double[] data = new double[filterWidth * filterHeight];
        int k = 0;
        for (int r = 0; r < filterHeight; ++r) {
            for (int c = 0; c < filterWidth; ++c) {
                data[k++] = kernelData[r][c];
            }
        }
        return new KernelFilter("User Defined Filter", new Kernel(filterWidth, filterHeight, data));
    }

    public static float[][] readFile(InputStream stream, String fileName) {
        float[][] array;
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        String line = "";
        int rowIdx = 0;
        try {
            line = reader.readLine();
            if (line == null) {
                throw new OperatorException("Empty file: " + fileName);
            }
            StringTokenizer st = new StringTokenizer(line);
            if (st.countTokens() != 2) {
                throw new OperatorException("Incorrect file format: " + fileName);
            }
            int numRows = Integer.parseInt(st.nextToken());
            int numCols = Integer.parseInt(st.nextToken());
            array = new float[numRows][numCols];
            while ((line = reader.readLine()) != null) {
                st = new StringTokenizer(line);
                if (st.countTokens() != numCols) {
                    throw new OperatorException("Incorrect file format: " + fileName);
                }
                for (int j = 0; j < numCols; ++j) {
                    array[rowIdx][j] = Float.parseFloat(st.nextToken());
                }
                ++rowIdx;
            }
            if (numRows != rowIdx) {
                throw new OperatorException("Incorrect number of lines in file: " + fileName);
            }
            reader.close();
            stream.close();
        }
        catch (IOException e) {
            throw new OperatorException((Throwable)e);
        }
        return array;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(FilterOperator.class);
        }
    }

    private static class GeneralFilter
    extends Filter {
        final int width;
        final int height;
        final GeneralFilterBand.OpType operator;

        public GeneralFilter(String name, int width, int height, GeneralFilterBand.OpType operator) {
            super(name);
            this.width = width;
            this.height = height;
            this.operator = operator;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof GeneralFilter) {
                GeneralFilter other = (GeneralFilter)obj;
                return this.toString().equals(other.toString()) && this.operator == other.operator;
            }
            return false;
        }
    }

    private static class KernelFilter
    extends Filter {
        private final Kernel kernel;

        public KernelFilter(String name, Kernel kernel) {
            super(name);
            this.kernel = kernel;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof KernelFilter) {
                KernelFilter other = (KernelFilter)obj;
                return this.toString().equals(other.toString()) && this.kernel.equals(other.kernel);
            }
            return false;
        }
    }

    public static abstract class Filter {
        private final String name;

        public Filter(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public abstract boolean equals(Object var1);
    }
}

