/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.util;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import java.util.Map;

public class TemplateReader
extends FilterReader {
    private static final char DEFAULT_KEY_INDICATOR = '$';
    private static final int EOF = -1;
    private Resolver resolver;
    private IntBuffer buffer;
    private char keyIndicator = (char)36;

    public TemplateReader(Reader in, Map map) {
        this(in, new KeyValueResolver(map));
    }

    public TemplateReader(Reader in, Resolver resolver) {
        super(in);
        if (resolver == null) {
            throw new NullPointerException("resolver");
        }
        this.resolver = resolver;
    }

    public char getKeyIndicator() {
        return this.keyIndicator;
    }

    public void setKeyIndicator(char keyIndicator) {
        if (Character.isWhitespace(keyIndicator) || Character.isLetterOrDigit(keyIndicator)) {
            throw new IllegalArgumentException();
        }
        this.keyIndicator = keyIndicator;
    }

    public String readAll() throws IOException {
        int i;
        StringBuilder sb = new StringBuilder(16384);
        while ((i = this.read()) != -1) {
            sb.append((char)i);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buffer != null && this.buffer.ready()) {
                return this.buffer.next();
            }
            int c = this.in.read();
            if (c != this.keyIndicator) {
                return c;
            }
            if (this.buffer == null) {
                this.buffer = new IntBuffer();
            }
            this.buffer.reset();
            this.buffer.append(this.keyIndicator);
            c = this.readAndBuffer();
            if (c != -1) {
                String key;
                Object value;
                int keyType = 0;
                if (c == 123) {
                    do {
                        if ((c = this.readAndBuffer()) != 125) continue;
                        keyType = 1;
                        break;
                    } while (c != -1);
                } else if (Character.isJavaIdentifierStart(c)) {
                    keyType = 2;
                    while ((Character.isJavaIdentifierPart(c = this.readAndBuffer()) || c == 46) && c != -1) {
                    }
                }
                if (keyType != 0 && (value = this.resolver.resolve(key = keyType == 1 ? this.buffer.substring(2, this.buffer.length() - 1) : this.buffer.substring(1, this.buffer.length() - 1))) != null) {
                    int last;
                    String s = value.toString();
                    if (keyType == 1) {
                        last = this.in.read();
                        this.buffer.reset();
                        this.buffer.append(s);
                    } else {
                        last = this.buffer.charAt(this.buffer.length() - 1);
                        this.buffer.reset();
                        this.buffer.append(s);
                    }
                    this.buffer.append(last);
                }
            }
            return this.buffer.next();
        }
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int i;
            for (i = 0; i < len; ++i) {
                int c = this.read();
                if (c == -1) {
                    return i == 0 ? -1 : i;
                }
                cbuf[off + i] = (char)c;
            }
            return i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(CharBuffer target) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int len = target.remaining();
            char[] cbuf = new char[len];
            int n = this.read(cbuf, 0, len);
            if (n > 0) {
                target.put(cbuf, 0, n);
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int c;
            long i;
            if (n < 0L) {
                throw new IllegalArgumentException("skip value is negative");
            }
            for (i = 0L; i < n && (c = this.read()) != -1; ++i) {
            }
            return i;
        }
    }

    @Override
    public boolean ready() throws IOException {
        return this.buffer != null && this.buffer.ready() || this.in.ready();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        throw new IOException("mark() not supported");
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("reset() not supported");
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.buffer = null;
    }

    private int readAndBuffer() throws IOException {
        int c = this.in.read();
        this.buffer.append(c);
        return c;
    }

    private static class IntBuffer {
        private static final int INC = 8192;
        private int[] buffer = new int[8192];
        private int length;
        private int index;

        public void reset() {
            this.length = 0;
            this.index = 0;
        }

        public int next() {
            if (!this.ready()) {
                throw new IllegalStateException("!ready()");
            }
            return this.buffer[this.index++];
        }

        public int charAt(int pos) {
            if (pos < 0) {
                throw new IndexOutOfBoundsException("pos < 0");
            }
            if (pos >= this.length) {
                throw new IndexOutOfBoundsException("pos >= length");
            }
            return this.buffer[pos];
        }

        public void append(int c) {
            if (this.length >= this.buffer.length) {
                int[] newBuffer = new int[this.buffer.length + 8192];
                System.arraycopy(this.buffer, 0, newBuffer, 0, this.length);
                this.buffer = newBuffer;
            }
            this.buffer[this.length++] = c;
        }

        public void append(String s) {
            for (int i = 0; i < s.length(); ++i) {
                this.append(s.charAt(i));
            }
        }

        public boolean ready() {
            return this.index < this.length;
        }

        public String substring(int start, int end) {
            int n = end - start;
            char[] cbuf = new char[n];
            for (int i = start; i < end; ++i) {
                cbuf[i - start] = (char)this.buffer[i];
            }
            return new String(cbuf);
        }

        public int length() {
            return this.length;
        }
    }

    private static class KeyValueResolver
    implements Resolver {
        private Map map;

        public KeyValueResolver(Map map) {
            if (map == null) {
                throw new NullPointerException("map");
            }
            this.map = map;
        }

        @Override
        public Object resolve(String reference) {
            return this.map.get(reference);
        }
    }

    public static interface Resolver {
        public Object resolve(String var1);
    }
}

