/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.idepix.meris;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.InputStream;
import org.esa.s3tbx.meris.l2auxdata.L2AuxData;
import org.esa.s3tbx.meris.l2auxdata.L2AuxDataException;
import org.esa.s3tbx.meris.l2auxdata.L2AuxDataProvider;
import org.esa.s3tbx.processor.rad2refl.Rad2ReflConstants;
import org.esa.s3tbx.util.math.FractIndex;
import org.esa.s3tbx.util.math.Interp;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.RectangleExtender;
import org.esa.snap.dataio.envisat.EnvisatConstants;
import org.esa.snap.idepix.core.seaice.SeaIceClassification;
import org.esa.snap.idepix.core.seaice.SeaIceClassifier;
import org.esa.snap.idepix.core.util.IdepixIO;
import org.esa.snap.idepix.core.util.IdepixUtils;
import org.esa.snap.idepix.core.util.SchillerNeuralNetWrapper;
import org.esa.snap.idepix.meris.IdepixMerisUtils;

@OperatorMetadata(alias="Idepix.Meris.Water", version="3.0", internal=true, authors="Olaf Danne", copyright="(c) 2016 by Brockmann Consult", description="IdePix water pixel classification operator for OLCI.")
public class IdepixMerisWaterClassificationOp
extends Operator {
    private Band cloudFlagBand;
    private SeaIceClassifier seaIceClassifier;
    private Band landWaterBand;
    private Band nnOutputBand;
    @SourceProduct(alias="l1b")
    private Product l1bProduct;
    @SourceProduct(alias="rhotoa")
    private Product rhoToaProduct;
    @SourceProduct(alias="waterMask")
    private Product waterMaskProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(label=" Sea Ice Climatology Value", defaultValue="false")
    private boolean ccOutputSeaIceClimatologyValue;
    @Parameter(defaultValue="false", description="Check for sea/lake ice also outside Sea Ice Climatology area.", label="Check for sea/lake ice also outside Sea Ice Climatology area")
    private boolean ignoreSeaIceClimatology;
    @Parameter(label="Cloud screening 'ambiguous' threshold", defaultValue="1.4")
    private double cloudScreeningAmbiguous;
    @Parameter(label="Cloud screening 'sure' threshold", defaultValue="1.8")
    private double cloudScreeningSure;
    @Parameter(defaultValue="false", label=" Write NN value to the target product.", description=" If applied, write NN value to the target product ")
    private boolean outputSchillerNNValue;
    @Parameter(defaultValue="2.0", label=" NN cloud ambiguous lower boundary ", description=" NN cloud ambiguous lower boundary ")
    double schillerNNCloudAmbiguousLowerBoundaryValue;
    @Parameter(defaultValue="3.7", label=" NN cloud ambiguous/sure separation value ", description=" NN cloud ambiguous cloud ambiguous/sure separation value ")
    double schillerNNCloudAmbiguousSureSeparationValue;
    @Parameter(defaultValue="4.05", label=" NN cloud sure/snow separation value ", description=" NN cloud ambiguous cloud sure/snow separation value ")
    double schillerNNCloudSureSnowSeparationValue;
    public static final String MERIS_WATER_NET_NAME = "11x8x5x3_876.8_water.net";
    public static final String MERIS_ALL_NET_NAME = "11x8x5x3_1409.7_all.net";
    ThreadLocal<SchillerNeuralNetWrapper> merisWaterNeuralNet;
    ThreadLocal<SchillerNeuralNetWrapper> merisAllNeuralNet;
    private L2AuxData auxData;
    private static final double SEA_ICE_CLIM_THRESHOLD = 10.0;
    private RectangleExtender rectExtender;

    public void initialize() throws OperatorException {
        try {
            this.auxData = L2AuxDataProvider.getInstance().getAuxdata(this.l1bProduct);
        }
        catch (L2AuxDataException e) {
            throw new OperatorException("Could not load L2Auxdata", (Throwable)e);
        }
        this.readSchillerNets();
        this.createTargetProduct();
        this.initSeaIceClassifier();
        this.landWaterBand = this.waterMaskProduct.getBand("land_water_fraction");
        this.rectExtender = new RectangleExtender(new Rectangle(this.l1bProduct.getSceneRasterWidth(), this.l1bProduct.getSceneRasterHeight()), 1, 1);
    }

    private void readSchillerNets() {
        try (InputStream isWater = ((Object)((Object)this)).getClass().getResourceAsStream(MERIS_WATER_NET_NAME);
             InputStream isAll = ((Object)((Object)this)).getClass().getResourceAsStream(MERIS_ALL_NET_NAME);){
            this.merisWaterNeuralNet = SchillerNeuralNetWrapper.create((InputStream)isWater);
            this.merisAllNeuralNet = SchillerNeuralNetWrapper.create((InputStream)isAll);
        }
        catch (IOException e) {
            throw new OperatorException("Cannot read Neural Nets: " + e.getMessage());
        }
    }

    private void initSeaIceClassifier() {
        ProductData.UTC startTime = this.getSourceProduct().getStartTime();
        int monthIndex = startTime.getAsCalendar().get(2);
        try {
            this.seaIceClassifier = new SeaIceClassifier(monthIndex + 1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void createTargetProduct() {
        this.targetProduct = IdepixIO.createCompatibleTargetProduct((Product)this.l1bProduct, (String)"MER", (String)"MER_L2", (boolean)true);
        this.cloudFlagBand = this.targetProduct.addBand("pixel_classif_flags", 11);
        FlagCoding flagCoding = IdepixMerisUtils.createMerisFlagCoding("pixel_classif_flags");
        this.cloudFlagBand.setSampleCoding((SampleCoding)flagCoding);
        this.targetProduct.getFlagCodingGroup().add((ProductNode)flagCoding);
        if (this.outputSchillerNNValue) {
            this.nnOutputBand = this.targetProduct.addBand("nn_value", 30);
        }
    }

    public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        Rectangle targetRectangle = targetTile.getRectangle();
        try {
            Rectangle sourceRectangle = this.rectExtender.extend(targetRectangle);
            Tile[] rhoToaTiles = new Tile[EnvisatConstants.MERIS_L1B_NUM_SPECTRAL_BANDS];
            for (int i = 0; i < EnvisatConstants.MERIS_L1B_NUM_SPECTRAL_BANDS; ++i) {
                int suffixStart = Rad2ReflConstants.MERIS_REFL_BAND_NAMES[i].indexOf("_");
                String reflBandname = Rad2ReflConstants.MERIS_REFL_BAND_NAMES[i].substring(0, suffixStart);
                Band rhoToaBand = this.rhoToaProduct.getBand(reflBandname + "_" + (i + 1));
                rhoToaTiles[i] = this.getSourceTile((RasterDataNode)rhoToaBand, sourceRectangle);
            }
            Tile l1FlagsTile = this.getSourceTile((RasterDataNode)this.l1bProduct.getBand("l1_flags"), sourceRectangle);
            Tile waterFractionTile = this.getSourceTile((RasterDataNode)this.landWaterBand, sourceRectangle);
            Tile szaTile = null;
            Tile vzaTile = null;
            Tile saaTile = null;
            Tile vaaTile = null;
            Tile windUTile = null;
            Tile windVTile = null;
            if (band == this.cloudFlagBand) {
                szaTile = this.getSourceTile((RasterDataNode)this.l1bProduct.getTiePointGrid("sun_zenith"), sourceRectangle);
                vzaTile = this.getSourceTile((RasterDataNode)this.l1bProduct.getTiePointGrid("view_zenith"), sourceRectangle);
                saaTile = this.getSourceTile((RasterDataNode)this.l1bProduct.getTiePointGrid("sun_azimuth"), sourceRectangle);
                vaaTile = this.getSourceTile((RasterDataNode)this.l1bProduct.getTiePointGrid("view_azimuth"), sourceRectangle);
                windUTile = this.getSourceTile((RasterDataNode)this.l1bProduct.getTiePointGrid("zonal_wind"), sourceRectangle);
                windVTile = this.getSourceTile((RasterDataNode)this.l1bProduct.getTiePointGrid("merid_wind"), sourceRectangle);
            }
            for (int y = targetRectangle.y; y < targetRectangle.y + targetRectangle.height; ++y) {
                this.checkForCancellation();
                for (int x = targetRectangle.x; x < targetRectangle.x + targetRectangle.width; ++x) {
                    if (!l1FlagsTile.getSampleBit(x, y, 7)) {
                        int waterFraction = waterFractionTile.getSampleInt(x, y);
                        if (this.isLandPixel(x, y, l1FlagsTile, waterFraction)) {
                            if (band == this.cloudFlagBand) {
                                targetTile.setSample(x, y, 4, true);
                                continue;
                            }
                            targetTile.setSample(x, y, Float.NaN);
                            continue;
                        }
                        if (band == this.cloudFlagBand) {
                            this.classifyCloud(x, y, rhoToaTiles, windUTile, windVTile, szaTile, vzaTile, saaTile, vaaTile, targetTile, waterFraction);
                        }
                        if (!this.outputSchillerNNValue || band != this.nnOutputBand) continue;
                        double[] nnOutput = this.getMerisNNOutput(x, y, rhoToaTiles);
                        targetTile.setSample(x, y, nnOutput[0]);
                        continue;
                    }
                    targetTile.setSample(x, y, 0, true);
                }
            }
        }
        catch (Exception e) {
            throw new OperatorException((Throwable)e);
        }
    }

    private boolean isLandPixel(int x, int y, Tile l1FlagsTile, int waterFraction) {
        if (this.getGeoPos((int)x, (int)y).lat > -58.0) {
            if (waterFraction <= 100) {
                return waterFraction == 0;
            }
            return l1FlagsTile.getSampleBit(x, y, 4);
        }
        return l1FlagsTile.getSampleBit(x, y, 4);
    }

    private boolean isCoastlinePixel(int x, int y, int waterFraction) {
        return this.getGeoPos((int)x, (int)y).lat > -58.0 && waterFraction <= 100 && waterFraction < 100 && waterFraction > 0;
    }

    private void classifyCloud(int x, int y, Tile[] rhoToaTiles, Tile winduTile, Tile windvTile, Tile szaTile, Tile vzaTile, Tile saaTile, Tile vaaTile, Tile targetTile, int waterFraction) {
        boolean isCoastline = this.isCoastlinePixel(x, y, waterFraction);
        targetTile.setSample(x, y, 9, isCoastline);
        boolean is_glint_risk = !isCoastline && this.isGlintRisk(x, y, rhoToaTiles, winduTile, windvTile, szaTile, vzaTile, saaTile, vaaTile);
        boolean checkForSeaIce = false;
        if (!isCoastline) {
            GeoPos geoPos = this.getGeoPos(x, y);
            checkForSeaIce = this.ignoreSeaIceClimatology || this.isPixelClassifiedAsSeaice(geoPos);
            is_glint_risk = is_glint_risk && !this.isPixelClassifiedAsSeaice(geoPos);
        }
        boolean isCloudSure = false;
        double[] nnOutput = this.getMerisNNOutput(x, y, rhoToaTiles);
        if (!targetTile.getSampleBit(x, y, 0)) {
            boolean isCloudAmbiguous;
            targetTile.setSample(x, y, 2, false);
            targetTile.setSample(x, y, 3, false);
            targetTile.setSample(x, y, 1, false);
            targetTile.setSample(x, y, 6, false);
            boolean bl = isCloudAmbiguous = nnOutput[0] > this.schillerNNCloudAmbiguousLowerBoundaryValue && nnOutput[0] <= this.schillerNNCloudAmbiguousSureSeparationValue;
            if (isCloudAmbiguous) {
                targetTile.setSample(x, y, 2, true);
                targetTile.setSample(x, y, 1, true);
            }
            boolean bl2 = isCloudSure = nnOutput[0] > this.schillerNNCloudAmbiguousSureSeparationValue;
            if (isCloudSure) {
                targetTile.setSample(x, y, 3, true);
                targetTile.setSample(x, y, 1, true);
            }
            boolean is_snow_ice = false;
            if (checkForSeaIce) {
                boolean bl3 = is_snow_ice = nnOutput[0] > this.schillerNNCloudSureSnowSeparationValue;
            }
            if (is_snow_ice) {
                targetTile.setSample(x, y, 6, true);
                targetTile.setSample(x, y, 3, false);
                targetTile.setSample(x, y, 1, false);
            }
        }
        targetTile.setSample(x, y, 12, is_glint_risk && !isCloudSure);
    }

    private double[] getMerisNNOutput(int x, int y, Tile[] rhoToaTiles) {
        return this.getMerisNNOutputImpl(x, y, rhoToaTiles, this.merisAllNeuralNet.get());
    }

    private double[] getMerisNNOutputImpl(int x, int y, Tile[] rhoToaTiles, SchillerNeuralNetWrapper nnWrapper) {
        double[] nnInput = nnWrapper.getInputVector();
        for (int i = 0; i < nnInput.length; ++i) {
            nnInput[i] = Math.sqrt(rhoToaTiles[i].getSampleFloat(x, y));
        }
        return nnWrapper.getNeuralNet().calc(nnInput);
    }

    private boolean isGlintRisk(int x, int y, Tile[] rhoToaTiles, Tile winduTile, Tile windvTile, Tile szaTile, Tile vzaTile, Tile saaTile, Tile vaaTile) {
        float rhoGlint = (float)this.computeRhoGlint(x, y, winduTile, windvTile, szaTile, vzaTile, saaTile, vaaTile);
        return (double)rhoGlint >= 0.2 * (double)rhoToaTiles[12].getSampleFloat(x, y);
    }

    private double computeChiW(int x, int y, Tile winduTile, Tile windvTile, Tile saaTile) {
        double phiw = this.azimuth(winduTile.getSampleFloat(x, y), windvTile.getSampleFloat(x, y));
        double arg = Math.PI / 180 * ((double)saaTile.getSampleFloat(x, y) - phiw);
        return 57.29577951308232 * Math.acos(Math.cos(arg));
    }

    private double computeRhoGlint(int x, int y, Tile winduTile, Tile windvTile, Tile szaTile, Tile vzaTile, Tile saaTile, Tile vaaTile) {
        double chiw = this.computeChiW(x, y, winduTile, windvTile, saaTile);
        float vaa = vaaTile.getSampleFloat(x, y);
        float saa = saaTile.getSampleFloat(x, y);
        double deltaAzimuth = (float)IdepixUtils.computeAzimuthDifference((double)vaa, (double)saa);
        float windU = winduTile.getSampleFloat(x, y);
        float windV = windvTile.getSampleFloat(x, y);
        double windm = Math.sqrt(windU * windU + windV * windV);
        return this.glintRef(szaTile.getSampleFloat(x, y), vzaTile.getSampleFloat(x, y), deltaAzimuth, windm, chiw);
    }

    private double glintRef(double thetas, double thetav, double delta, double windm, double chiw) {
        FractIndex[] rogIndex = FractIndex.createArray((int)5);
        Interp.interpCoord((double)chiw, (double[])this.auxData.rog.getTab(0), (FractIndex)rogIndex[0]);
        Interp.interpCoord((double)thetav, (double[])this.auxData.rog.getTab(1), (FractIndex)rogIndex[1]);
        Interp.interpCoord((double)delta, (double[])this.auxData.rog.getTab(2), (FractIndex)rogIndex[2]);
        Interp.interpCoord((double)windm, (double[])this.auxData.rog.getTab(3), (FractIndex)rogIndex[3]);
        Interp.interpCoord((double)thetas, (double[])this.auxData.rog.getTab(4), (FractIndex)rogIndex[4]);
        return Interp.interpolate((Object)this.auxData.rog.getJavaArray(), (FractIndex[])rogIndex);
    }

    private boolean isPixelClassifiedAsSeaice(GeoPos geoPos) {
        double maxLon = 360.0;
        double minLon = 0.0;
        double maxLat = 180.0;
        double minLat = 0.0;
        for (int y = -1; y <= 1; ++y) {
            for (int x = -1; x <= 1; ++x) {
                double lon = geoPos.lon + 180.0 + (double)x * 1.0;
                double lat = 90.0 - geoPos.lat + (double)y * 1.0;
                lon = Math.max(lon, 0.0);
                lon = Math.min(lon, 360.0);
                lat = Math.max(lat, 0.0);
                lat = Math.min(lat, 180.0);
                SeaIceClassification classification = this.seaIceClassifier.getClassification(lat, lon);
                if (!(classification.max >= 10.0)) continue;
                return true;
            }
        }
        return false;
    }

    private GeoPos getGeoPos(int x, int y) {
        GeoPos geoPos = new GeoPos();
        GeoCoding geoCoding = this.getSourceProduct().getSceneGeoCoding();
        PixelPos pixelPos = new PixelPos((double)x, (double)y);
        geoCoding.getGeoPos(pixelPos, geoPos);
        return geoPos;
    }

    private double azimuth(double x, double y) {
        if (y > 0.0) {
            return 57.29577951308232 * Math.atan(x / y);
        }
        if (y < 0.0) {
            return 180.0 + 57.29577951308232 * Math.atan(x / y);
        }
        return x >= 0.0 ? 90.0 : 270.0;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(IdepixMerisWaterClassificationOp.class);
        }
    }
}

