/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.binding.internal;

import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValueSet;
import com.bc.ceres.swing.binding.ComponentAdapter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;

public class ButtonGroupAdapter
extends ComponentAdapter
implements ActionListener {
    private final ButtonGroup buttonGroup;
    private AbstractButton[] buttons;
    private final Map<AbstractButton, Object> buttonToValueMap;
    private final Map<Object, AbstractButton> valueToButtonMap;

    public ButtonGroupAdapter(ButtonGroup buttonGroup, Map<AbstractButton, Object> buttonToValueMap) {
        this.buttonGroup = buttonGroup;
        this.buttonToValueMap = buttonToValueMap;
        this.valueToButtonMap = new HashMap<Object, AbstractButton>(buttonToValueMap.size());
    }

    public ButtonGroup getButtonGroup() {
        return this.buttonGroup;
    }

    @Override
    public JComponent[] getComponents() {
        return (JComponent[])this.buttons.clone();
    }

    @Override
    public void bindComponents() {
        Enumeration<AbstractButton> buttonEnum = this.buttonGroup.getElements();
        int count = this.buttonGroup.getButtonCount();
        this.buttons = new AbstractButton[count];
        for (int i = 0; i < count; ++i) {
            AbstractButton button = buttonEnum.nextElement();
            button.addActionListener(this);
            this.buttons[i] = button;
            this.valueToButtonMap.put(this.buttonToValueMap.get(button), button);
        }
    }

    @Override
    public void unbindComponents() {
        Enumeration<AbstractButton> buttonEnum = this.buttonGroup.getElements();
        int count = this.buttonGroup.getButtonCount();
        for (int i = 0; i < count; ++i) {
            AbstractButton button = buttonEnum.nextElement();
            button.removeActionListener(this);
            this.valueToButtonMap.remove(this.buttonToValueMap.get(button));
        }
        this.valueToButtonMap.clear();
    }

    @Override
    public void adjustComponents() {
        AbstractButton button;
        Object value = this.getBinding().getPropertyValue();
        if (value != null && (button = this.valueToButtonMap.get(value)) != null) {
            button.setSelected(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AbstractButton button = (AbstractButton)e.getSource();
        this.getBinding().setPropertyValue(this.buttonToValueMap.get(button));
    }

    public static Map<AbstractButton, Object> createButtonToValueMap(ButtonGroup buttonGroup, PropertySet propertySet, String propertyName) {
        PropertyDescriptor descriptor = propertySet.getDescriptor(propertyName);
        if (descriptor == null) {
            throw new IllegalStateException(String.format("descriptor == null (property '%s')", propertyName));
        }
        ValueSet valueSet = descriptor.getValueSet();
        if (valueSet == null) {
            throw new IllegalStateException(String.format("valueSet == null (property '%s')", propertyName));
        }
        Object[] items = valueSet.getItems();
        if (buttonGroup.getButtonCount() != items.length) {
            throw new IllegalStateException(String.format("buttonGroup.getButtonCount() != items.length (property '%s')", propertyName));
        }
        Enumeration<AbstractButton> buttonEnum = buttonGroup.getElements();
        HashMap<AbstractButton, Object> buttonToValueMap = new HashMap<AbstractButton, Object>(items.length);
        for (Object item : items) {
            buttonToValueMap.put(buttonEnum.nextElement(), item);
        }
        return buttonToValueMap;
    }
}

