/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.binding.internal;

import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.PropertyEditor;
import com.bc.ceres.swing.binding.internal.AbstractButtonAdapter;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class CheckBoxEditor
extends PropertyEditor {
    @Override
    public boolean isValidFor(PropertyDescriptor propertyDescriptor) {
        Class type = propertyDescriptor.getType();
        return Boolean.TYPE.equals(type) || Boolean.class.isAssignableFrom(type);
    }

    @Override
    public JComponent[] createComponents(PropertyDescriptor propertyDescriptor, BindingContext bindingContext) {
        JCheckBox checkBox = CheckBoxEditor.createCheckBoxComponent(propertyDescriptor, bindingContext);
        checkBox.setText(propertyDescriptor.getDisplayName());
        return new JComponent[]{checkBox};
    }

    @Override
    public JComponent createEditorComponent(PropertyDescriptor propertyDescriptor, BindingContext bindingContext) {
        return CheckBoxEditor.createCheckBoxComponent(propertyDescriptor, bindingContext);
    }

    private static JCheckBox createCheckBoxComponent(PropertyDescriptor propertyDescriptor, BindingContext bindingContext) {
        JCheckBox checkBox = new JCheckBox();
        AbstractButtonAdapter adapter = new AbstractButtonAdapter(checkBox);
        bindingContext.bind(propertyDescriptor.getName(), adapter);
        return checkBox;
    }
}

