/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.figure;

import com.bc.ceres.swing.figure.Interactor;
import com.bc.ceres.swing.figure.InteractorInterceptor;
import com.bc.ceres.swing.figure.InteractorListener;
import java.awt.Cursor;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;

public abstract class AbstractInteractor
implements Interactor {
    private boolean active;
    private ArrayList<InteractorListener> listeners = new ArrayList(3);

    protected AbstractInteractor() {
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean activate() {
        if (!this.active) {
            this.active = this.canActivateInteractor();
            if (this.isActive()) {
                for (InteractorListener listener : this.getListeners()) {
                    listener.interactorActivated(this);
                }
            }
        }
        return this.isActive();
    }

    @Override
    public void deactivate() {
        if (this.active) {
            this.active = false;
            for (InteractorListener listener : this.getListeners()) {
                listener.interactorDeactivated(this);
            }
        }
    }

    @Override
    public Cursor getCursor() {
        return Cursor.getDefaultCursor();
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseDragged(MouseEvent event) {
    }

    @Override
    public void mouseMoved(MouseEvent event) {
    }

    @Override
    public void keyPressed(KeyEvent event) {
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    @Override
    public void keyTyped(KeyEvent event) {
        if (event.getKeyChar() == '\u001b') {
            this.cancelInteraction(event);
        }
    }

    @Override
    public void addListener(InteractorListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListener(InteractorListener l) {
        this.listeners.remove(l);
    }

    @Override
    public InteractorListener[] getListeners() {
        return this.listeners.toArray(new InteractorListener[this.listeners.size()]);
    }

    protected boolean startInteraction(InputEvent inputEvent) {
        if (this.canStartInteraction(inputEvent)) {
            for (InteractorListener listener : this.getListeners()) {
                listener.interactionStarted(this, inputEvent);
            }
            return true;
        }
        return false;
    }

    protected void stopInteraction(InputEvent inputEvent) {
        for (InteractorListener listener : this.getListeners()) {
            listener.interactionStopped(this, inputEvent);
        }
    }

    protected void cancelInteraction(InputEvent inputEvent) {
        for (InteractorListener listener : this.getListeners()) {
            listener.interactionCancelled(this, inputEvent);
        }
    }

    protected static boolean isSingleButton1Click(MouseEvent e) {
        return AbstractInteractor.isLeftMouseButtonDown(e) && e.getClickCount() == 1;
    }

    protected static boolean isMultiButton1Click(MouseEvent e) {
        return AbstractInteractor.isLeftMouseButtonDown(e) && e.getClickCount() > 1;
    }

    protected static boolean isLeftMouseButtonDown(MouseEvent e) {
        return (e.getModifiers() & 0x10) != 0;
    }

    private boolean canActivateInteractor() {
        for (InteractorListener listener : this.getListeners()) {
            InteractorInterceptor interactorInterceptor;
            if (!(listener instanceof InteractorInterceptor) || (interactorInterceptor = (InteractorInterceptor)((Object)listener)).interactorAboutToActivate(this)) continue;
            return false;
        }
        return true;
    }

    private boolean canStartInteraction(InputEvent inputEvent) {
        for (InteractorListener listener : this.getListeners()) {
            InteractorInterceptor interactorInterceptor;
            if (!(listener instanceof InteractorInterceptor) || (interactorInterceptor = (InteractorInterceptor)((Object)listener)).interactionAboutToStart(this, inputEvent)) continue;
            return false;
        }
        return true;
    }
}

