/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.binding.internal;

import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.ValueRange;
import com.bc.ceres.swing.binding.ComponentAdapter;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SliderAdapter
extends ComponentAdapter
implements ChangeListener {
    private final JSlider slider;
    private double scale;

    public SliderAdapter(JSlider slider) {
        this.slider = slider;
    }

    @Override
    public JComponent[] getComponents() {
        return new JComponent[]{this.slider};
    }

    @Override
    public void bindComponents() {
        this.updateScale();
        this.slider.addChangeListener(this);
    }

    @Override
    public void unbindComponents() {
        this.slider.removeChangeListener(this);
    }

    @Override
    public void adjustComponents() {
        Number value = (Number)this.getBinding().getPropertyValue();
        this.slider.setValue((int)(value.doubleValue() / this.scale));
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.getBinding().setPropertyValue((double)this.slider.getValue() * this.scale);
    }

    private void updateScale() {
        PropertyDescriptor propertyDescriptor = this.getBinding().getContext().getPropertySet().getDescriptor(this.getBinding().getPropertyName());
        ValueRange range = propertyDescriptor.getValueRange();
        this.scale = range != null ? (range.getMax() - range.getMin()) / (double)(this.slider.getMaximum() - this.slider.getMinimum()) : 1.0;
    }
}

