/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.update;

import com.bc.ceres.core.CoreException;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.runtime.Module;
import com.bc.ceres.core.runtime.ModuleState;
import com.bc.ceres.core.runtime.Version;
import com.bc.ceres.core.runtime.internal.ModuleImpl;
import com.bc.ceres.core.runtime.internal.ModuleManifestParser;
import com.bc.ceres.swing.update.DefaultModuleManager;
import com.bc.ceres.swing.update.ModuleItem;
import com.bc.ceres.swing.update.ModuleManager;
import com.bc.ceres.swing.update.ModuleSyncRunnerTest;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Ignore;

@Ignore
public class TestHelpers {
    public static Module newRepositoryModuleMock(String name, String version, ModuleState state) throws CoreException {
        return TestHelpers.newModuleImpl(name, version, state);
    }

    public static ModuleItem newModuleItemMock(String name, String version, ModuleState state) throws CoreException {
        return new ModuleItem(TestHelpers.newModuleImpl(name, version, state));
    }

    private static ModuleImpl newModuleImpl(String name, String version, ModuleState state) throws CoreException {
        ModuleImpl module = null;
        String resource = "xml/" + name + ".xml";
        try {
            module = TestHelpers.loadModule(resource);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)(resource + ": " + e.getMessage()));
        }
        module.setVersion(Version.parseVersion((String)version));
        module.setState(state);
        return module;
    }

    public static ModuleImpl loadModule(String resource) throws IOException, CoreException {
        URL url = ModuleSyncRunnerTest.class.getResource(resource);
        if (url == null) {
            Assert.fail((String)("resource not found: " + resource));
        }
        ModuleImpl module = new ModuleManifestParser().parse(url.openStream());
        module.setLocation(url);
        return module;
    }

    static ModuleManager createModuleManager(final String[] installedResourcePaths, final String[] repositoryResourcePaths) {
        return new DefaultModuleManager(null){
            private ModuleImpl[] installedModules;
            private Module[] repositoryModules;

            public Module[] getInstalledModules() {
                if (this.installedModules == null) {
                    for (ModuleImpl installedModule : this.installedModules = this.createModules(installedResourcePaths)) {
                        installedModule.setState(ModuleState.ACTIVE);
                    }
                }
                return this.installedModules;
            }

            public Module[] getRepositoryModules(ProgressMonitor pm) throws CoreException {
                if (this.repositoryModules == null) {
                    this.repositoryModules = this.createModules(repositoryResourcePaths);
                }
                return this.repositoryModules;
            }

            private ModuleImpl[] createModules(String[] moduleResourcePaths) {
                ArrayList<ModuleImpl> moduleList = new ArrayList<ModuleImpl>(moduleResourcePaths.length);
                for (String resourcePath : moduleResourcePaths) {
                    moduleList.add(this.createModule(resourcePath));
                }
                return moduleList.toArray(new ModuleImpl[moduleList.size()]);
            }

            private ModuleImpl createModule(String moduleResourcePath) {
                ModuleImpl module = null;
                try {
                    module = TestHelpers.loadModule(moduleResourcePath);
                }
                catch (Exception e) {
                    String msgPattern = "Not able to load module descriptor for [{0}] - {1}";
                    Assert.fail((String)MessageFormat.format(msgPattern, moduleResourcePath, e.getMessage()));
                }
                return module;
            }
        };
    }
}

