/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.update;

import com.bc.ceres.core.CoreException;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.runtime.Version;
import com.bc.ceres.swing.update.ModuleManager;
import com.bc.ceres.swing.update.TestHelpers;
import junit.framework.TestCase;

public class ModuleManagerTest
extends TestCase {
    public void testInstallMultiVersionsOnRepo() throws CoreException {
        String[] installedModuleFileNames = new String[]{"xml/consistency/module-a-1.1.xml"};
        String[] repositoryModuleFileNames = new String[]{"xml/consistency/module-b-2.3.1.xml", "xml/consistency/module-b-2.3.2-needs-a-1.1.xml", "xml/consistency/module-b-2.4.xml"};
        ModuleManager moduleManager = TestHelpers.createModuleManager(installedModuleFileNames, repositoryModuleFileNames);
        moduleManager.synchronizeWithRepository(ProgressMonitor.NULL);
        ModuleManagerTest.assertEquals((int)1, (int)moduleManager.getInstalledModuleItems().length);
        ModuleManagerTest.assertEquals((int)0, (int)moduleManager.getUpdatableModuleItems().length);
        ModuleManagerTest.assertEquals((int)1, (int)moduleManager.getAvailableModuleItems().length);
        ModuleManagerTest.assertEquals((String)"module-b", (String)moduleManager.getAvailableModuleItems()[0].getModule().getSymbolicName());
        ModuleManagerTest.assertEquals((Object)Version.parseVersion((String)"2.4"), (Object)moduleManager.getAvailableModuleItems()[0].getModule().getVersion());
    }

    public void testUpdateMultiVersionsOnRepo() throws CoreException {
        String[] installedModuleFileNames = new String[]{"xml/consistency/module-a-1.0.xml"};
        String[] repositoryModuleFileNames = new String[]{"xml/consistency/module-a-1.0.1.xml", "xml/consistency/module-a-1.1.xml"};
        ModuleManager moduleManager = TestHelpers.createModuleManager(installedModuleFileNames, repositoryModuleFileNames);
        moduleManager.synchronizeWithRepository(ProgressMonitor.NULL);
        ModuleManagerTest.assertEquals((int)1, (int)moduleManager.getInstalledModuleItems().length);
        ModuleManagerTest.assertEquals((int)1, (int)moduleManager.getUpdatableModuleItems().length);
        ModuleManagerTest.assertEquals((int)0, (int)moduleManager.getAvailableModuleItems().length);
        ModuleManagerTest.assertEquals((String)"module-a", (String)moduleManager.getUpdatableModuleItems()[0].getModule().getSymbolicName());
        ModuleManagerTest.assertEquals((Object)Version.parseVersion((String)"1.0"), (Object)moduleManager.getUpdatableModuleItems()[0].getModule().getVersion());
        ModuleManagerTest.assertEquals((Object)Version.parseVersion((String)"1.1"), (Object)moduleManager.getUpdatableModuleItems()[0].getRepositoryModule().getVersion());
    }
}

