/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.selection.support;

import com.bc.ceres.swing.selection.support.DefaultSelection;
import java.awt.datatransfer.DataFlavor;
import junit.framework.TestCase;

public class DefaultSelectionTest
extends TestCase {
    public void testEmpty() {
        DefaultSelection selection = new DefaultSelection(new Object[0]);
        DefaultSelectionTest.assertEquals((boolean)true, (boolean)selection.isEmpty());
        DefaultSelectionTest.assertEquals(null, (Object)selection.getSelectedValue());
        DefaultSelectionTest.assertNotNull((Object)selection.getSelectedValues());
        DefaultSelectionTest.assertEquals((int)0, (int)selection.getSelectedValues().length);
        DefaultSelectionTest.assertEquals((String)"", (String)selection.getPresentationName());
        DefaultSelectionTest.assertNull((Object)selection.createTransferable(false));
        DefaultSelectionTest.assertNull((Object)selection.createTransferable(true));
        DefaultSelectionTest.assertEquals((String)"DefaultSelection[selectedValues={}]", (String)selection.toString());
        DefaultSelectionTest.assertEquals((boolean)false, (boolean)selection.equals(null));
        DefaultSelectionTest.assertEquals((boolean)true, (boolean)selection.equals((Object)selection));
        DefaultSelectionTest.assertEquals((boolean)true, (boolean)selection.equals((Object)new DefaultSelection(new Object[0])));
        DefaultSelectionTest.assertEquals((boolean)false, (boolean)selection.equals((Object)new DefaultSelection(new Object[]{"B"})));
    }

    public void testOneElement() {
        DefaultSelection selection = new DefaultSelection(new Object[]{"X"});
        DefaultSelectionTest.assertEquals((boolean)false, (boolean)selection.isEmpty());
        DefaultSelectionTest.assertEquals((Object)"X", (Object)selection.getSelectedValue());
        DefaultSelectionTest.assertNotNull((Object)selection.getSelectedValues());
        DefaultSelectionTest.assertEquals((int)1, (int)selection.getSelectedValues().length);
        DefaultSelectionTest.assertEquals((Object)"X", (Object)selection.getSelectedValues()[0]);
        DefaultSelectionTest.assertEquals((String)"X", (String)selection.getPresentationName());
        DefaultSelectionTest.assertNotNull((Object)selection.createTransferable(false));
        DefaultSelectionTest.assertNotNull((Object)selection.createTransferable(true));
        DefaultSelectionTest.assertEquals((boolean)true, (boolean)selection.createTransferable(true).isDataFlavorSupported(DataFlavor.stringFlavor));
        DefaultSelectionTest.assertEquals((String)"DefaultSelection[selectedValues={X}]", (String)selection.toString());
        DefaultSelectionTest.assertEquals((boolean)false, (boolean)selection.equals(null));
        DefaultSelectionTest.assertEquals((boolean)true, (boolean)selection.equals((Object)selection));
        DefaultSelectionTest.assertEquals((boolean)true, (boolean)selection.equals((Object)new DefaultSelection(new Object[]{"X"})));
        DefaultSelectionTest.assertEquals((boolean)false, (boolean)selection.equals((Object)new DefaultSelection(new Object[]{"B"})));
    }

    public void testMoreElements() {
        DefaultSelection selection = new DefaultSelection(new Object[]{"A", "B", "C"});
        DefaultSelectionTest.assertEquals((boolean)false, (boolean)selection.isEmpty());
        DefaultSelectionTest.assertEquals((Object)"A", (Object)selection.getSelectedValue());
        DefaultSelectionTest.assertNotNull((Object)selection.getSelectedValues());
        DefaultSelectionTest.assertEquals((int)3, (int)selection.getSelectedValues().length);
        DefaultSelectionTest.assertEquals((Object)"A", (Object)selection.getSelectedValues()[0]);
        DefaultSelectionTest.assertEquals((Object)"B", (Object)selection.getSelectedValues()[1]);
        DefaultSelectionTest.assertEquals((Object)"C", (Object)selection.getSelectedValues()[2]);
        DefaultSelectionTest.assertEquals((String)"A", (String)selection.getPresentationName());
        DefaultSelectionTest.assertNotNull((Object)selection.createTransferable(false));
        DefaultSelectionTest.assertNotNull((Object)selection.createTransferable(true));
        DefaultSelectionTest.assertEquals((boolean)true, (boolean)selection.createTransferable(true).isDataFlavorSupported(DataFlavor.stringFlavor));
        DefaultSelectionTest.assertEquals((String)"DefaultSelection[selectedValues={A,B,C}]", (String)selection.toString());
        DefaultSelectionTest.assertEquals((boolean)false, (boolean)selection.equals(null));
        DefaultSelectionTest.assertEquals((boolean)true, (boolean)selection.equals((Object)selection));
        DefaultSelectionTest.assertEquals((boolean)true, (boolean)selection.equals((Object)new DefaultSelection(new Object[]{"A", "B", "C"})));
        DefaultSelectionTest.assertEquals((boolean)false, (boolean)selection.equals((Object)new DefaultSelection(new Object[]{"B", "A", "C"})));
        DefaultSelectionTest.assertEquals((boolean)false, (boolean)selection.equals((Object)new DefaultSelection(new Object[]{"B"})));
    }
}

