/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.figure.support;

import com.bc.ceres.swing.figure.support.ImageSymbol;
import java.awt.geom.Rectangle2D;
import org.junit.Assert;
import org.junit.Test;

public class ImageSymbolTest {
    @Test
    public void testFactoryWithoutRef() throws Exception {
        ImageSymbol imageSymbol = ImageSymbol.createIcon((String)"TestSymbolIcon.png");
        Assert.assertNotNull((Object)imageSymbol);
        Assert.assertNotNull((Object)imageSymbol.getImage());
        Assert.assertEquals((long)16L, (long)imageSymbol.getImage().getWidth());
        Assert.assertEquals((long)8L, (long)imageSymbol.getImage().getHeight());
        Assert.assertEquals((double)8.0, (double)imageSymbol.getRefX(), (double)1.0E-10);
        Assert.assertEquals((double)4.0, (double)imageSymbol.getRefY(), (double)1.0E-10);
        Assert.assertEquals((Object)new Rectangle2D.Double(-8.0, -4.0, 16.0, 8.0), (Object)imageSymbol.getBounds());
    }

    @Test
    public void testFactoryWithRef() throws Exception {
        ImageSymbol imageSymbol = ImageSymbol.createIcon((String)"/com/bc/ceres/swing/figure/support/TestSymbolIcon.png", (double)5.0, (double)3.0);
        Assert.assertNotNull((Object)imageSymbol);
        Assert.assertNotNull((Object)imageSymbol.getImage());
        Assert.assertEquals((long)16L, (long)imageSymbol.getImage().getWidth());
        Assert.assertEquals((long)8L, (long)imageSymbol.getImage().getHeight());
        Assert.assertEquals((double)5.0, (double)imageSymbol.getRefX(), (double)1.0E-10);
        Assert.assertEquals((double)3.0, (double)imageSymbol.getRefY(), (double)1.0E-10);
        Assert.assertEquals((Object)new Rectangle2D.Double(-5.0, -3.0, 16.0, 8.0), (Object)imageSymbol.getBounds());
    }

    @Test
    public void testContainsPoint() throws Exception {
        ImageSymbol imageSymbol = ImageSymbol.createIcon((String)"/com/bc/ceres/swing/figure/support/TestSymbolIcon.png");
        Assert.assertNotNull((Object)imageSymbol);
        Assert.assertEquals((Object)false, (Object)imageSymbol.isHitBy(-9.0, 0.0));
        Assert.assertEquals((Object)true, (Object)imageSymbol.isHitBy(-8.0, 0.0));
        Assert.assertEquals((Object)true, (Object)imageSymbol.isHitBy(-7.0, 0.0));
        Assert.assertEquals((Object)true, (Object)imageSymbol.isHitBy(-6.0, 0.0));
        Assert.assertEquals((Object)true, (Object)imageSymbol.isHitBy(-5.0, 0.0));
        Assert.assertEquals((Object)true, (Object)imageSymbol.isHitBy(-4.0, 0.0));
        Assert.assertEquals((Object)true, (Object)imageSymbol.isHitBy(-3.0, 0.0));
        Assert.assertEquals((Object)true, (Object)imageSymbol.isHitBy(-2.0, 0.0));
        Assert.assertEquals((Object)true, (Object)imageSymbol.isHitBy(-1.0, 0.0));
        Assert.assertEquals((Object)true, (Object)imageSymbol.isHitBy(0.0, 0.0));
        Assert.assertEquals((Object)true, (Object)imageSymbol.isHitBy(1.0, 0.0));
        Assert.assertEquals((Object)true, (Object)imageSymbol.isHitBy(2.0, 0.0));
        Assert.assertEquals((Object)true, (Object)imageSymbol.isHitBy(3.0, 0.0));
        Assert.assertEquals((Object)false, (Object)imageSymbol.isHitBy(4.0, 0.0));
        Assert.assertEquals((Object)false, (Object)imageSymbol.isHitBy(5.0, 0.0));
        Assert.assertEquals((Object)false, (Object)imageSymbol.isHitBy(6.0, 0.0));
        Assert.assertEquals((Object)false, (Object)imageSymbol.isHitBy(7.0, 0.0));
        Assert.assertEquals((Object)false, (Object)imageSymbol.isHitBy(8.0, 0.0));
        Assert.assertEquals((Object)false, (Object)imageSymbol.isHitBy(9.0, 0.0));
    }
}

