/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.figure.interactions;

import com.bc.ceres.swing.figure.Figure;
import com.bc.ceres.swing.figure.FigureCollection;
import com.bc.ceres.swing.figure.FigureEditor;
import com.bc.ceres.swing.figure.FigureFactory;
import com.bc.ceres.swing.figure.FigureStyle;
import com.bc.ceres.swing.figure.Interactor;
import com.bc.ceres.swing.figure.interactions.SelectionInteractor;
import com.bc.ceres.swing.figure.support.DefaultFigureCollection;
import com.bc.ceres.swing.figure.support.DefaultFigureFactory;
import com.bc.ceres.swing.figure.support.DefaultFigureStyle;
import com.bc.ceres.swing.figure.support.DefaultShapeFigure;
import com.bc.ceres.swing.figure.support.FigureEditorPanel;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import junit.framework.TestCase;

public class SelectionInteractionTest
extends TestCase {
    public void testModeChange() {
        DefaultShapeFigure f1 = new DefaultShapeFigure((Shape)new Rectangle(10, 10, 10, 10), Figure.Rank.AREA, (FigureStyle)new DefaultFigureStyle());
        DefaultShapeFigure f2 = new DefaultShapeFigure((Shape)new Rectangle(30, 10, 10, 10), Figure.Rank.AREA, (FigureStyle)new DefaultFigureStyle());
        FigureEditorPanel panel = new FigureEditorPanel(null, (FigureCollection)new DefaultFigureCollection(), (FigureFactory)new DefaultFigureFactory());
        FigureEditor fe = panel.getFigureEditor();
        fe.getFigureCollection().addFigure((Figure)f1);
        fe.getFigureCollection().addFigure((Figure)f2);
        SelectionInteractor sa = new SelectionInteractor();
        sa.activate();
        SelectionInteractionTest.assertEquals((int)0, (int)fe.getFigureSelection().getFigureCount());
        SelectionInteractionTest.assertEquals((int)0, (int)fe.getFigureSelection().getSelectionStage());
        this.click((Interactor)sa, fe, 0, 0, 0);
        SelectionInteractionTest.assertEquals((int)0, (int)fe.getFigureSelection().getFigureCount());
        SelectionInteractionTest.assertEquals((int)0, (int)fe.getFigureSelection().getSelectionStage());
        this.click((Interactor)sa, fe, 15, 15, 0);
        SelectionInteractionTest.assertEquals((int)1, (int)fe.getFigureSelection().getFigureCount());
        SelectionInteractionTest.assertEquals((int)1, (int)fe.getFigureSelection().getSelectionStage());
        SelectionInteractionTest.assertSame((Object)f1, (Object)fe.getFigureSelection().getFigure(0));
        this.click((Interactor)sa, fe, 16, 15, 0);
        SelectionInteractionTest.assertEquals((int)1, (int)fe.getFigureSelection().getFigureCount());
        SelectionInteractionTest.assertEquals((int)2, (int)fe.getFigureSelection().getSelectionStage());
        SelectionInteractionTest.assertSame((Object)f1, (Object)fe.getFigureSelection().getFigure(0));
        this.click((Interactor)sa, fe, 15, 15, 0);
        SelectionInteractionTest.assertEquals((int)1, (int)fe.getFigureSelection().getFigureCount());
        SelectionInteractionTest.assertEquals((int)3, (int)fe.getFigureSelection().getSelectionStage());
        SelectionInteractionTest.assertSame((Object)f1, (Object)fe.getFigureSelection().getFigure(0));
        this.click((Interactor)sa, fe, 0, 0, 0);
        SelectionInteractionTest.assertEquals((int)0, (int)fe.getFigureSelection().getFigureCount());
        SelectionInteractionTest.assertEquals((int)0, (int)fe.getFigureSelection().getSelectionStage());
        this.click((Interactor)sa, fe, 35, 15, 0);
        SelectionInteractionTest.assertEquals((int)1, (int)fe.getFigureSelection().getFigureCount());
        SelectionInteractionTest.assertEquals((int)1, (int)fe.getFigureSelection().getSelectionStage());
        SelectionInteractionTest.assertSame((Object)f2, (Object)fe.getFigureSelection().getFigure(0));
        this.click((Interactor)sa, fe, 15, 15, 2);
        SelectionInteractionTest.assertEquals((int)2, (int)fe.getFigureSelection().getFigureCount());
        SelectionInteractionTest.assertEquals((int)2, (int)fe.getFigureSelection().getSelectionStage());
        SelectionInteractionTest.assertSame((Object)f2, (Object)fe.getFigureSelection().getFigure(0));
        SelectionInteractionTest.assertSame((Object)f1, (Object)fe.getFigureSelection().getFigure(1));
        this.click((Interactor)sa, fe, 0, 0, 0);
        SelectionInteractionTest.assertEquals((int)0, (int)fe.getFigureSelection().getFigureCount());
        SelectionInteractionTest.assertEquals((int)0, (int)fe.getFigureSelection().getSelectionStage());
        this.startDrag((Interactor)sa, fe, 0, 0, 0);
        this.endDrag((Interactor)sa, fe, 100, 100, 0);
        SelectionInteractionTest.assertEquals((int)2, (int)fe.getFigureSelection().getFigureCount());
        SelectionInteractionTest.assertEquals((int)2, (int)fe.getFigureSelection().getSelectionStage());
        SelectionInteractionTest.assertSame((Object)f1, (Object)fe.getFigureSelection().getFigure(0));
        SelectionInteractionTest.assertSame((Object)f2, (Object)fe.getFigureSelection().getFigure(1));
        this.startDrag((Interactor)sa, fe, 15, 15, 0);
        this.endDrag((Interactor)sa, fe, 200, 200, 0);
        SelectionInteractionTest.assertEquals((int)2, (int)fe.getFigureSelection().getFigureCount());
        SelectionInteractionTest.assertEquals((int)2, (int)fe.getFigureSelection().getSelectionStage());
        SelectionInteractionTest.assertSame((Object)f1, (Object)fe.getFigureSelection().getFigure(0));
        SelectionInteractionTest.assertSame((Object)f2, (Object)fe.getFigureSelection().getFigure(1));
        SelectionInteractionTest.assertEquals((Object)new Rectangle2D.Double(195.0, 195.0, 10.0, 10.0), (Object)f1.getBounds());
        SelectionInteractionTest.assertEquals((Object)new Rectangle2D.Double(215.0, 195.0, 10.0, 10.0), (Object)f2.getBounds());
        sa.deactivate();
    }

    private void click(Interactor sa, FigureEditor fe, int x, int y, int modifiers) {
        MouseEvent event = this.createEvent(fe, modifiers, x, y);
        sa.mousePressed(event);
        sa.mouseReleased(event);
    }

    private void startDrag(Interactor sa, FigureEditor fe, int x, int y, int modifiers) {
        MouseEvent event = this.createEvent(fe, modifiers, x, y);
        sa.mousePressed(event);
        sa.mouseDragged(event);
    }

    private void endDrag(Interactor sa, FigureEditor fe, int x, int y, int modifiers) {
        MouseEvent event = this.createEvent(fe, modifiers, x, y);
        sa.mouseDragged(event);
        sa.mouseReleased(event);
    }

    private MouseEvent createEvent(FigureEditor fe, int modifiers, int x, int y) {
        return new MouseEvent(fe.getEditorComponent(), 0, 0L, modifiers, x, y, 1, false);
    }
}

