/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.figure.interactions;

import com.bc.ceres.swing.figure.FigureCollection;
import com.bc.ceres.swing.figure.FigureFactory;
import com.bc.ceres.swing.figure.ShapeFigure;
import com.bc.ceres.swing.figure.interactions.InsertMultiPointFigureInteractor;
import com.bc.ceres.swing.figure.support.DefaultFigureCollection;
import com.bc.ceres.swing.figure.support.DefaultFigureFactory;
import com.bc.ceres.swing.figure.support.FigureEditorPanel;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InsertMultiPointFigureInteractorTest {
    private InsertMultiPointFigureInteractor interactor;
    private static FigureEditorPanel figureEditorPanel;

    @Before
    public void setup() {
        this.interactor = new InsertMultiPointFigureInteractor(true);
        this.interactor.activate();
        figureEditorPanel = new FigureEditorPanel(null, (FigureCollection)new DefaultFigureCollection(), (FigureFactory)new DefaultFigureFactory());
    }

    @Test
    public void testInteraction3Points() {
        this.interactor.mouseReleased(this.createMouseEvent(0, 0, 1));
        Point2D[] expectedPoints = new Point2D[]{new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, 0.0)};
        Point2D[] actualPoints = this.interactor.getPoints();
        this.performArrayTest(expectedPoints, actualPoints);
        this.interactor.mouseMoved(this.createMouseEvent(10, 10, 1));
        expectedPoints = new Point2D[]{new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, 0.0), new Point2D.Double(10.0, 10.0)};
        actualPoints = this.interactor.getPoints();
        this.performArrayTest(expectedPoints, actualPoints);
        this.interactor.mouseReleased(this.createMouseEvent(12, 12, 1));
        expectedPoints = new Point2D[]{new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, 0.0), new Point2D.Double(12.0, 12.0), new Point2D.Double(12.0, 12.0)};
        actualPoints = this.interactor.getPoints();
        this.performArrayTest(expectedPoints, actualPoints);
        this.interactor.mouseReleased(this.createMouseEvent(13, 16, 1));
        expectedPoints = new Point2D[]{new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, 0.0), new Point2D.Double(12.0, 12.0), new Point2D.Double(13.0, 16.0), new Point2D.Double(13.0, 16.0)};
        actualPoints = this.interactor.getPoints();
        this.performArrayTest(expectedPoints, actualPoints);
        this.interactor.mouseClicked(this.createMouseEvent(29, 5, 2));
        this.performFinalFigureTest(new Point2D[]{new Point2D.Double(0.0, 0.0), new Point2D.Double(12.0, 12.0), new Point2D.Double(13.0, 16.0), new Point2D.Double(0.0, 0.0)});
    }

    @Test
    public void testInteraction2Points() {
        this.interactor.mouseReleased(this.createMouseEvent(0, 0, 1));
        Point2D[] expectedPoints = new Point2D[]{new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, 0.0)};
        Point2D[] actualPoints = this.interactor.getPoints();
        this.performArrayTest(expectedPoints, actualPoints);
        this.interactor.mouseReleased(this.createMouseEvent(13, 16, 1));
        expectedPoints = new Point2D[]{new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, 0.0), new Point2D.Double(13.0, 16.0), new Point2D.Double(13.0, 16.0)};
        actualPoints = this.interactor.getPoints();
        this.performArrayTest(expectedPoints, actualPoints);
        this.interactor.mouseClicked(this.createMouseEvent(29, 5, 2));
        this.performFinalFigureTest(new Point2D[]{new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, 0.0), new Point2D.Double(13.0, 16.0), new Point2D.Double(0.0, 0.0)});
    }

    private void performFinalFigureTest(Point2D[] expectedPoints) {
        ShapeFigure figure = (ShapeFigure)figureEditorPanel.getFigureEditor().getFigureCollection().getFigure(0);
        PathIterator pathIterator = figure.getShape().getPathIterator(null);
        ArrayList<Point2D.Double> segList = new ArrayList<Point2D.Double>();
        while (!pathIterator.isDone()) {
            double[] seg = new double[6];
            pathIterator.currentSegment(seg);
            segList.add(new Point2D.Double(seg[0], seg[1]));
            pathIterator.next();
        }
        this.performArrayTest(expectedPoints, segList.toArray(new Point2D[segList.size()]));
    }

    private void performArrayTest(Point2D[] expectedPoints, Point2D[] actualPoints) {
        if (expectedPoints.length != actualPoints.length) {
            this.failTest(expectedPoints, actualPoints);
        }
        int expectedPointsLength = expectedPoints.length;
        for (int i = 0; i < expectedPointsLength; ++i) {
            Point2D expectedPoint = expectedPoints[i];
            Point2D actualPoint = actualPoints[i];
            if (expectedPoint.equals(actualPoint)) continue;
            this.failTest(expectedPoints, actualPoints, i);
        }
    }

    private void failTest(Point2D[] expectedPoints, Point2D[] actualPoints, int index) {
        Assert.fail((String)("Arrays not equal at <" + index + ">:\n" + "expected:" + Arrays.toString(expectedPoints) + "\n" + "actual:" + Arrays.toString(actualPoints)));
    }

    private void failTest(Point2D[] expectedPoints, Point2D[] actualPoints) {
        Assert.fail((String)("Arrays not equal:\nexpected:" + Arrays.toString(expectedPoints) + "\n" + "actual:" + Arrays.toString(actualPoints)));
    }

    private MouseEvent createMouseEvent(int x, int y, int clickCount) {
        return new MouseEvent((Component)figureEditorPanel, 0, System.currentTimeMillis(), 0, x, y, clickCount, false);
    }
}

