/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.binding.internal;

import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.internal.FileEditor;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import junit.framework.TestCase;

public class FileEditorTest
extends TestCase {
    public void testIsApplicable() throws Exception {
        FileEditor fileEditor = new FileEditor();
        PropertyDescriptor fileDescriptor = new PropertyDescriptor("test", File.class);
        FileEditorTest.assertTrue((boolean)fileEditor.isValidFor(fileDescriptor));
        PropertyDescriptor doubleDescriptor = new PropertyDescriptor("test", Double.TYPE);
        FileEditorTest.assertFalse((boolean)fileEditor.isValidFor(doubleDescriptor));
    }

    public void testCreateEditorComponent() throws Exception {
        FileEditor fileEditor = new FileEditor();
        PropertyContainer propertyContainer = PropertyContainer.createValueBacked(V.class);
        BindingContext bindingContext = new BindingContext((PropertySet)propertyContainer);
        PropertyDescriptor propertyDescriptor = propertyContainer.getDescriptor("file");
        FileEditorTest.assertSame(File.class, (Object)propertyDescriptor.getType());
        FileEditorTest.assertTrue((boolean)fileEditor.isValidFor(propertyDescriptor));
        JComponent editorComponent = fileEditor.createEditorComponent(propertyDescriptor, bindingContext);
        FileEditorTest.assertNotNull((Object)editorComponent);
        FileEditorTest.assertSame(JPanel.class, editorComponent.getClass());
        FileEditorTest.assertEquals((int)2, (int)editorComponent.getComponentCount());
        JComponent[] components = bindingContext.getBinding("file").getComponents();
        FileEditorTest.assertEquals((int)1, (int)components.length);
        FileEditorTest.assertSame(JTextField.class, components[0].getClass());
    }

    private static class V {
        File file;

        private V() {
        }
    }
}

