/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing;

import com.bc.ceres.swing.Grid;
import com.bc.ceres.swing.GridSelectionModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.junit.Assert;
import org.junit.Test;

public class GridTest {
    @Test
    public void testEmptyGrid() throws Exception {
        Grid grid = new Grid(4, true);
        Assert.assertEquals((long)4L, (long)grid.getColumnCount());
        Assert.assertEquals((long)0L, (long)grid.getDataRowCount());
        Assert.assertEquals((long)1L, (long)grid.getRowCount());
        Assert.assertEquals(null, (Object)grid.getComponent(0, 0));
        Assert.assertEquals((Object)false, (Object)grid.isDataRowSelected(0));
        Assert.assertEquals((long)0L, (long)grid.getSelectedDataRowCount());
        Assert.assertArrayEquals((int[])GridTest.asArray(new int[0]), (int[])grid.getSelectedDataRowIndexes());
    }

    @Test
    public void testSetHeaderRow() throws Exception {
        Grid grid = new Grid(4, true);
        JLabel c1 = new JLabel();
        JLabel c2 = new JLabel();
        JLabel c3 = new JLabel();
        grid.setHeaderRow(new JComponent[]{c1, c2, c3});
        Assert.assertEquals((long)4L, (long)grid.getColumnCount());
        Assert.assertEquals((long)0L, (long)grid.getDataRowCount());
        Assert.assertEquals((long)1L, (long)grid.getRowCount());
        Assert.assertNotNull((Object)grid.getComponent(0, 0));
        Assert.assertEquals(JCheckBox.class, grid.getComponent(0, 0).getClass());
        Assert.assertSame((Object)c1, (Object)grid.getComponent(0, 1));
        Assert.assertSame((Object)c2, (Object)grid.getComponent(0, 2));
        Assert.assertSame((Object)c3, (Object)grid.getComponent(0, 3));
    }

    @Test
    public void testAddDataRow() throws Exception {
        Grid grid = new Grid(4, true);
        JLabel c1 = new JLabel();
        JLabel c2 = new JLabel();
        JLabel c3 = new JLabel();
        JLabel c4 = new JLabel();
        JLabel c5 = new JLabel();
        JLabel c6 = new JLabel();
        grid.addDataRow(new JComponent[]{c1, c2, c3});
        Assert.assertEquals((long)1L, (long)grid.getDataRowCount());
        Assert.assertEquals((long)2L, (long)grid.getRowCount());
        Assert.assertEquals(JCheckBox.class, grid.getComponent(1, 0).getClass());
        Assert.assertSame((Object)c1, (Object)grid.getComponent(1, 1));
        Assert.assertSame((Object)c2, (Object)grid.getComponent(1, 2));
        Assert.assertSame((Object)c3, (Object)grid.getComponent(1, 3));
        grid.addDataRow(new JComponent[]{c4, c5, c6});
        Assert.assertEquals((long)2L, (long)grid.getDataRowCount());
        Assert.assertEquals((long)3L, (long)grid.getRowCount());
        Assert.assertEquals(JCheckBox.class, grid.getComponent(1, 0).getClass());
        Assert.assertSame((Object)c1, (Object)grid.getComponent(1, 1));
        Assert.assertSame((Object)c2, (Object)grid.getComponent(1, 2));
        Assert.assertSame((Object)c3, (Object)grid.getComponent(1, 3));
        Assert.assertEquals(JCheckBox.class, grid.getComponent(2, 0).getClass());
        Assert.assertSame((Object)c4, (Object)grid.getComponent(2, 1));
        Assert.assertSame((Object)c5, (Object)grid.getComponent(2, 2));
        Assert.assertSame((Object)c6, (Object)grid.getComponent(2, 3));
    }

    @Test
    public void testRemoveDataRow() throws Exception {
        Grid grid = new Grid(4, true);
        JLabel c1 = new JLabel();
        JLabel c2 = new JLabel();
        JLabel c3 = new JLabel();
        JLabel c4 = new JLabel();
        JLabel c5 = new JLabel();
        JLabel c6 = new JLabel();
        grid.addDataRow(new JComponent[]{c1, c2, c3});
        grid.addDataRow(new JComponent[]{c4, c5, c6});
        grid.removeDataRow(0);
        Assert.assertEquals((long)1L, (long)grid.getDataRowCount());
        Assert.assertEquals((long)2L, (long)grid.getRowCount());
        Assert.assertEquals(JCheckBox.class, grid.getComponent(1, 0).getClass());
        Assert.assertSame((Object)c4, (Object)grid.getComponent(1, 1));
        Assert.assertSame((Object)c5, (Object)grid.getComponent(1, 2));
        Assert.assertSame((Object)c6, (Object)grid.getComponent(1, 3));
        grid.removeDataRow(0);
        Assert.assertEquals((long)0L, (long)grid.getDataRowCount());
        Assert.assertEquals((long)1L, (long)grid.getRowCount());
    }

    @Test
    public void testRemoveDataRows() throws Exception {
        Grid grid = new Grid(4, true);
        JLabel c1 = new JLabel();
        JLabel c2 = new JLabel();
        JLabel c3 = new JLabel();
        JLabel c4 = new JLabel();
        JLabel c5 = new JLabel();
        JLabel c6 = new JLabel();
        grid.addDataRow(new JComponent[]{c1, c2, c3});
        grid.addDataRow(new JComponent[]{new JLabel(), new JLabel(), new JLabel()});
        grid.addDataRow(new JComponent[]{c4, c5, c6});
        grid.addDataRow(new JComponent[]{new JLabel(), new JLabel(), new JLabel()});
        grid.removeDataRows(new int[]{1, 3});
        Assert.assertEquals((long)2L, (long)grid.getDataRowCount());
        Assert.assertEquals((long)3L, (long)grid.getRowCount());
        Assert.assertEquals(JCheckBox.class, grid.getComponent(1, 0).getClass());
        Assert.assertSame((Object)c1, (Object)grid.getComponent(1, 1));
        Assert.assertSame((Object)c2, (Object)grid.getComponent(1, 2));
        Assert.assertSame((Object)c3, (Object)grid.getComponent(1, 3));
        Assert.assertEquals(JCheckBox.class, grid.getComponent(2, 0).getClass());
        Assert.assertSame((Object)c4, (Object)grid.getComponent(2, 1));
        Assert.assertSame((Object)c5, (Object)grid.getComponent(2, 2));
        Assert.assertSame((Object)c6, (Object)grid.getComponent(2, 3));
    }

    @Test
    public void testSelectionState_1() throws Exception {
        Grid grid = new Grid(4, true);
        MySelectionListener listener = new MySelectionListener();
        grid.getSelectionModel().addListener((GridSelectionModel.Listener)listener);
        grid.addDataRow(new JComponent[]{new JLabel(), new JLabel(), new JLabel()});
        grid.addDataRow(new JComponent[]{new JLabel(), new JLabel(), new JLabel()});
        grid.addDataRow(new JComponent[]{new JLabel(), new JLabel(), new JLabel()});
        Assert.assertEquals((long)0L, (long)grid.getSelectedDataRowCount());
        Assert.assertEquals((long)-1L, (long)grid.getSelectedDataRowIndex());
        Assert.assertArrayEquals((int[])GridTest.asArray(new int[0]), (int[])grid.getSelectedDataRowIndexes());
        ((JCheckBox)grid.getComponent(2, 0)).doClick();
        Assert.assertEquals((long)1L, (long)grid.getSelectedDataRowCount());
        Assert.assertEquals((long)1L, (long)grid.getSelectedDataRowIndex());
        Assert.assertArrayEquals((int[])GridTest.asArray(1), (int[])grid.getSelectedDataRowIndexes());
        ((JCheckBox)grid.getComponent(1, 0)).doClick();
        ((JCheckBox)grid.getComponent(3, 0)).doClick();
        Assert.assertEquals((long)3L, (long)grid.getSelectedDataRowCount());
        Assert.assertEquals((long)0L, (long)grid.getSelectedDataRowIndex());
        Assert.assertArrayEquals((int[])GridTest.asArray(0, 1, 2), (int[])grid.getSelectedDataRowIndexes());
        Assert.assertEquals((long)3L, (long)listener.count);
    }

    @Test
    public void testSelectionState_2() throws Exception {
        Grid grid = new Grid(4, true);
        MySelectionListener listener = new MySelectionListener();
        grid.getSelectionModel().addListener((GridSelectionModel.Listener)listener);
        grid.addDataRow(new JComponent[]{new JLabel(), new JLabel(), new JLabel()});
        grid.addDataRow(new JComponent[]{new JLabel(), new JLabel(), new JLabel()});
        grid.addDataRow(new JComponent[]{new JLabel(), new JLabel(), new JLabel()});
        Assert.assertEquals((long)0L, (long)grid.getSelectedDataRowCount());
        Assert.assertEquals((long)-1L, (long)grid.getSelectedDataRowIndex());
        Assert.assertArrayEquals((int[])GridTest.asArray(new int[0]), (int[])grid.getSelectedDataRowIndexes());
        grid.setSelectedDataRowIndexes(new int[]{2});
        Assert.assertEquals((long)1L, (long)grid.getSelectedDataRowCount());
        Assert.assertEquals((long)2L, (long)grid.getSelectedDataRowIndex());
        Assert.assertArrayEquals((int[])GridTest.asArray(2), (int[])grid.getSelectedDataRowIndexes());
        grid.setSelectedDataRowIndexes(new int[]{1, 2, 3});
        Assert.assertEquals((long)3L, (long)grid.getSelectedDataRowCount());
        Assert.assertEquals((long)1L, (long)grid.getSelectedDataRowIndex());
        Assert.assertArrayEquals((int[])GridTest.asArray(1, 2, 3), (int[])grid.getSelectedDataRowIndexes());
        Assert.assertEquals((long)2L, (long)listener.count);
    }

    static int[] asArray(int ... array) {
        return array;
    }

    private static class MySelectionListener
    implements GridSelectionModel.Listener {
        int count;

        private MySelectionListener() {
        }

        public void gridSelectionChanged(GridSelectionModel.Event event) {
            ++this.count;
        }
    }
}

