/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing;

import com.bc.ceres.swing.ActionLabel;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JOptionPane;

public class UriLabel
extends ActionLabel {
    private URI uri;

    public UriLabel() {
        this((String)null, (URI)null);
    }

    public UriLabel(URI uri) {
        this(null, uri);
    }

    public UriLabel(String text, URI uri) {
        super(text);
        this.setUri(uri);
        this.addActionListener(new ActionHandler());
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        URI oldUri = this.uri;
        if (oldUri != uri || oldUri != null && !oldUri.equals(uri)) {
            this.uri = uri;
            if (uri != null && (this.getText() == null || this.getText().length() == 0)) {
                this.setText(uri.toString());
            }
            this.firePropertyChange("uri", oldUri, uri);
        }
    }

    public void setUri(String uriString) {
        if (uriString != null) {
            try {
                this.setUri(new URI(uriString));
            }
            catch (URISyntaxException uRISyntaxException) {}
        } else {
            this.setUri((URI)null);
        }
    }

    private void browseUri() {
        if (this.getUri() == null) {
            return;
        }
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            try {
                Desktop.getDesktop().browse(this.getUri());
            }
            catch (Throwable e) {
                JOptionPane.showMessageDialog(this, "Failed to open URL:\n" + this.getUri() + ":\n" + e.getMessage(), "Error", 0);
            }
        } else {
            JOptionPane.showMessageDialog(this, "The desktop command 'browse' is not supported.", "Error", 0);
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UriLabel.this.browseUri();
        }
    }
}

