/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.figure.support;

import com.bc.ceres.swing.figure.AbstractHandle;
import com.bc.ceres.swing.figure.Figure;
import com.bc.ceres.swing.figure.FigureStyle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;

public class VertexHandle
extends AbstractHandle {
    private int segmentIndex;

    public VertexHandle(Figure figure, int vertexIndex, FigureStyle normalStyle, FigureStyle selectedStyle) {
        super(figure, normalStyle, selectedStyle);
        this.segmentIndex = vertexIndex;
        this.updateLocation();
        this.setShape(VertexHandle.createHandleShape());
    }

    public int getSegmentIndex() {
        return this.segmentIndex;
    }

    public void setSegmentIndex(int segmentIndex) {
        this.segmentIndex = segmentIndex;
    }

    @Override
    public void updateLocation() {
        double[] segment = this.getFigure().getSegment(this.segmentIndex);
        if (segment != null) {
            this.setLocation(segment[0], segment[1]);
        }
    }

    @Override
    public void move(double dx, double dy) {
        this.setLocation(this.getX() + dx, this.getY() + dy);
        double[] segment = this.getFigure().getSegment(this.segmentIndex);
        if (segment != null) {
            segment[0] = segment[0] + dx;
            segment[1] = segment[1] + dy;
            this.getFigure().setSegment(this.segmentIndex, segment);
        }
    }

    private static Shape createHandleShape() {
        return new Ellipse2D.Double(-4.0, -4.0, 8.0, 8.0);
    }
}

