/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.figure.support;

import com.bc.ceres.grender.Rendering;
import com.bc.ceres.swing.figure.FigureStyle;
import com.bc.ceres.swing.figure.Symbol;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class PointSymbol
implements Symbol {
    private final int type;
    private final double r;
    private final double a;

    public static PointSymbol createPlus(double size) {
        return new PointSymbol(size, 1);
    }

    public static PointSymbol createCross(double size) {
        return new PointSymbol(size, 2);
    }

    public static PointSymbol createStar(double size) {
        return new PointSymbol(size, 3);
    }

    private PointSymbol(double size, int type) {
        this.type = type;
        this.r = 0.5 * size;
        this.a = this.r / Math.sqrt(2.0);
    }

    @Override
    public void draw(Rendering rendering, FigureStyle style) {
        rendering.getGraphics().setStroke(style.getStroke());
        rendering.getGraphics().setPaint(style.getStrokePaint());
        if ((this.type & 1) != 0) {
            rendering.getGraphics().draw(new Line2D.Double(-this.r, 0.0, this.r, 0.0));
            rendering.getGraphics().draw(new Line2D.Double(0.0, -this.r, 0.0, this.r));
        }
        if ((this.type & 2) != 0) {
            rendering.getGraphics().draw(new Line2D.Double(-this.a, -this.a, this.a, this.a));
            rendering.getGraphics().draw(new Line2D.Double(this.a, -this.a, -this.a, this.a));
        }
    }

    @Override
    public boolean isHitBy(double x, double y) {
        return x * x + y * y < this.r * this.r;
    }

    @Override
    public Rectangle2D getBounds() {
        return new Rectangle2D.Double(-this.r, -this.r, 2.0 * this.r, 2.0 * this.r);
    }
}

