/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.update;

import com.bc.ceres.core.CoreException;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.runtime.Dependency;
import com.bc.ceres.core.runtime.Module;
import com.bc.ceres.core.runtime.Version;
import com.bc.ceres.swing.update.ConsistencyChecker;
import com.bc.ceres.swing.update.MissingDependencyInfo;
import com.bc.ceres.swing.update.ModuleItem;
import com.bc.ceres.swing.update.ModuleManager;
import com.bc.ceres.swing.update.TestHelpers;
import java.text.MessageFormat;
import junit.framework.TestCase;

public class ConsistencyCheckerTest
extends TestCase {
    public void testAGoodSetup() throws CoreException {
        String[] installedModuleFileNames = new String[]{"xml/consistency/module-a-1.1.xml", "xml/consistency/module-b-2.3.1.xml"};
        String[] repositoryModuleFileNames = new String[]{"xml/consistency/module-a-1.0.1-SNAPSHOT.xml", "xml/consistency/module-b-2.3.2-needs-a-1.1.xml", "xml/consistency/module-c-1.0-needs-b-2.3.2.xml"};
        ModuleManager moduleManager = TestHelpers.createModuleManager(installedModuleFileNames, repositoryModuleFileNames);
        moduleManager.synchronizeWithRepository(ProgressMonitor.NULL);
        ConsistencyCheckerTest.assertEquals((int)2, (int)moduleManager.getInstalledModuleItems().length);
        ConsistencyCheckerTest.assertEquals((int)1, (int)moduleManager.getUpdatableModuleItems().length);
        ConsistencyCheckerTest.assertEquals((int)1, (int)moduleManager.getAvailableModuleItems().length);
        ConsistencyChecker checker = new ConsistencyChecker(moduleManager);
        this.findModuleItem(moduleManager.getAvailableModuleItems(), "module-c").setAction(ModuleItem.Action.INSTALL);
        this.findModuleItem(moduleManager.getUpdatableModuleItems(), "module-b").setAction(ModuleItem.Action.UPDATE);
        ConsistencyCheckerTest.assertTrue((boolean)checker.check());
    }

    public void testWithDependencyToLowerVersionAsPresent() throws CoreException {
        String[] installedModuleFileNames = new String[]{"xml/consistency/module-a-1.0.xml", "xml/consistency/module-b-2.4.xml"};
        String[] repositoryModuleFileNames = new String[]{"xml/consistency/module-a-1.2-needs-b-2.3.2.xml", "xml/consistency/module-c-1.0-needs-b-2.3.2.xml"};
        ModuleManager moduleManager = TestHelpers.createModuleManager(installedModuleFileNames, repositoryModuleFileNames);
        moduleManager.synchronizeWithRepository(ProgressMonitor.NULL);
        ConsistencyCheckerTest.assertEquals((int)2, (int)moduleManager.getInstalledModuleItems().length);
        ConsistencyCheckerTest.assertEquals((int)1, (int)moduleManager.getUpdatableModuleItems().length);
        ConsistencyCheckerTest.assertEquals((int)1, (int)moduleManager.getAvailableModuleItems().length);
        ConsistencyChecker checker = new ConsistencyChecker(moduleManager);
        this.findModuleItem(moduleManager.getAvailableModuleItems(), "module-c").setAction(ModuleItem.Action.INSTALL);
        this.findModuleItem(moduleManager.getUpdatableModuleItems(), "module-a").setAction(ModuleItem.Action.UPDATE);
        ConsistencyCheckerTest.assertTrue((boolean)checker.check());
    }

    public void testWithMissingOptionalDependencies() throws CoreException {
        String[] installedModuleFileNames = new String[]{"xml/consistency/module-a-1.0.xml", "xml/consistency/module-b-2.3.1.xml"};
        String[] repositoryModuleFileNames = new String[]{"xml/consistency/module-b-2.3.2-needs-a-1.1-optional.xml", "xml/consistency/module-c-1.0-needs-b-2.3.2.xml"};
        ModuleManager moduleManager = TestHelpers.createModuleManager(installedModuleFileNames, repositoryModuleFileNames);
        moduleManager.synchronizeWithRepository(ProgressMonitor.NULL);
        ConsistencyCheckerTest.assertEquals((int)2, (int)moduleManager.getInstalledModuleItems().length);
        ConsistencyCheckerTest.assertEquals((int)1, (int)moduleManager.getUpdatableModuleItems().length);
        ConsistencyCheckerTest.assertEquals((int)1, (int)moduleManager.getAvailableModuleItems().length);
        ConsistencyChecker checker = new ConsistencyChecker(moduleManager);
        this.findModuleItem(moduleManager.getUpdatableModuleItems(), "module-b").setAction(ModuleItem.Action.UPDATE);
        ConsistencyCheckerTest.assertTrue((boolean)checker.check());
        this.findModuleItem(moduleManager.getAvailableModuleItems(), "module-c").setAction(ModuleItem.Action.INSTALL);
        ConsistencyCheckerTest.assertTrue((boolean)checker.check());
    }

    public void testUninstall() throws CoreException {
        String[] installedModuleFileNames = new String[]{"xml/consistency/module-a-1.2-needs-b-2.3.2.xml", "xml/consistency/module-c-1.0-needs-b-2.3.2.xml", "xml/consistency/module-b-2.3.2.xml"};
        ModuleManager moduleManager = TestHelpers.createModuleManager(installedModuleFileNames, new String[0]);
        moduleManager.synchronizeWithRepository(ProgressMonitor.NULL);
        ConsistencyCheckerTest.assertEquals((int)3, (int)moduleManager.getInstalledModuleItems().length);
        ConsistencyCheckerTest.assertEquals((int)0, (int)moduleManager.getUpdatableModuleItems().length);
        ConsistencyCheckerTest.assertEquals((int)0, (int)moduleManager.getAvailableModuleItems().length);
        ConsistencyChecker checker = new ConsistencyChecker(moduleManager);
        this.findModuleItem(moduleManager.getInstalledModuleItems(), "module-b").setAction(ModuleItem.Action.UNINSTALL);
        ConsistencyCheckerTest.assertFalse((boolean)checker.check());
        this.findModuleItem(moduleManager.getInstalledModuleItems(), "module-a").setAction(ModuleItem.Action.UNINSTALL);
        this.findModuleItem(moduleManager.getInstalledModuleItems(), "module-c").setAction(ModuleItem.Action.UNINSTALL);
        ConsistencyCheckerTest.assertTrue((boolean)checker.check());
    }

    public void testWithMissingDependencies() throws CoreException {
        String[] installedModuleFileNames = new String[]{"xml/consistency/module-a-1.0.xml", "xml/consistency/module-b-2.3.1.xml"};
        String[] repositoryModuleFileNames = new String[]{"xml/consistency/module-a-1.0.1-SNAPSHOT.xml", "xml/consistency/module-b-2.3.2-needs-a-1.1.xml", "xml/consistency/module-c-1.0-needs-b-2.3.2.xml"};
        ModuleManager moduleManager = TestHelpers.createModuleManager(installedModuleFileNames, repositoryModuleFileNames);
        moduleManager.synchronizeWithRepository(ProgressMonitor.NULL);
        ConsistencyCheckerTest.assertEquals((int)2, (int)moduleManager.getInstalledModuleItems().length);
        ConsistencyCheckerTest.assertEquals((int)2, (int)moduleManager.getUpdatableModuleItems().length);
        ConsistencyCheckerTest.assertEquals((int)1, (int)moduleManager.getAvailableModuleItems().length);
        ConsistencyChecker checker = new ConsistencyChecker(moduleManager);
        this.findModuleItem(moduleManager.getAvailableModuleItems(), "module-c").setAction(ModuleItem.Action.INSTALL);
        ConsistencyCheckerTest.assertFalse((boolean)checker.check());
        this.assertMissingDependency(checker, "module-b", "2.3.2", "module-c", "1.0");
        this.findModuleItem(moduleManager.getUpdatableModuleItems(), "module-b").setAction(ModuleItem.Action.UPDATE);
        ConsistencyCheckerTest.assertFalse((boolean)checker.check());
        this.assertMissingDependency(checker, "module-a", "1.1", "module-b", "2.3.2");
    }

    private void assertMissingDependency(ConsistencyChecker checker, String dependencyName, String dependencyVersion, String declaredByName, String declaredByVersion) {
        Module[] neededbyModules;
        MissingDependencyInfo dependencyInfo = this.findDependency(checker.getMissingDependencies(), dependencyName, dependencyVersion);
        if (dependencyInfo == null) {
            String message = MessageFormat.format("Missing dependency to {0}-{1} by {2}-{3} not detected", dependencyName, dependencyVersion, declaredByName, declaredByVersion);
            ConsistencyCheckerTest.fail((String)message);
        }
        if (this.findModule(neededbyModules = dependencyInfo.getDependentModules(), declaredByName, declaredByVersion) == null) {
            String message = MessageFormat.format("Missing dependency to {0}-{1} is not declared by {2}-{3}", dependencyName, dependencyVersion, declaredByName, declaredByVersion);
            ConsistencyCheckerTest.fail((String)message);
        }
    }

    private MissingDependencyInfo findDependency(MissingDependencyInfo[] missingDependencies, String moduleName, String version) {
        for (MissingDependencyInfo missingDependency : missingDependencies) {
            Dependency dependency = missingDependency.getDependency();
            if (!dependency.getModuleSymbolicName().equals(moduleName) || !dependency.getVersion().equals(version)) continue;
            return missingDependency;
        }
        return null;
    }

    private ModuleItem findModuleItem(ModuleItem[] items, String symbolicName) {
        for (ModuleItem item : items) {
            if (!item.getModule().getSymbolicName().equals(symbolicName)) continue;
            return item;
        }
        return null;
    }

    private Module findModule(Module[] modules, String symbolicName, String version) {
        for (Module module : modules) {
            if (!module.getSymbolicName().equals(symbolicName) || !module.getVersion().equals((Object)Version.parseVersion((String)version))) continue;
            return module;
        }
        return null;
    }
}

