/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.figure.support;

import com.bc.ceres.swing.figure.FigureStyle;
import com.bc.ceres.swing.figure.Symbol;
import com.bc.ceres.swing.figure.support.DefaultFigureStyle;
import com.bc.ceres.swing.figure.support.ImageSymbol;
import com.bc.ceres.swing.figure.support.NamedSymbol;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import org.junit.Assert;
import org.junit.Test;

public class DefaultFigureStyleTest {
    @Test
    public void testDefaultConstructor() {
        DefaultFigureStyle style = new DefaultFigureStyle();
        Assert.assertEquals((Object)"", (Object)style.getName());
        Assert.assertEquals((Object)Color.BLACK, (Object)style.getFillColor());
        Assert.assertEquals(null, (Object)style.getStrokeColor());
        Assert.assertNotNull((Object)style.getStroke());
        Assert.assertNull((Object)style.getSymbol());
    }

    @Test
    public void testConstructorWithName() {
        DefaultFigureStyle style = new DefaultFigureStyle("X");
        Assert.assertEquals((Object)"X", (Object)style.getName());
        Assert.assertEquals((Object)Color.BLACK, (Object)style.getFillColor());
        Assert.assertEquals(null, (Object)style.getStrokeColor());
        Assert.assertNotNull((Object)style.getStroke());
        Assert.assertNull((Object)style.getSymbol());
    }

    @Test
    public void testImageSymbolFromName() {
        DefaultFigureStyle style = new DefaultFigureStyle();
        Assert.assertNull((Object)style.getSymbol());
        style.setSymbolName("pin");
        Assert.assertNotNull((Object)style.getSymbol());
    }

    @Test
    public void testImageSymbolFromResource() {
        DefaultFigureStyle style = new DefaultFigureStyle();
        Assert.assertNull((Object)style.getSymbol());
        style.setSymbolImagePath("/com/bc/ceres/swing/figure/support/TestSymbolIcon.png");
        Assert.assertNotNull((Object)style.getSymbol());
    }

    @Test
    public void testPolygonStyle() {
        DefaultFigureStyle style = DefaultFigureStyle.createPolygonStyle((Paint)Color.RED);
        Assert.assertEquals((Object)Color.RED, (Object)style.getFillColor());
        Assert.assertEquals(null, (Object)style.getStrokeColor());
        Assert.assertEquals((double)0.0, (double)style.getStrokeWidth(), (double)1.0E-10);
        Assert.assertNotNull((Object)style.getStroke());
        style = DefaultFigureStyle.createPolygonStyle((Paint)Color.RED, (Paint)Color.BLUE);
        Assert.assertEquals((Object)Color.RED, (Object)style.getFillColor());
        Assert.assertEquals((Object)Color.BLUE, (Object)style.getStrokeColor());
        Assert.assertNotNull((Object)style.getStroke());
    }

    @Test
    public void testCss() {
        this.testToPointCss("symbol-image:TestSymbolIcon.png; symbol-ref-x:2.0; symbol-ref-y:6.0", DefaultFigureStyle.createPointStyle((Symbol)ImageSymbol.createIcon((String)"TestSymbolIcon.png", (double)2.0, (double)6.0)));
        this.testToPointCss("stroke:#ffc800; stroke-width:2.5; symbol:star", DefaultFigureStyle.createPointStyle((Symbol)NamedSymbol.STAR, (Paint)Color.ORANGE, (Stroke)new BasicStroke(2.5f)));
        this.testToPointCss("fill:#00ff00; stroke:#ffc800; stroke-width:2.5; symbol:pin", DefaultFigureStyle.createPointStyle((Symbol)NamedSymbol.PIN, (Paint)Color.GREEN, (Paint)Color.ORANGE, (Stroke)new BasicStroke(2.5f)));
        this.testToLineCss("stroke:#0000ff; stroke-width:5.0", DefaultFigureStyle.createLineStyle((Paint)Color.BLUE, (Stroke)new BasicStroke(5.0f)));
        this.testToLineCss("stroke:#0a0b0c; stroke-opacity:0.05; stroke-width:1.0", DefaultFigureStyle.createLineStyle((Paint)new Color(10, 11, 12, 13), (Stroke)new BasicStroke(1.0f)));
        this.testToPolygonCss("fill:#ff0000; stroke:#0000ff; stroke-width:5.0", (FigureStyle)DefaultFigureStyle.createPolygonStyle((Paint)Color.RED, (Paint)Color.BLUE, (Stroke)new BasicStroke(5.0f)));
        this.testToPolygonCss("fill:#3f4a0d; stroke:#aabbff", (FigureStyle)DefaultFigureStyle.createPolygonStyle((Paint)Color.decode("0x3f4a0d"), (Paint)Color.decode("0xaabbff")));
        this.testToPolygonCss("fill:#0c1722; fill-opacity:0.5", (FigureStyle)DefaultFigureStyle.createPolygonStyle((Paint)new Color(12, 23, 34, 128)));
        this.testToPolygonCss("fill:#0c1722; fill-opacity:0.5; stroke:#646464; stroke-opacity:0.38", (FigureStyle)DefaultFigureStyle.createPolygonStyle((Paint)new Color(12, 23, 34, 127), (Paint)new Color(100, 100, 100, 98)));
    }

    @Test
    public void testEquals() {
        FigureStyle oneStyle = DefaultFigureStyle.createPointStyle((Symbol)ImageSymbol.createIcon((String)"TestSymbolIcon.png", (double)2.0, (double)6.0));
        FigureStyle sameStyle = DefaultFigureStyle.createPointStyle((Symbol)ImageSymbol.createIcon((String)"TestSymbolIcon.png", (double)2.0, (double)6.0));
        FigureStyle otherStyle = DefaultFigureStyle.createPointStyle((Symbol)NamedSymbol.STAR, (Paint)Color.ORANGE, (Stroke)new BasicStroke(2.5f));
        FigureStyle sameOtherStyle = DefaultFigureStyle.createPointStyle((Symbol)NamedSymbol.STAR, (Paint)Color.ORANGE, (Stroke)new BasicStroke(2.5f));
        Assert.assertEquals((Object)true, (Object)oneStyle.equals(oneStyle));
        Assert.assertEquals((Object)true, (Object)oneStyle.equals(sameStyle));
        Assert.assertEquals((Object)false, (Object)oneStyle.equals(otherStyle));
        Assert.assertEquals((Object)false, (Object)oneStyle.equals(sameOtherStyle));
        Assert.assertEquals((Object)true, (Object)otherStyle.equals(sameOtherStyle));
    }

    private void testToPointCss(String expectedCss, FigureStyle style) {
        String css = style.toCssString();
        Assert.assertEquals((Object)expectedCss, (Object)css);
        this.testFromPointCss(style, css);
    }

    private void testFromPointCss(FigureStyle expectedStyle, String css) {
        DefaultFigureStyle style = new DefaultFigureStyle();
        style.fromCssString(css);
        Assert.assertEquals((Object)expectedStyle.getSymbolName(), (Object)style.getSymbolName());
        Assert.assertEquals((Object)expectedStyle.getSymbolImagePath(), (Object)style.getSymbolImagePath());
        Assert.assertEquals((double)expectedStyle.getSymbolRefX(), (double)style.getSymbolRefX(), (double)1.0E-10);
        Assert.assertEquals((double)expectedStyle.getSymbolRefY(), (double)style.getSymbolRefY(), (double)1.0E-10);
    }

    private void testToLineCss(String expectedCss, FigureStyle style) {
        String css = style.toCssString();
        Assert.assertEquals((Object)expectedCss, (Object)css);
        this.testFromLineCss(style, css);
    }

    private void testFromLineCss(FigureStyle expectedStyle, String css) {
        DefaultFigureStyle style = new DefaultFigureStyle();
        style.fromCssString(css);
        Assert.assertEquals((double)expectedStyle.getStrokeOpacity(), (double)style.getStrokeOpacity(), (double)1.0E-10);
        Assert.assertEquals((double)expectedStyle.getStrokeWidth(), (double)style.getStrokeWidth(), (double)1.0E-10);
        Assert.assertEquals((Object)expectedStyle.getStrokeColor(), (Object)style.getStrokeColor());
    }

    private void testToPolygonCss(String expectedCss, FigureStyle style) {
        String css = style.toCssString();
        Assert.assertEquals((Object)expectedCss, (Object)css);
        this.testFromPolygonCss(style, css);
    }

    private void testFromPolygonCss(FigureStyle expectedStyle, String css) {
        DefaultFigureStyle style = new DefaultFigureStyle();
        style.fromCssString(css);
        Assert.assertEquals((Object)expectedStyle.getFillColor(), (Object)style.getFillColor());
        Assert.assertEquals((double)expectedStyle.getFillOpacity(), (double)style.getFillOpacity(), (double)1.0E-10);
        Assert.assertEquals((Object)expectedStyle.getStrokeColor(), (Object)style.getStrokeColor());
        Assert.assertEquals((double)expectedStyle.getStrokeOpacity(), (double)style.getStrokeOpacity(), (double)1.0E-10);
        Assert.assertEquals((double)expectedStyle.getStrokeWidth(), (double)style.getStrokeWidth(), (double)1.0E-10);
    }
}

