/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.figure.support;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.swing.figure.support.CssColorConverter;
import java.awt.Color;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CssColorConverterTest {
    private CssColorConverter colorConverter;

    @Before
    public void setUp() throws Exception {
        this.colorConverter = new CssColorConverter();
    }

    @Test
    public void testGetValueType() throws Exception {
        Assert.assertEquals(Color.class, (Object)this.colorConverter.getValueType());
    }

    @Test
    public void testParseHexString() throws Exception {
        Assert.assertEquals((Object)Color.decode("0x12f45a"), (Object)this.colorConverter.parse("#12F45a"));
        Assert.assertEquals((Object)Color.GREEN, (Object)this.colorConverter.parse("00ff00"));
        Assert.assertEquals((Object)"#12f45a", (Object)this.colorConverter.format(Color.decode("0x12f45a")));
        Assert.assertEquals((Object)"#00ff00", (Object)this.colorConverter.format(Color.GREEN));
    }

    @Test
    public void testParseCommaSeparatedNumbersString() throws ConversionException {
        Assert.assertEquals((Object)Color.WHITE, (Object)this.colorConverter.parse("255,255,255"));
        Assert.assertEquals((Object)Color.BLACK, (Object)this.colorConverter.parse("0,0,0"));
        Assert.assertEquals((Object)Color.decode("0x356463"), (Object)this.colorConverter.parse("53,100,99"));
    }

    @Test(expected=ConversionException.class)
    public void testParseFaultyExpression_1() throws ConversionException {
        this.colorConverter.parse("x");
    }

    @Test(expected=ConversionException.class)
    public void testParseFaultyExpression_2() throws ConversionException {
        this.colorConverter.parse("white");
    }
}

