/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.figure;

import com.bc.ceres.swing.figure.AbstractInteractor;
import com.bc.ceres.swing.figure.AbstractInteractorInterceptor;
import com.bc.ceres.swing.figure.FigureCollection;
import com.bc.ceres.swing.figure.FigureFactory;
import com.bc.ceres.swing.figure.Interactor;
import com.bc.ceres.swing.figure.InteractorListener;
import com.bc.ceres.swing.figure.support.DefaultFigureCollection;
import com.bc.ceres.swing.figure.support.DefaultFigureFactory;
import com.bc.ceres.swing.figure.support.FigureEditorPanel;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JMenu;
import junit.framework.TestCase;

public class AbstractInteractorTest
extends TestCase {
    public void testListeners() {
        FigureEditorPanel figureEditorPanel = new FigureEditorPanel(null, (FigureCollection)new DefaultFigureCollection(), (FigureFactory)new DefaultFigureFactory());
        AbstractInteractor interactor = new AbstractInteractor(){};
        MyInteractorListener listener = new MyInteractorListener();
        interactor.addListener((InteractorListener)listener);
        MouseEvent event = new MouseEvent((Component)figureEditorPanel, 0, 0L, 0, 0, 0, 1, false, 0);
        interactor.activate();
        AbstractInteractorTest.assertEquals((String)"a?;a;", (String)listener.trace);
        interactor.deactivate();
        AbstractInteractorTest.assertEquals((String)"a?;a;d;", (String)listener.trace);
        interactor.activate();
        AbstractInteractorTest.assertEquals((String)"a?;a;d;a?;a;", (String)listener.trace);
        interactor.cancelInteraction((InputEvent)event);
        AbstractInteractorTest.assertEquals((String)"a?;a;d;a?;a;c;", (String)listener.trace);
        interactor.activate();
        AbstractInteractorTest.assertEquals((String)"a?;a;d;a?;a;c;", (String)listener.trace);
        interactor.startInteraction((InputEvent)event);
        AbstractInteractorTest.assertEquals((String)"a?;a;d;a?;a;c;s?;s;", (String)listener.trace);
        interactor.stopInteraction((InputEvent)event);
        AbstractInteractorTest.assertEquals((String)"a?;a;d;a?;a;c;s?;s;e;", (String)listener.trace);
        interactor.deactivate();
        AbstractInteractorTest.assertEquals((String)"a?;a;d;a?;a;c;s?;s;e;d;", (String)listener.trace);
    }

    public void testEscKeyPressedInvokesCancel() {
        AbstractInteractor interaction = new AbstractInteractor(){};
        MyInteractorListener listener = new MyInteractorListener();
        interaction.addListener((InteractorListener)listener);
        JMenu source = new JMenu();
        interaction.keyTyped(new KeyEvent(source, 0, 0L, 0, 32, ' '));
        AbstractInteractorTest.assertEquals((String)"", (String)listener.trace);
        interaction.keyTyped(new KeyEvent(source, 0, 0L, 0, 27, '\u001b'));
        AbstractInteractorTest.assertEquals((String)"c;", (String)listener.trace);
        interaction.keyTyped(new KeyEvent(source, 0, 0L, 0, 65, 'A'));
        AbstractInteractorTest.assertEquals((String)"c;", (String)listener.trace);
    }

    private static class MyInteractorListener
    extends AbstractInteractorInterceptor {
        String trace = "";

        private MyInteractorListener() {
        }

        public boolean interactorAboutToActivate(Interactor interactor) {
            this.trace = this.trace + "a?;";
            return true;
        }

        public boolean interactionAboutToStart(Interactor interactor, InputEvent inputEvent) {
            this.trace = this.trace + "s?;";
            return true;
        }

        public void interactorActivated(Interactor interactor) {
            this.trace = this.trace + "a;";
        }

        public void interactorDeactivated(Interactor interactor) {
            this.trace = this.trace + "d;";
        }

        public void interactionStarted(Interactor interactor, InputEvent event) {
            this.trace = this.trace + "s;";
        }

        public void interactionStopped(Interactor interactor, InputEvent inputEvent) {
            this.trace = this.trace + "e;";
        }

        public void interactionCancelled(Interactor interactor, InputEvent inputEvent) {
            this.trace = this.trace + "c;";
        }
    }
}

