/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.binding.internal;

import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValueSet;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.internal.SingleSelectionEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import junit.framework.TestCase;

public class SingleSelectionEditorTest
extends TestCase {
    public void testIsApplicable() throws Exception {
        SingleSelectionEditor singleSelEditor = new SingleSelectionEditor();
        ValueSet valueSet = new ValueSet((Object[])new Double[]{42.0, 84.0});
        PropertyDescriptor doubleArrayDescriptor = new PropertyDescriptor("test", Double.class);
        doubleArrayDescriptor.setValueSet(valueSet);
        SingleSelectionEditorTest.assertTrue((boolean)singleSelEditor.isValidFor(doubleArrayDescriptor));
        doubleArrayDescriptor = new PropertyDescriptor("test", Double[].class);
        doubleArrayDescriptor.setValueSet(valueSet);
        SingleSelectionEditorTest.assertFalse((boolean)singleSelEditor.isValidFor(doubleArrayDescriptor));
        doubleArrayDescriptor = new PropertyDescriptor("test", Double.class);
        SingleSelectionEditorTest.assertFalse((boolean)singleSelEditor.isValidFor(doubleArrayDescriptor));
    }

    public void testCreateEditorComponent() throws Exception {
        SingleSelectionEditor singleSelEditor = new SingleSelectionEditor();
        PropertyContainer propertyContainer = PropertyContainer.createValueBacked(V.class);
        BindingContext bindingContext = new BindingContext((PropertySet)propertyContainer);
        PropertyDescriptor propertyDescriptor = propertyContainer.getDescriptor("value");
        ValueSet valueSet = new ValueSet((Object[])new Double[]{42.0, 84.0});
        propertyDescriptor.setValueSet(valueSet);
        SingleSelectionEditorTest.assertSame(Double.class, (Object)propertyDescriptor.getType());
        SingleSelectionEditorTest.assertTrue((boolean)singleSelEditor.isValidFor(propertyDescriptor));
        JComponent editorComponent = singleSelEditor.createEditorComponent(propertyDescriptor, bindingContext);
        SingleSelectionEditorTest.assertNotNull((Object)editorComponent);
        SingleSelectionEditorTest.assertSame(JComboBox.class, editorComponent.getClass());
        JComponent[] components = bindingContext.getBinding("value").getComponents();
        SingleSelectionEditorTest.assertEquals((int)1, (int)components.length);
        SingleSelectionEditorTest.assertSame(JComboBox.class, components[0].getClass());
    }

    private static class V {
        Double value;

        private V() {
        }
    }
}

