/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.binding.internal;

import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValueRange;
import com.bc.ceres.binding.ValueSet;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.internal.NumericEditor;
import javax.swing.JComponent;
import javax.swing.JTextField;
import junit.framework.TestCase;

public class NumericEditorTest
extends TestCase {
    public void testIsApplicable() throws Exception {
        NumericEditor numericEditor = new NumericEditor();
        PropertyDescriptor doubleDescriptor = new PropertyDescriptor("test", Double.class);
        NumericEditorTest.assertTrue((boolean)numericEditor.isValidFor(doubleDescriptor));
        doubleDescriptor = new PropertyDescriptor("test", Double.TYPE);
        NumericEditorTest.assertTrue((boolean)numericEditor.isValidFor(doubleDescriptor));
        doubleDescriptor = new PropertyDescriptor("test", Double.TYPE);
        ValueRange valueRange = ValueRange.parseValueRange((String)"[2.0,*)");
        doubleDescriptor.setValueRange(valueRange);
        NumericEditorTest.assertTrue((boolean)numericEditor.isValidFor(doubleDescriptor));
        doubleDescriptor = new PropertyDescriptor("test", Double.TYPE);
        valueRange = ValueRange.parseValueRange((String)"[*,4.6)");
        doubleDescriptor.setValueRange(valueRange);
        NumericEditorTest.assertTrue((boolean)numericEditor.isValidFor(doubleDescriptor));
        doubleDescriptor = new PropertyDescriptor("test", Double.TYPE);
        valueRange = ValueRange.parseValueRange((String)"[2.0,4.6]");
        doubleDescriptor.setValueRange(valueRange);
        NumericEditorTest.assertTrue((boolean)numericEditor.isValidFor(doubleDescriptor));
        PropertyDescriptor valueSetDescriptor = new PropertyDescriptor("test", Integer.TYPE);
        valueSetDescriptor.setValueSet(new ValueSet((Object[])new Integer[]{50, 150}));
        NumericEditorTest.assertFalse((boolean)numericEditor.isValidFor(valueSetDescriptor));
        PropertyDescriptor booleanDescriptor = new PropertyDescriptor("test", Boolean.TYPE);
        NumericEditorTest.assertFalse((boolean)numericEditor.isValidFor(booleanDescriptor));
    }

    public void testCreateEditorComponent() throws Exception {
        NumericEditor numericEditor = new NumericEditor();
        PropertyContainer propertyContainer = PropertyContainer.createValueBacked(V.class);
        BindingContext bindingContext = new BindingContext((PropertySet)propertyContainer);
        PropertyDescriptor propertyDescriptor = propertyContainer.getDescriptor("value");
        NumericEditorTest.assertSame(Double.TYPE, (Object)propertyDescriptor.getType());
        NumericEditorTest.assertTrue((boolean)numericEditor.isValidFor(propertyDescriptor));
        JComponent editorComponent = numericEditor.createEditorComponent(propertyDescriptor, bindingContext);
        NumericEditorTest.assertNotNull((Object)editorComponent);
        NumericEditorTest.assertSame(JTextField.class, editorComponent.getClass());
        JComponent[] components = bindingContext.getBinding("value").getComponents();
        NumericEditorTest.assertEquals((int)1, (int)components.length);
        NumericEditorTest.assertSame(JTextField.class, components[0].getClass());
    }

    private static class V {
        double value;

        private V() {
        }
    }
}

