/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.binding.internal;

import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.internal.CheckBoxEditor;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import junit.framework.TestCase;

public class CheckBoxEditorTest
extends TestCase {
    public void testIsApplicable() throws Exception {
        CheckBoxEditor checkBoxEditor = new CheckBoxEditor();
        PropertyDescriptor booleanDescriptor = new PropertyDescriptor("test", Boolean.TYPE);
        CheckBoxEditorTest.assertTrue((boolean)checkBoxEditor.isValidFor(booleanDescriptor));
        PropertyDescriptor doubleDescriptor = new PropertyDescriptor("test", Double.TYPE);
        CheckBoxEditorTest.assertFalse((boolean)checkBoxEditor.isValidFor(doubleDescriptor));
    }

    public void testCreateEditorComponent() throws Exception {
        CheckBoxEditor checkBoxEditor = new CheckBoxEditor();
        PropertyContainer propertyContainer = PropertyContainer.createValueBacked(V.class);
        BindingContext bindingContext = new BindingContext((PropertySet)propertyContainer);
        PropertyDescriptor propertyDescriptor = propertyContainer.getDescriptor("b");
        CheckBoxEditorTest.assertSame(Boolean.TYPE, (Object)propertyDescriptor.getType());
        CheckBoxEditorTest.assertTrue((boolean)checkBoxEditor.isValidFor(propertyDescriptor));
        JComponent editorComponent = checkBoxEditor.createEditorComponent(propertyDescriptor, bindingContext);
        CheckBoxEditorTest.assertNotNull((Object)editorComponent);
        CheckBoxEditorTest.assertSame(JCheckBox.class, editorComponent.getClass());
        JComponent[] components = bindingContext.getBinding("b").getComponents();
        CheckBoxEditorTest.assertEquals((int)1, (int)components.length);
        CheckBoxEditorTest.assertSame(JCheckBox.class, components[0].getClass());
    }

    private static class V {
        boolean b;

        private V() {
        }
    }
}

