/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.actions;

import com.bc.ceres.swing.actions.DeleteAction;
import com.bc.ceres.swing.actions.PasteAction;
import com.bc.ceres.swing.actions.TestSelectionContext;
import com.bc.ceres.swing.selection.Selection;
import com.bc.ceres.swing.selection.SelectionContext;
import com.bc.ceres.swing.selection.SelectionManager;
import com.bc.ceres.swing.selection.support.DefaultSelection;
import com.bc.ceres.swing.selection.support.DefaultSelectionManager;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import javax.swing.Action;
import junit.framework.TestCase;

public class SelectionActionTest
extends TestCase {
    public void testDeleteAction() {
        DefaultSelectionManager selectionManager = new DefaultSelectionManager();
        TestSelectionContext context = new TestSelectionContext();
        selectionManager.setSelectionContext((SelectionContext)context);
        SelectionActionTest.assertEquals((boolean)true, (boolean)selectionManager.getSelection().isEmpty());
        DeleteAction action = new DeleteAction((SelectionManager)selectionManager);
        SelectionActionTest.assertEquals((boolean)false, (boolean)action.isEnabled());
        SelectionActionTest.setSelectionAndTestActionState((Selection)new DefaultSelection(new Object[]{"B"}), true, (Action)action, (SelectionContext)context);
        SelectionActionTest.setSelectionAndTestActionState((Selection)new DefaultSelection(new Object[0]), false, (Action)action, (SelectionContext)context);
        SelectionActionTest.setSelectionAndTestActionState((Selection)new DefaultSelection(new Object[]{"B"}), true, (Action)action, (SelectionContext)context);
        SelectionActionTest.setSelectionAndTestActionState((Selection)new DefaultSelection(new Object[]{"Z"}), false, (Action)action, (SelectionContext)context);
        SelectionActionTest.setSelectionAndTestActionState((Selection)new DefaultSelection(new Object[]{"B"}), true, (Action)action, (SelectionContext)context);
        action.actionPerformed(null);
        SelectionActionTest.assertEquals((boolean)true, (boolean)context.items.contains("A"));
        SelectionActionTest.assertEquals((boolean)false, (boolean)context.items.contains("B"));
        SelectionActionTest.assertEquals((boolean)true, (boolean)context.items.contains("C"));
        SelectionActionTest.assertEquals((boolean)true, (boolean)context.getSelection().isEmpty());
        SelectionActionTest.assertEquals((boolean)false, (boolean)action.isEnabled());
    }

    public void testPasteAction() {
        DefaultSelectionManager selectionManager = new DefaultSelectionManager();
        TestSelectionContext context = new TestSelectionContext();
        selectionManager.setSelectionContext((SelectionContext)context);
        SelectionActionTest.assertEquals((boolean)true, (boolean)selectionManager.getSelection().isEmpty());
        DefaultSelection selectionZ = new DefaultSelection((Object[])new String[]{"Z"});
        StringSelection contents = new StringSelection((String)selectionZ.getSelectedValue());
        selectionManager.getClipboard().setContents(contents, (ClipboardOwner)selectionZ);
        SelectionActionTest.assertEquals((boolean)true, (boolean)selectionManager.getClipboard().getContents(null).isDataFlavorSupported(DataFlavor.stringFlavor));
        PasteAction action = new PasteAction((SelectionManager)selectionManager);
        SelectionActionTest.assertEquals((boolean)true, (boolean)action.isEnabled());
        SelectionActionTest.setSelectionAndTestActionState((Selection)new DefaultSelection((Object[])new String[]{"B"}), true, (Action)action, (SelectionContext)context);
        SelectionActionTest.setSelectionAndTestActionState((Selection)new DefaultSelection((Object[])new String[0]), true, (Action)action, (SelectionContext)context);
        SelectionActionTest.setSelectionAndTestActionState((Selection)new DefaultSelection((Object[])new String[]{"Z"}), true, (Action)action, (SelectionContext)context);
        action.actionPerformed(null);
        SelectionActionTest.assertEquals((boolean)true, (boolean)context.items.contains("A"));
        SelectionActionTest.assertEquals((boolean)true, (boolean)context.items.contains("B"));
        SelectionActionTest.assertEquals((boolean)true, (boolean)context.items.contains("C"));
        SelectionActionTest.assertEquals((boolean)true, (boolean)context.items.contains("Z"));
        SelectionActionTest.assertEquals((boolean)true, (boolean)action.isEnabled());
    }

    private static void setSelectionAndTestActionState(Selection selection, boolean expectedState, Action action, SelectionContext context) {
        context.setSelection(selection);
        SelectionActionTest.assertEquals((boolean)expectedState, (boolean)action.isEnabled());
    }
}

