/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing;

import com.bc.ceres.swing.TreeCellExtender;
import java.awt.event.MouseListener;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import junit.framework.TestCase;

public class TreeCellExtenderTest
extends TestCase {
    public void testActiveState() {
        JTree tree = new JTree();
        TreeCellExtender extender = new TreeCellExtender(tree);
        TreeCellExtenderTest.assertSame((Object)tree, (Object)extender.getTree());
        TreeCellExtenderTest.assertEquals((boolean)false, (boolean)extender.isActive());
        MouseListener[] listeners = tree.getMouseListeners();
        TreeCellExtenderTest.assertNotNull((Object)listeners);
        int oldLength = listeners.length;
        extender.setActive(true);
        TreeCellExtenderTest.assertEquals((boolean)true, (boolean)extender.isActive());
        listeners = tree.getMouseListeners();
        int newLength = listeners.length;
        TreeCellExtenderTest.assertEquals((int)(oldLength + 1), (int)newLength);
    }

    public void testEquip() {
        JTree tree = new JTree();
        TreeCellExtender extender = TreeCellExtender.equip((JTree)tree);
        TreeCellExtenderTest.assertNotNull((Object)extender);
        TreeCellExtenderTest.assertSame((Object)tree, (Object)extender.getTree());
        TreeCellExtenderTest.assertEquals((boolean)true, (boolean)extender.isActive());
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame(TreeCellExtender.class.getSimpleName());
        frame.setDefaultCloseOperation(3);
        JTree tree = new JTree(TreeCellExtenderTest.getDefaultTreeModel());
        TreeCellExtender.equip((JTree)tree);
        frame.getContentPane().add(new JScrollPane(tree));
        frame.setSize(200, 200);
        frame.setVisible(true);
    }

    protected static TreeModel getDefaultTreeModel() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("JTree");
        DefaultMutableTreeNode parent = new DefaultMutableTreeNode("colors colors colors colors colors");
        root.add(parent);
        parent.add(new DefaultMutableTreeNode("blue"));
        parent.add(new DefaultMutableTreeNode("violet"));
        parent.add(new DefaultMutableTreeNode("red"));
        parent.add(new DefaultMutableTreeNode("yellow"));
        parent = new DefaultMutableTreeNode("sports sports sports sports sports sports");
        root.add(parent);
        parent.add(new DefaultMutableTreeNode("basketball"));
        parent.add(new DefaultMutableTreeNode("soccer"));
        parent.add(new DefaultMutableTreeNode("football football football football football football"));
        parent.add(new DefaultMutableTreeNode("hockey"));
        parent = new DefaultMutableTreeNode("food");
        root.add(parent);
        parent.add(new DefaultMutableTreeNode("hot dogs"));
        parent.add(new DefaultMutableTreeNode("pizza"));
        parent.add(new DefaultMutableTreeNode("ravioli ravioli ravioli ravioli ravioli ravioli ravioli ravioli ravioli ravioli ravioli ravioli"));
        parent.add(new DefaultMutableTreeNode("bananas"));
        return new DefaultTreeModel(root);
    }
}

