/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.metadata;

import com.bc.ceres.metadata.MetadataResourceEngine;
import com.bc.ceres.metadata.SimpleFileSystem;
import com.bc.ceres.resource.Resource;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Map;
import java.util.SortedMap;
import org.apache.velocity.VelocityContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class MetadataResourceEngineTest {
    private MetadataResourceEngine metadataResourceEngine;
    private SimpleFileSystem ioAccessor;

    @Before
    public void setUp() throws Exception {
        this.ioAccessor = (SimpleFileSystem)Mockito.mock(SimpleFileSystem.class);
        this.metadataResourceEngine = new MetadataResourceEngine(this.ioAccessor);
    }

    @Test
    public void testCreation() throws Exception {
        VelocityContext velocityContext = this.metadataResourceEngine.getVelocityContext();
        Assert.assertNotNull((Object)velocityContext);
        Assert.assertEquals((long)0L, (long)velocityContext.getKeys().length);
    }

    @Ignore
    public void useCaseOverview() throws Exception {
        this.metadataResourceEngine.readResource("metadata", "input/metadata.properties");
        this.metadataResourceEngine.readRelatedResource("source1", "input/MER_L1_1.N1");
        this.metadataResourceEngine.readRelatedResource("source2", "input/MER_L1_2.N1");
        VelocityContext velocityContext = this.metadataResourceEngine.getVelocityContext();
        velocityContext.put("myKey", (Object)"value1");
        velocityContext.put("myOtherKey", (Object)"value2");
        this.metadataResourceEngine.writeRelatedResource("templates/report.xml.vm", "output/MER_L2_1.dim");
        this.metadataResourceEngine.writeRelatedResource("templates/report.txt.vm", "output/MER_L2_1.dim");
    }

    @Test
    public void testWriteTargetMetadata() throws Exception {
        Mockito.when((Object)this.ioAccessor.createReader("templates/metadata.xml.vm")).thenReturn((Object)new StringReader("I would say: ${var1} ${var2}"));
        StringWriter stringWriter = new StringWriter();
        Mockito.when((Object)this.ioAccessor.createWriter("out/MER_L2-metadata.xml")).thenReturn((Object)stringWriter);
        Mockito.when((Object)this.ioAccessor.isFile("out/MER_L2.dim")).thenReturn((Object)true);
        VelocityContext velocityContext = this.metadataResourceEngine.getVelocityContext();
        velocityContext.put("var1", (Object)"Hello");
        velocityContext.put("var2", (Object)"world");
        this.metadataResourceEngine.writeRelatedResource("templates/metadata.xml.vm", "out/MER_L2.dim");
        Assert.assertEquals((Object)"I would say: Hello world", (Object)stringWriter.toString());
        Assert.assertEquals((long)4L, (long)velocityContext.getKeys().length);
        Assert.assertEquals((Object)"metadata.xml.vm", (Object)velocityContext.get("templateName"));
        Assert.assertEquals((Object)"metadata.xml", (Object)velocityContext.get("templateBaseName"));
    }

    @Test
    public void testMetadataAsProperties() throws Exception {
        Mockito.when((Object)this.ioAccessor.createReader("static.properties")).thenReturn((Object)new StringReader("key = sdkfj"));
        VelocityContext velocityContext = this.metadataResourceEngine.getVelocityContext();
        this.metadataResourceEngine.readResource("props", "static.properties");
        Assert.assertEquals((long)1L, (long)velocityContext.getKeys().length);
        Object metadata = velocityContext.get("props");
        Assert.assertTrue((boolean)(metadata instanceof Resource));
        Resource resource = (Resource)metadata;
        Assert.assertFalse((boolean)resource.isXml());
        Assert.assertEquals((Object)"key = sdkfj", (Object)resource.getContent());
        SortedMap map = resource.getMap();
        Assert.assertNotNull((Object)map);
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertEquals((Object)"sdkfj", map.get("key"));
    }

    @Test
    public void testMetadataAsPropertiesWithEvaluation() throws Exception {
        StringReader reader = new StringReader("key = BEAM is ${state}");
        Mockito.when((Object)this.ioAccessor.createReader("evaluation.data")).thenReturn((Object)reader);
        VelocityContext velocityContext = this.metadataResourceEngine.getVelocityContext();
        velocityContext.put("state", (Object)"ok");
        this.metadataResourceEngine.readResource("foo", "evaluation.data");
        Assert.assertEquals((long)2L, (long)velocityContext.getKeys().length);
        Object metadata = velocityContext.get("foo");
        Assert.assertTrue((boolean)(metadata instanceof Resource));
        Resource resource = (Resource)metadata;
        Assert.assertFalse((boolean)resource.isXml());
        Assert.assertEquals((Object)"key = BEAM is ok", (Object)resource.getContent());
        SortedMap map = resource.getMap();
        Assert.assertNotNull((Object)map);
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertEquals((Object)"BEAM is ok", map.get("key"));
        resource = resource.getOrigin();
        Assert.assertFalse((boolean)resource.isXml());
        Assert.assertEquals((Object)"key = BEAM is ${state}", (Object)resource.getContent());
        map = resource.getMap();
        Assert.assertNotNull((Object)map);
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertEquals((Object)"BEAM is ${state}", map.get("key"));
    }

    @Test
    public void testMetadataAsXML() throws Exception {
        StringReader reader = new StringReader("<?xml>this is XML</xml>");
        Mockito.when((Object)this.ioAccessor.createReader("static.xml")).thenReturn((Object)reader);
        VelocityContext velocityContext = this.metadataResourceEngine.getVelocityContext();
        this.metadataResourceEngine.readResource("myxml", "static.xml");
        Assert.assertEquals((long)1L, (long)velocityContext.getKeys().length);
        Assert.assertNull((Object)velocityContext.get("wrongKey"));
        Object metadata = velocityContext.get("myxml");
        Assert.assertTrue((boolean)(metadata instanceof Resource));
        Resource resource = (Resource)metadata;
        Assert.assertTrue((boolean)resource.isXml());
        Assert.assertEquals((Object)"<?xml>this is XML</xml>", (Object)resource.getContent());
        SortedMap map = resource.getMap();
        Assert.assertNotNull((Object)map);
        Assert.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void testSourceMetadata() throws Exception {
        Mockito.when((Object)this.ioAccessor.createReader("input/MER_L1-report.xml")).thenReturn((Object)new StringReader("<?xml>this is XML</xml>"));
        Mockito.when((Object)this.ioAccessor.createReader("input/MER_L1-meta.txt")).thenReturn((Object)new StringReader("key = BEAM is ${state}"));
        Mockito.when((Object)this.ioAccessor.list("input")).thenReturn((Object)new String[]{"MER_L1-report.xml", "MER_L1-meta.txt", "MER_L1.N1"});
        Mockito.when((Object)this.ioAccessor.isFile(Matchers.anyString())).thenReturn((Object)true);
        this.metadataResourceEngine.readRelatedResource("source1", "input/MER_L1.N1");
        VelocityContext velocityContext = this.metadataResourceEngine.getVelocityContext();
        Assert.assertEquals((long)1L, (long)velocityContext.getKeys().length);
        Assert.assertNotNull((Object)velocityContext.get("sourceMetadata"));
        Object object = velocityContext.get("sourceMetadata");
        Assert.assertTrue((boolean)(object instanceof Map));
        Map map = (Map)object;
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertTrue((boolean)map.containsKey("source1"));
        object = map.get("source1");
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)(object instanceof Map));
        Map resourceMap = (Map)object;
        Assert.assertEquals((long)2L, (long)resourceMap.size());
        Assert.assertTrue((boolean)resourceMap.containsKey("report_xml"));
        Assert.assertTrue((boolean)resourceMap.containsKey("meta_txt"));
        object = resourceMap.get("report_xml");
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)(object instanceof Resource));
        Resource resource = (Resource)object;
        Assert.assertTrue((boolean)resource.isXml());
        Assert.assertEquals((Object)"<?xml>this is XML</xml>", (Object)resource.getContent());
        SortedMap xmlMap = resource.getMap();
        Assert.assertNotNull((Object)xmlMap);
        Assert.assertTrue((boolean)xmlMap.isEmpty());
        object = resourceMap.get("meta_txt");
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)(object instanceof Resource));
        resource = (Resource)object;
        Assert.assertFalse((boolean)resource.isXml());
        Assert.assertEquals((Object)"key = BEAM is ${state}", (Object)resource.getContent());
        SortedMap propertiesMap = resource.getMap();
        Assert.assertNotNull((Object)propertiesMap);
        Assert.assertEquals((long)1L, (long)propertiesMap.size());
        Assert.assertEquals((Object)"BEAM is ${state}", propertiesMap.get("key"));
    }

    @Test
    public void testSourceMetadataWith2ProductsInSameDirectory() throws Exception {
        Mockito.when((Object)this.ioAccessor.createReader("input/MER_L1-report.xml")).thenReturn((Object)new StringReader("<?xml>hello</xml>"));
        Mockito.when((Object)this.ioAccessor.createReader("input/MER_FRS_L1-meta.xml")).thenReturn((Object)new StringReader("world"));
        Mockito.when((Object)this.ioAccessor.list("input")).thenReturn((Object)new String[]{"MER_L1-report.xml", "MER_L1.dim", "MER_L1.data", "MER_FRS_L1-meta.xml", "MER_FRS_L1.N1"});
        Mockito.when((Object)this.ioAccessor.isFile(Matchers.endsWith((String)".data"))).thenReturn((Object)false);
        Mockito.when((Object)this.ioAccessor.isFile(Matchers.anyString())).thenReturn((Object)true);
        this.metadataResourceEngine.readRelatedResource("source1", "input/MER_L1.N1");
        this.metadataResourceEngine.readRelatedResource("source2", "input/MER_FRS_L1.N1");
        VelocityContext velocityContext = this.metadataResourceEngine.getVelocityContext();
        Assert.assertEquals((long)1L, (long)velocityContext.getKeys().length);
        Assert.assertNotNull((Object)velocityContext.get("sourceMetadata"));
        Object object = velocityContext.get("sourceMetadata");
        Assert.assertTrue((boolean)(object instanceof Map));
        Map map = (Map)object;
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertTrue((boolean)map.containsKey("source1"));
        Assert.assertTrue((boolean)map.containsKey("source2"));
        object = map.get("source1");
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)(object instanceof Map));
        Map sourceMap = (Map)object;
        Assert.assertEquals((long)1L, (long)sourceMap.size());
        object = sourceMap.get("report_xml");
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)(object instanceof Resource));
        Resource resource = (Resource)object;
        Assert.assertTrue((boolean)resource.isXml());
        Assert.assertEquals((Object)"input/MER_L1-report.xml", (Object)resource.getPath());
        Assert.assertEquals((Object)"<?xml>hello</xml>", (Object)resource.getContent());
        object = map.get("source2");
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)(object instanceof Map));
        sourceMap = (Map)object;
        Assert.assertEquals((long)1L, (long)sourceMap.size());
        object = sourceMap.get("meta_xml");
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)(object instanceof Resource));
        resource = (Resource)object;
        Assert.assertFalse((boolean)resource.isXml());
        Assert.assertEquals((Object)"input/MER_FRS_L1-meta.xml", (Object)resource.getPath());
        Assert.assertEquals((Object)"world", (Object)resource.getContent());
    }

    @Test
    public void testSourceMetadataWith2Sources() throws Exception {
        Mockito.when((Object)this.ioAccessor.createReader("input1/MER_L1-report.xml")).thenReturn((Object)new StringReader("<?xml>this is XML</xml>"));
        Mockito.when((Object)this.ioAccessor.createReader("input2/MER_FRS_L1-meta.xml")).thenReturn((Object)new StringReader("<?xml>this is XML</xml> <tag>value</tag>"));
        Mockito.when((Object)this.ioAccessor.list("input1")).thenReturn((Object)new String[]{"MER_L1-report.xml", "MER_L1.N1"});
        Mockito.when((Object)this.ioAccessor.list("input2")).thenReturn((Object)new String[]{"MER_FRS_L1-meta.xml", "MER_FRS_L1.N1"});
        Mockito.when((Object)this.ioAccessor.isFile(Matchers.anyString())).thenReturn((Object)true);
        this.metadataResourceEngine.readRelatedResource("source1", "input1/MER_L1.N1");
        this.metadataResourceEngine.readRelatedResource("source2", "input2/MER_FRS_L1.N1");
        VelocityContext velocityContext = this.metadataResourceEngine.getVelocityContext();
        Assert.assertEquals((long)1L, (long)velocityContext.getKeys().length);
        Object object = velocityContext.get("sourceMetadata");
        Assert.assertTrue((boolean)(object instanceof Map));
        Map map = (Map)object;
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertTrue((boolean)map.containsKey("source1"));
        Assert.assertTrue((boolean)map.containsKey("source2"));
        object = map.get("source1");
        Assert.assertTrue((boolean)(object instanceof Map));
        Map sourceMap = (Map)object;
        Assert.assertEquals((long)1L, (long)sourceMap.size());
        Assert.assertTrue((boolean)sourceMap.containsKey("report_xml"));
        object = sourceMap.get("report_xml");
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)(object instanceof Resource));
        Resource resource = (Resource)object;
        Assert.assertTrue((boolean)resource.isXml());
        Assert.assertEquals((Object)"input1/MER_L1-report.xml", (Object)resource.getPath());
        Assert.assertEquals((Object)"<?xml>this is XML</xml>", (Object)resource.getContent());
        object = map.get("source2");
        Assert.assertTrue((boolean)(object instanceof Map));
        sourceMap = (Map)object;
        Assert.assertEquals((long)1L, (long)sourceMap.size());
        Assert.assertTrue((boolean)sourceMap.containsKey("meta_xml"));
        object = sourceMap.get("meta_xml");
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)(object instanceof Resource));
        resource = (Resource)object;
        Assert.assertTrue((boolean)resource.isXml());
        Assert.assertEquals((Object)"input2/MER_FRS_L1-meta.xml", (Object)resource.getPath());
        Assert.assertEquals((Object)"<?xml>this is XML</xml> <tag>value</tag>", (Object)resource.getContent());
    }
}

