/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.core.runtime.internal;

import com.bc.ceres.core.runtime.internal.UrlHelper;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

class ModuleClassLoader
extends URLClassLoader {
    private ClassLoader[] delegates;
    private URL[] nativeUrls;
    private Map<ClassLoader, Map<String, List<URL>>> resolvedResources;

    public ModuleClassLoader(ClassLoader[] delegates, URL[] dependencyUrls, URL[] nativeUrls, ClassLoader parent) {
        super(dependencyUrls, parent);
        this.nativeUrls = nativeUrls;
        this.delegates = delegates;
        this.resolvedResources = new HashMap<ClassLoader, Map<String, List<URL>>>();
    }

    @Override
    protected String findLibrary(String libname) {
        String path;
        for (URL url : this.nativeUrls) {
            if (!url.toExternalForm().endsWith(System.mapLibraryName(libname))) continue;
            String absolutePath = UrlHelper.urlToFile(url).getAbsolutePath();
            Logger logger = Logger.getLogger(System.getProperty("ceres.context", "ceres"));
            Throwable throwable = new Throwable("This is not an exception.");
            logger.log(Level.FINEST, "Native library found: " + absolutePath, throwable);
            return absolutePath;
        }
        for (ClassLoader classLoader : this.delegates) {
            String path2;
            if (!(classLoader instanceof ModuleClassLoader) || (path2 = ((ModuleClassLoader)classLoader).findLibrary(libname)) == null) continue;
            return path2;
        }
        ClassLoader parent = this.getParent();
        if (parent instanceof ModuleClassLoader && (path = ((ModuleClassLoader)parent).findLibrary(libname)) != null) {
            return path;
        }
        return super.findLibrary(libname);
    }

    @Override
    public URL findResource(String name) {
        URL localResource = super.findResource(name);
        if (localResource != null) {
            return localResource;
        }
        for (ClassLoader delegate : this.delegates) {
            URL resource = delegate.getResource(name);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        Enumeration<URL> resources = super.findResources(name);
        if (this.delegates.length == 0) {
            return resources;
        }
        HashSet<URL> urls = new HashSet<URL>(Collections.list(resources));
        for (ClassLoader delegate : this.delegates) {
            Map<String, List<URL>> resourceMap = this.getResourceMap(delegate);
            if (resourceMap.containsKey(name)) {
                urls.addAll((Collection<URL>)resourceMap.get(name));
                continue;
            }
            ArrayList<URL> urlArrayList = Collections.list(delegate.getResources(name));
            urls.addAll(urlArrayList);
            resourceMap.put(name, urlArrayList);
        }
        return Collections.enumeration(urls);
    }

    private Map<String, List<URL>> getResourceMap(ClassLoader delegate) {
        HashMap<String, List<URL>> resourceMap;
        if (this.resolvedResources.containsKey(delegate)) {
            resourceMap = this.resolvedResources.get(delegate);
        } else {
            resourceMap = new HashMap();
            this.resolvedResources.put(delegate, resourceMap);
        }
        return resourceMap;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return super.findClass(name);
        }
        catch (ClassNotFoundException e) {
            for (ClassLoader delegate : this.delegates) {
                try {
                    return delegate.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            throw e;
        }
    }

    public ClassLoader[] getDelegates() {
        return this.delegates;
    }

    public URL[] getNativeUrls() {
        return this.nativeUrls;
    }
}

