/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.core;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ProgressMonitor;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;

public class PrintWriterProgressMonitor
implements ProgressMonitor {
    private PrintWriter printWriter;
    private boolean canceled;
    private String taskName;
    private String subTaskName;
    private double totalWork;
    private double currentWork;
    private int printMinorStepPercentage;
    private int printStepPercentage;
    private int percentageWorked;
    private int lastMinorPercentagePrinted;
    private int lastPercentagePrinted;

    public PrintWriterProgressMonitor(OutputStream output) {
        this(new PrintWriter(output, true));
    }

    public PrintWriterProgressMonitor(PrintWriter output) {
        Assert.notNull(output, "output");
        this.printWriter = output;
        this.printMinorStepPercentage = 2;
        this.printStepPercentage = 10;
    }

    public String getTaskName() {
        return this.taskName;
    }

    @Override
    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public String getSubTaskName() {
        return this.subTaskName;
    }

    @Override
    public void setSubTaskName(String subTaskName) {
        this.subTaskName = subTaskName;
    }

    public int getPrintMinorStepPercentage() {
        return this.printMinorStepPercentage;
    }

    public int getPrintStepPercentage() {
        return this.printStepPercentage;
    }

    public void setPrintMinorStepPercentage(int printMinorStepPercentage) {
        this.printMinorStepPercentage = printMinorStepPercentage;
    }

    public void setPrintStepPercentage(int printStepPercentage) {
        this.printStepPercentage = printStepPercentage;
    }

    public int getPercentageWorked() {
        return this.percentageWorked;
    }

    @Override
    public void beginTask(String name, int totalWork) {
        this.taskName = name;
        this.totalWork = totalWork;
        this.currentWork = 0.0;
        this.percentageWorked = 0;
        this.lastMinorPercentagePrinted = 0;
        this.lastPercentagePrinted = 0;
        this.canceled = false;
        this.printStartMessage(this.printWriter);
    }

    @Override
    public void done() {
        this.printDoneMessage(this.printWriter);
    }

    @Override
    public void worked(int work) {
        this.internalWorked(work);
    }

    @Override
    public void internalWorked(double work) {
        this.currentWork += work;
        this.percentageWorked = (int)(100.0 * this.currentWork / this.totalWork);
        if (this.percentageWorked - this.lastMinorPercentagePrinted >= this.getPrintMinorStepPercentage()) {
            this.lastMinorPercentagePrinted = this.percentageWorked;
            if (this.percentageWorked - this.lastPercentagePrinted >= this.getPrintStepPercentage()) {
                this.printWorkedMessage(this.printWriter);
                this.lastPercentagePrinted = this.percentageWorked;
            } else {
                this.printMinorWorkedMessage(this.printWriter);
            }
        }
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
        if (this.isCanceled()) {
            this.printCanceledMessage(this.printWriter);
        }
    }

    protected void printStartMessage(PrintWriter pw) {
        pw.printf(MessageFormat.format("{0}, started\n", this.getMessage()), new Object[0]);
    }

    protected void printWorkedMessage(PrintWriter pw) {
        pw.println(MessageFormat.format("{0}, {1}% worked", this.getMessage(), this.getPercentageWorked()));
    }

    protected void printMinorWorkedMessage(PrintWriter pw) {
    }

    protected void printDoneMessage(PrintWriter pw) {
        pw.println(MessageFormat.format("{0}, done", this.getMessage()));
    }

    protected void printCanceledMessage(PrintWriter pw) {
        pw.println(MessageFormat.format("{0}, cancelation requested", this.getMessage()));
    }

    protected String getMessage() {
        boolean validTaskName = this.taskName != null && this.taskName.length() > 0;
        boolean validSubTaskName = this.subTaskName != null && this.subTaskName.length() > 0;
        String message = "";
        if (validTaskName && validSubTaskName) {
            message = this.taskName + " - " + this.subTaskName;
        } else if (validTaskName) {
            message = this.taskName;
        } else if (validSubTaskName) {
            message = this.subTaskName;
        }
        return message;
    }
}

