/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.resource;

import com.bc.ceres.resource.Resource;
import java.util.SortedMap;
import org.junit.Assert;
import org.junit.Test;

public class ResourceTest {
    @Test
    public void testGetPath() throws Exception {
        TestResource testResource = new TestResource("path/prop", "key = value", null);
        Assert.assertEquals((Object)"path/prop", (Object)testResource.getPath());
        TestResource testResource1 = new TestResource("path/xml", "<?xml>this is XML</xml>", null);
        Assert.assertEquals((Object)"path/xml", (Object)testResource1.getPath());
    }

    @Test
    public void testisXml() throws Exception {
        TestResource testResource = new TestResource("path/prop", "key = value", null);
        Assert.assertFalse((boolean)testResource.isXml());
        TestResource testResource1 = new TestResource("path/xml", "<?xml>this is XML</xml>", null);
        Assert.assertTrue((boolean)testResource1.isXml());
    }

    @Test
    public void testGetMapXML() throws Exception {
        TestResource testResource = new TestResource("path/", "<?xml>this is XML</xml>", null);
        SortedMap map = testResource.getMap();
        Assert.assertNotNull((Object)map);
        Assert.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void testGetMapProperties() throws Exception {
        TestResource testResource = new TestResource("path", "key = value\nkey2=anothervalue\n", null);
        SortedMap map = testResource.getMap();
        Assert.assertNotNull((Object)map);
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((Object)"value", map.get("key"));
        Assert.assertEquals((Object)"anothervalue", map.get("key2"));
    }

    @Test
    public void testGetContent() throws Exception {
        Assert.assertEquals((Object)"key = value", (Object)new TestResource("", "key = value", null).getContent());
        Assert.assertEquals((Object)"<?xml>this is XML</xml>", (Object)new TestResource("", "<?xml>this is XML</xml>", null).getContent());
    }

    @Test
    public void testToString() throws Exception {
        Assert.assertEquals((Object)"key = value", (Object)new TestResource("", "key = value", null).toString());
        Assert.assertEquals((Object)"<?xml>this is XML</xml>", (Object)new TestResource("", "<?xml>this is XML</xml>", null).toString());
    }

    @Test
    public void testGetOrigin() throws Exception {
        TestResource r1 = new TestResource("r1", "key = value", null);
        TestResource r2 = new TestResource("r2", "key2 = value2", r1);
        Assert.assertNull((Object)r1.getOrigin());
        Assert.assertNotNull((Object)r2.getOrigin());
        Assert.assertSame((Object)((Object)r1), (Object)r2.getOrigin());
    }

    private static class TestResource
    extends Resource {
        private final String content;

        public TestResource(String path, String content, Resource origin) {
            super(path, origin);
            this.content = content;
        }

        protected String read() {
            return this.content;
        }
    }
}

