/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.resource;

import com.bc.ceres.resource.Resource;
import com.bc.ceres.resource.ResourceEngine;
import com.bc.ceres.resource.StringResource;
import org.apache.velocity.VelocityContext;
import org.junit.Assert;
import org.junit.Test;

public class ResourceEngineTest {
    @Test
    public void testResourceEngine() throws Exception {
        ResourceEngine engine = new ResourceEngine();
        engine.processAndAddResource("a", (Resource)new StringResource("simple", "foo bar baz"));
        VelocityContext velocityContext = engine.getVelocityContext();
        velocityContext.put("v", (Object)"direct");
        engine.processAndAddResource("b", (Resource)new StringResource("variables", "process ${a.content} in ${v} mode"));
        engine.processAndAddResource("c", (Resource)new StringResource("recursiveVariables", "do ${b.content} and ${a.content}"));
        Resource resultResource = engine.getResource("b");
        Assert.assertEquals((Object)"process foo bar baz in direct mode", (Object)resultResource.getContent());
        Resource resultC = engine.getResource("c");
        Assert.assertEquals((Object)"do process foo bar baz in direct mode and foo bar baz", (Object)resultC.getContent());
    }

    @Test
    public void testGetVelocityContext() throws Exception {
        ResourceEngine engine = new ResourceEngine();
        VelocityContext velocityContext = engine.getVelocityContext();
        Assert.assertNotNull((Object)velocityContext);
        Assert.assertEquals((long)0L, (long)velocityContext.getKeys().length);
    }

    @Test
    public void testThatResourcesAreInVelocityContext() throws Exception {
        ResourceEngine engine = new ResourceEngine();
        engine.processAndAddResource("a", (Resource)new StringResource("apath", "foo bar baz"));
        VelocityContext velocityContext = engine.getVelocityContext();
        Assert.assertEquals((long)1L, (long)velocityContext.getKeys().length);
        Object a = velocityContext.get("a");
        Assert.assertNotNull((Object)a);
        Assert.assertTrue((boolean)(a instanceof Resource));
        Resource aResource = (Resource)a;
        Assert.assertEquals((Object)"apath", (Object)aResource.getPath());
        Assert.assertEquals((Object)"foo bar baz", (Object)aResource.getContent());
        Assert.assertEquals((Object)"foo bar baz", (Object)aResource.toString());
        Assert.assertFalse((boolean)aResource.isXml());
    }

    @Test
    public void testProcessAndGetResource() throws Exception {
        ResourceEngine engine = new ResourceEngine();
        StringResource a = new StringResource("apath", "foo bar baz");
        StringResource b = new StringResource("bpath", "process ${a.content}");
        engine.processAndAddResource("a", (Resource)a);
        engine.processAndAddResource("b", (Resource)b);
        Resource aResource = engine.getResource("a");
        Assert.assertNotNull((Object)aResource);
        Assert.assertEquals((Object)"apath", (Object)aResource.getPath());
        Assert.assertEquals((Object)"foo bar baz", (Object)aResource.getContent());
        Assert.assertEquals((Object)"foo bar baz", (Object)aResource.toString());
        Assert.assertNull((Object)aResource.getOrigin());
        Resource bResource = engine.getResource("b");
        Assert.assertNotNull((Object)bResource);
        Assert.assertEquals((Object)"bpath", (Object)bResource.getPath());
        Assert.assertEquals((Object)"process foo bar baz", (Object)bResource.getContent());
        Assert.assertEquals((Object)"process foo bar baz", (Object)bResource.toString());
        Resource bOrigin = bResource.getOrigin();
        Assert.assertNotNull((Object)bOrigin);
        Assert.assertEquals((Object)"bpath", (Object)bOrigin.getPath());
        Assert.assertEquals((Object)"process ${a.content}", (Object)bOrigin.getContent());
        Assert.assertEquals((Object)"process ${a.content}", (Object)bOrigin.toString());
    }

    @Test
    public void testVelocityContextContainsResults() throws Exception {
        ResourceEngine engine = new ResourceEngine();
        StringResource a = new StringResource("apath", "foo bar baz");
        StringResource b = new StringResource("bpath", "process ${a.content}");
        engine.processAndAddResource("a", (Resource)a);
        engine.processAndAddResource("b", (Resource)b);
        VelocityContext velocityContext = engine.getVelocityContext();
        Assert.assertEquals((long)2L, (long)velocityContext.getKeys().length);
        Object obj = velocityContext.get("b");
        Assert.assertNotNull((Object)obj);
        Assert.assertTrue((boolean)(obj instanceof Resource));
        Resource bResource = (Resource)obj;
        Assert.assertEquals((Object)"bpath", (Object)bResource.getPath());
        Assert.assertEquals((Object)"process foo bar baz", (Object)bResource.getContent());
        Assert.assertEquals((Object)"process foo bar baz", (Object)bResource.toString());
    }
}

